/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.postgre;

import com.bethecoder.ascii_table.ASCIITable;
import com.mapway.database2java.database.GeneratorPool;
import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.base.SchemaBase;
import com.mapway.database2java.model.base.naming.CamelConvert;
import com.mapway.database2java.model.base.naming.LowerCaseNameConvert;
import com.mapway.database2java.model.base.naming.UpperCaseNameConvert;
import com.mapway.database2java.model.postgre.Postgre_SQLClause;
import com.mapway.database2java.model.schema.Table;
import java.sql.Connection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.nutz.lang.Lang;
import schemacrawler.schema.Catalog;
import schemacrawler.schema.Column;
import schemacrawler.schema.Schema;
import schemacrawler.schemacrawler.ExcludeAll;
import schemacrawler.schemacrawler.InclusionRule;
import schemacrawler.schemacrawler.SchemaCrawlerException;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaInfoLevelBuilder;
import schemacrawler.utility.SchemaCrawlerUtility;

public class PostgreSQLSchema
extends SchemaBase {
    public PostgreSQLSchema(IConnectionPool pool, Configure configure) {
        super(pool, configure);
        this.setSQLClause(new Postgre_SQLClause(configure.getDatabase()));
    }

    @Override
    public boolean fetchSchema() {
        this.fetchPostgreSQLMetaData();
        return true;
    }

    private void fetchPostgreSQLMetaData() {
        SchemaCrawlerOptions options = new SchemaCrawlerOptions();
        options.setSchemaInfoLevel(SchemaInfoLevelBuilder.standard());
        options.setRoutineInclusionRule((InclusionRule)new ExcludeAll());
        Catalog catalog = null;
        try {
            catalog = SchemaCrawlerUtility.getCatalog((Connection)this.a.getConnectionPool().getConnection(), (SchemaCrawlerOptions)options);
        }
        catch (SchemaCrawlerException e) {
            e.printStackTrace();
        }
        for (Schema schema : catalog.getSchemas()) {
            System.out.println(schema.getName() + "===>" + this.getConfigure().getSchema());
            if (!schema.getName().equals(this.getConfigure().getSchema())) continue;
            this.processSchema(catalog, schema);
        }
    }

    private void processSchema(Catalog catalog, Schema schema) {
        System.out.println("go schema " + schema.getName());
        for (schemacrawler.schema.Table table : catalog.getTables(schema)) {
            String[] headers = (String[])Lang.array((Object[])new String[]{"\u6a21\u5f0f", "\u8868\u540d", "\u5217\u540d", "\u662f\u5426\u4e3b\u952e", "\u662f\u5426\u9012\u589e", "\u662f\u5426\u4e3a\u7a7a", "\u6570\u636e\u7c7b\u578b"});
            Table t = new Table();
            this.getTables().addTable(t);
            t.setName(PostgreSQLSchema.trip(table.getName()));
            t.setComment(this.compass(table.getRemarks()));
            String[][] data = new String[table.getColumns().size()][];
            int i = 0;
            for (Column column : table.getColumns()) {
                com.mapway.database2java.model.schema.Column c = "LOWER_CASE".equalsIgnoreCase(this.getConfigure().getUseFieldStyle()) ? new com.mapway.database2java.model.schema.Column(new LowerCaseNameConvert()) : ("UPPER_CASE".equalsIgnoreCase(this.getConfigure().getUseFieldStyle()) ? new com.mapway.database2java.model.schema.Column(new UpperCaseNameConvert()) : new com.mapway.database2java.model.schema.Column(new CamelConvert()));
                c.setAuto(column.isAutoIncremented());
                c.setPK(column.isPartOfPrimaryKey());
                c.setName(PostgreSQLSchema.trip(column.getName()));
                c.setComment(this.compass(column.getRemarks()));
                c.setDatabaseType(column.getColumnDataType().getJavaSqlType().getJavaSqlTypeName());
                t.getColumns().addColumn(c);
                String[] row = (String[])Lang.array((Object[])new String[]{schema.getName(), table.getName(), PostgreSQLSchema.trip(column.getName()), column.isPartOfPrimaryKey() + "", column.isAutoIncremented() + "", column.isNullable() + "", column.getColumnDataType().getJavaSqlType().getJavaSqlTypeName(), c.getComment()});
                data[i++] = row;
            }
            ASCIITable.getInstance().printTable(headers, data);
        }
    }

    private String compass(String remarks) {
        if (remarks == null) {
            return "";
        }
        String dest = "";
        Pattern p = Pattern.compile("\\s*|\t|\r|\n");
        Matcher m = p.matcher(remarks);
        dest = m.replaceAll("");
        return dest;
    }

    private static String trip(String name) {
        return name.replaceAll("\\\"", "");
    }

    public static void main(String[] args) {
        String driverName = "org.postgresql.Driver";
        String jdbcurl = "jdbc:postgresql://pg.ennwifi.cn/bigdata";
        String username = "bigdata";
        String pwd = "bigdata";
        try {
            Class.forName(driverName);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        GeneratorPool pool = new GeneratorPool(driverName, jdbcurl, username, pwd, "", "", 100);
        Configure configure = new Configure();
        PostgreSQLSchema schema = new PostgreSQLSchema(pool, configure);
        schema.fetchSchema();
    }
}

