/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.mysql;

import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.base.SchemaBase;
import com.mapway.database2java.model.mysql.MySQL_SQLClause;
import com.mapway.database2java.model.schema.Argument;
import com.mapway.database2java.model.schema.Arguments;
import com.mapway.database2java.model.schema.Column;
import com.mapway.database2java.model.schema.Columns;
import com.mapway.database2java.model.schema.ITable;
import com.mapway.database2java.model.schema.Pack;
import com.mapway.database2java.model.schema.Procedure;
import com.mapway.database2java.model.schema.Procedures;
import com.mapway.database2java.model.schema.Table;
import com.mapway.database2java.model.schema.Tables;
import com.mapway.database2java.model.schema.View;
import java.sql.SQLException;
import java.util.Date;
import javax.servlet.jsp.jstl.sql.Result;

public class MySQL_Schema2
extends SchemaBase {
    @Override
    public String getCopyright() {
        Date d = new Date();
        String s = "/*******************************************************************************\r\nzhangjianshe@gmail.com PHONE:15910868681\r\n";
        s = s + super.getHeader();
        s = s + "/******************************************************************************/\r\n";
        return s;
    }

    public MySQL_Schema2(IConnectionPool pool, Configure configure) {
        super(pool, configure);
        this.setSQLClause(new MySQL_SQLClause(configure.getSchema()));
    }

    @Override
    public boolean fetchSchema() {
        Long big;
        int l;
        Column col;
        Result rs;
        super.fetchSchema();
        try {
            rs = this.a.execute(this.getSQLClause().getTableSQL());
            System.out.println(this.a.resultToString(rs));
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        Object[][] b = rs.getRowsByIndex();
        String old = "";
        Table tab = null;
        Columns cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            String extra = (String)c[8];
            if (!tn.equals(old)) {
                old = tn;
                tab = new Table();
                tab.setName(tn.toUpperCase());
                tab.setComment(tc);
                cols = tab.getColumns();
                this.getTables().addTable(tab);
            }
            col = new Column();
            col.setName(cn.toUpperCase());
            col.setDatabaseType(ct);
            col.setComment(cc);
            l = 0;
            if (c[4] != null && c[4].getClass().getName().indexOf("Long") >= 0) {
                big = (Long)c[4];
                l = big.intValue();
            }
            col.setLength(l);
            if (extra != null && extra.indexOf("auto_increment") >= 0) {
                col.setAuto(true);
            } else {
                col.setAuto(false);
            }
            col.setPK(this.isPK(tn, cn));
            cols.addColumn(col);
        }
        try {
            rs = this.a.execute(this.getSQLClause().getViewSQL());
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        b = rs.getRowsByIndex();
        old = "";
        View view = null;
        cols = null;
        for (int i = 0; i < rs.getRowCount(); ++i) {
            Object[] c = b[i];
            String tn = (String)c[1];
            String tc = (String)c[0];
            String cn = (String)c[2];
            String ct = (String)c[3];
            String cc = (String)c[7];
            if (!tn.equals(old)) {
                old = tn;
                view = new View();
                view.setName(tn.toUpperCase());
                view.setComment(tc);
                cols = view.getColumns();
                this.getViews().addView(view);
            }
            col = new Column();
            col.setName(cn.toUpperCase());
            col.setDatabaseType(ct);
            col.setComment(cc);
            l = 0;
            if (c[4] != null && c[4].getClass().getName().indexOf("Long") >= 0) {
                big = (Long)c[4];
                l = big.intValue();
            }
            col.setLength(l);
            cols.addColumn(col);
        }
        return true;
    }

    @Override
    public String exportTable(ITable table, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        Configure cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".modle");
        this.writeJavaBean(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "/modle", table.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaObjs(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "/modle", table.getName() + "Objs.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".dao");
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaInterface(table, sb, cf);
        this.writeToFile(cf.getFilePath(), "I" + table.getName() + "DAO.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".dao." + cf.getDatabase() + ".impl");
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJavaAccess(table, sb, cf);
        this.writeToFile(cf.getFilePath(), table.getName() + "DAOImpl.java", sb.toString());
        return "";
    }

    private void writeJavaInterface(ITable table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".modle." + table.getJavaName() + ";");
        this.out(sb, "import " + p + ".modle." + table.getJavaNames() + ";");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u04ff\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public interface I" + table.getName() + "DAO {\r\n");
        this.out(sb, "\tpublic Result execute(String sql) throws SQLException;");
        this.out(sb, "\tpublic ExecuteResult execute2Result(String sql) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\r\n" + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toLowerCase() + ")throws SQLException;");
        }
        this.out(sb, "\t public void setMapByIndex(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b );");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values);");
        this.out(sb, "public ExecuteResult getSpecificRecordByWhereTemplate2ExetureResult  (String whereTemplate,int start,int end,Object...values);");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\u027e\ufffd\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param boolean");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        StringBuilder param = new StringBuilder();
        StringBuilder param2 = new StringBuilder();
        StringBuilder param3 = new StringBuilder();
        for (int i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col2 = table.getColumns().getAt(i2);
            if (!col2.isPK()) continue;
            this.out(sb, "\t* @Param " + col2.getName().toLowerCase());
            param.append(col2.getJavaType() + " " + col2.getName().toLowerCase() + ",");
            param2.append("`" + col2.getName() + "`=? AND ");
            param3.append(col2.getName().toLowerCase() + ",");
        }
        if (param.length() > 1) {
            param.deleteCharAt(param.length() - 1);
        }
        if (param2.length() > 4) {
            param2.setLength(param2.length() - 4);
        }
        if (param3.length() > 1) {
            param3.deleteCharAt(param3.length() - 1);
        }
        if (table.hasPK()) {
            this.out(sb, "\t/**");
            this.out(sb, "\t* @return " + table.getJavaName());
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " selectByPK  (" + param.toString() + ") throws SQLException;");
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE \ufffd\ufffd\ufffd\ufffd\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
            this.out(sb, "\t* @param " + param.toString());
            this.out(sb, "\t* @return boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic boolean deleteByPK(" + param.toString() + " ) throws SQLException;");
        }
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObject  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObjects  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\u00b6\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean updateObjectsByPK  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/  ");
        this.out(sb, "\tpublic boolean updateObjectByPK  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u0123\ufffd\ufffdSQL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u013c\ufffd\u00bc  ");
        this.out(sb, "\t* <code>sqlTemplate=\"FIELDA =? ,FIELDB=? where FIELDC=?\";</code> ");
        this.out(sb, "\t* @param sqlTemplate ");
        this.out(sb, "\t* @param values  ");
        this.out(sb, "\t* @return boolean ");
        this.out(sb, "\t*/ ");
        this.out(sb, "\tpublic boolean updateBySQLTemplate  (String sqlTemplate,Object...values)  throws SQLException;");
        this.out(sb, "}");
    }

    private void writeJavaBean(ITable table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String s = conf.getPackage();
        int index = s.lastIndexOf(".");
        s = s.substring(0, index) + ".json";
        this.out(sb, "import " + s + ".JSONHelper;");
        this.out(sb, "/**\r\n");
        this.out(sb, " * \ufffd\u05b6\ufffd\ufffd\u0431\ufffd\r\n");
        this.out(sb, " * @author zjs\r\n");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, " * " + col.getName() + "   " + col.getComment() + " " + col.getJavaType());
        }
        this.out(sb, " */\r\n");
        this.out(sb, "public class " + table.getJavaName() + " implements java.io.Serializable{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate static final long serialVersionUID = 1L;");
        this.out(sb, "\t/**");
        this.out(sb, "\t*\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043b\ufffduid");
        this.out(sb, "\t*/");
        this.out(sb, "\tstatic long getSerialVersionUID() {");
        this.out(sb, "\treturn serialVersionUID;");
        this.out(sb, "\t}");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment() + "  " + col.getDatabaseType());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment() + "  " + col.getDatabaseType());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
        }
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"----\":this.get" + col.getName() + "().toString());");
            this.out(sb, "\t\tsb.append(\" | \");");
        }
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\t/**                                     ");
        this.out(sb, "\t\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u03aaXML\ufffd\ufffd\ufffd\ufffd                  ");
        this.out(sb, "\t\t * @return                              ");
        this.out(sb, "\t\t */                                     ");
        this.out(sb, "\t\tpublic String toXMLProperty()   ");
        this.out(sb, "\t\t{                                       ");
        this.out(sb, "\t\t\tStringBuilder sb=new StringBuilder(); ");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + "=\\\"\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXML(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXMLthis.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXML(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
            }
            this.out(sb, "\t\tsb.append(\"\\\" \");");
        }
        this.out(sb, "\t\treturn sb.toString();                   ");
        this.out(sb, "\t\t}                                       ");
        this.out(sb, "\t\t/**                                     ");
        this.out(sb, "\t\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u03aaXML\ufffd\ufffd\ufffd\ufffd                    ");
        this.out(sb, "\t\t * @param tag                           ");
        this.out(sb, "\t\t * @return                              ");
        this.out(sb, "\t\t */                                     ");
        this.out(sb, "\t\tpublic String toXMLString(String tag)   ");
        this.out(sb, "\t\t{                                       ");
        this.out(sb, "\t\t\tStringBuilder sb=new StringBuilder(); ");
        this.out(sb, "\t\t\tif(tag==null || tag.equals(\"\"))       ");
        this.out(sb, "\t\t\t{                                     ");
        this.out(sb, "\t\t\t\tsb.append(\"<" + table.getName().toUpperCase() + " \");         ");
        this.out(sb, "\t\t\t}                                     ");
        this.out(sb, "\t\t\telse                                  ");
        this.out(sb, "\t\t\t{                                     ");
        this.out(sb, "\t\t\t\tsb.append(\"<\");                     ");
        this.out(sb, "\t\t\t\tsb.append(tag);                     ");
        this.out(sb, "\t\t\t\tsb.append(\" \");                     ");
        this.out(sb, "\t\t\t}                                     ");
        this.out(sb, "\t\t\t                                      ");
        this.out(sb, "\t\t\tsb.append(toXMLProperty());                                      ");
        this.out(sb, "\t\t\t                                      ");
        this.out(sb, "\t\t\tsb.append(\"/>\\r\\n\");                     ");
        this.out(sb, "\t\t\treturn sb.toString();                 ");
        this.out(sb, "\t\t}  ");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tsb.append(\"{\");");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + ":\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(JSONHelper.escape(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
                this.out(sb, "\t\tsb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
                this.out(sb, "sb.append(\"\\\"\");");
            }
            this.out(sb, "\t\tsb.append(\",\");");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\tsb.append(\"}\");");
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void writeJavaObjs(ITable table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import java.util.Iterator;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + " extends ArrayList<" + table.getJavaName() + ">{\r\n\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tsuper();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tfor(int i=0;i<this.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.get(i).toString());");
        this.out(sb, "\t\t\tsb.append(\"\\r\\n\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdJSON\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tif(this.size()>0)");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\t\tsb.append(\"[\");");
        this.out(sb, "\t\tfor(int i=0;i<this.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.get(i).toJSONString());");
        this.out(sb, "\t\t\tsb.append(\",\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\t\tsb.append(\"]\");");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\telse");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\t\treturn \"[]\";");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**                                               ");
        this.out(sb, "\t * \ufffd\ufffd\ufffdXML\ufffd\u06b5\ufffd\ufffd\u05b7\ufffd                              ");
        this.out(sb, "\t * @return                                        ");
        this.out(sb, "\t */                                               ");
        this.out(sb, "\tpublic String toXMLString(String tag,String tag1) ");
        this.out(sb, "\t{                                                 ");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();           ");
        this.out(sb, "\t\tif(tag==null || tag.equals(\"\"))                 ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"<" + table.getName() + "S \");                           ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\telse                                            ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"<\");                               ");
        this.out(sb, "\t\t\tsb.append(tag);                               ");
        this.out(sb, "\t\t\tsb.append(\" \");                               ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tsb.append(\"size=\\\"\");                           ");
        this.out(sb, "\t\tsb.append(this.size());                         ");
        this.out(sb, "\t\tsb.append(\"\\\" >\\r\\n\");                          ");
        this.out(sb, "\t\t                                                ");
        this.out(sb, "\t\tIterator<" + table.getJavaName() + "> it=this.iterator();          ");
        this.out(sb, "\t\twhile(it.hasNext())                             ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\t" + table.getJavaName() + " obj=it.next();                       ");
        this.out(sb, "\t\t\tsb.append(\"\\t\");                              ");
        this.out(sb, "\t\t\tsb.append(obj.toXMLString(tag1));             ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tif(tag==null || tag.equals(\"\"))                 ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"</" + table.getName() + "S>\");                          ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\telse                                            ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"</\");                              ");
        this.out(sb, "\t\t\tsb.append(tag);                               ");
        this.out(sb, "\t\t\tsb.append(\">\");                               ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tsb.append(\"\\r\\n\");                           ");
        this.out(sb, "\t\treturn sb.toString();                           ");
        this.out(sb, "\t}                                                 ");
        this.out(sb, "}");
    }

    private void writeJavaAccess(ITable table, StringBuilder sb, Configure conf) {
        int i;
        Column col;
        int i2;
        Column col2;
        int i3;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        for (int i4 = 0; i4 < table.getColumns().getCount(); ++i4) {
            if (!table.getColumns().getAt(i4).getJavaType().equals("byte[]")) continue;
            this.out(sb, "import java.sql.Blob;");
            break;
        }
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import java.sql.Statement;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        this.out(sb, "import " + p + ".base.AccessBase;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".base.IConnectionPool;\r\n");
        this.out(sb, "import " + p + ".dao.I" + table.getName() + "DAO;\r\n");
        this.out(sb, "import " + p + ".modle." + table.getJavaName() + ";\r\n");
        this.out(sb, "import " + p + ".modle." + table.getJavaNames() + ";\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getName() + "DAOImpl extends AccessBase implements I" + table.getName() + "DAO{\r\n");
        this.out(sb, "\tpublic " + table.getName() + "DAOImpl(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean bMapByIndex=true;\r\n");
        this.out(sb, "\tpublic void setMapByIndex(boolean b)");
        this.out(sb, "{");
        this.out(sb, "\tbMapByIndex=b;");
        this.out(sb, "}");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\tint i=1;");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        this.out(sb, "\t if(true==bMapByIndex){");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            if (col2.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(bytesFromBlob(rs.getBlob(i++)));");
                continue;
            }
            if (col2.getDatabaseType().equals("NUMBER") || col2.getDatabaseType().equals("NUMERIC") || col2.getDatabaseType().equals("SMALLINT") || col2.getDatabaseType().equals("INTEGER") || col2.getDatabaseType().equals("BIGINT") || col2.getDatabaseType().equals("REAL") || col2.getDatabaseType().equals("FLOAT") || col2.getDatabaseType().equals("DOUBLE") || col2.getDatabaseType().equals("integer") || col2.getDatabaseType().equals("smallint") || col2.getDatabaseType().equals("mediumint") || col2.getDatabaseType().equals("int") || col2.getDatabaseType().equals("bigint") || col2.getDatabaseType().equals("double") || col2.getDatabaseType().equals("float") || col2.getDatabaseType().equals("enum") || col2.getDatabaseType().equals("set")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]){ \r\n\t\t\trs.get" + col2.getJavaType4() + "(i);o.set" + col2.getName() + "(true==rs.wasNull()?null:rs.get" + col2.getJavaType4() + "(i));i++;\r\n\t\t}");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(rs.get" + col2.getJavaType4() + "(i++));");
        }
        this.out(sb, "\t }else {");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            if (col2.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(bytesFromBlob(rs.getBlob(\"" + col2.getName() + "\")));");
                continue;
            }
            if (col2.getDatabaseType().equals("NUMBER") || col2.getDatabaseType().equals("NUMERIC") || col2.getDatabaseType().equals("SMALLINT") || col2.getDatabaseType().equals("INTEGER") || col2.getDatabaseType().equals("BIGINT") || col2.getDatabaseType().equals("REAL") || col2.getDatabaseType().equals("FLOAT") || col2.getDatabaseType().equals("DOUBLE") || col2.getDatabaseType().equals("integer") || col2.getDatabaseType().equals("smallint") || col2.getDatabaseType().equals("mediumint") || col2.getDatabaseType().equals("int") || col2.getDatabaseType().equals("bigint") || col2.getDatabaseType().equals("double") || col2.getDatabaseType().equals("float") || col2.getDatabaseType().equals("enum") || col2.getDatabaseType().equals("set")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]){ \r\n\t\t\trs.get" + col2.getJavaType4() + "(\"" + col2.getName() + "\");o.set" + col2.getName() + "(true==rs.wasNull()?null:rs.get" + col2.getJavaType4() + "(\"" + col2.getName() + "\"));\r\n\t\t}");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i3 + "]) o.set" + col2.getName() + "(rs.get" + col2.getJavaType4() + "(\"" + col2.getName() + "\"));");
        }
        this.out(sb, "\t }");
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col2.getComment() + "\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " findBy" + col2.getName() + "  (" + col2.getJavaType() + " " + col2.getName().toLowerCase() + ") throws SQLException{");
            this.out(sb, "\t\t" + table.getJavaNames() + " objs=null;");
            this.out(sb, "\t\tString where=\"where " + col2.getName() + "=? \";");
            this.out(sb, "\t\tobjs=this.selectByWhereTemplate(where," + col2.getName().toLowerCase() + ");");
            this.out(sb, "\t\tif(objs.size()>0){ ");
            this.out(sb, "\t\treturn objs.get(0);");
            this.out(sb, "\t\t} ");
            this.out(sb, "\t\treturn null; ");
            this.out(sb, "\t} ");
        }
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col2.getComment() + " [" + col2.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col2.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i3 + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            col2 = table.getColumns().getAt(i3);
            if (col2.getDatabaseType().equals("geometry")) {
                this.out(sb, "\t\tif( true == m_searched[" + i3 + "]){sb.append(\"astext(" + col2.getName() + ") " + col2.getName() + ",\");}");
                continue;
            }
            this.out(sb, "\t\tif( true == m_searched[" + i3 + "]){sb.append(\"`" + col2.getName() + "`,\");}");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult getSpecificRecordByWhereTemplate2ExetureResult  (String whereTemplate,int start,int end,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tif(whereTemplate==null )whereTemplate=\"\";");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end-start);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tif(whereTemplate==null )whereTemplate=\"\";");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end-start);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        if (table.hasPK()) {
            String key = "";
            for (int i5 = 0; i5 < table.getColumns().getCount(); ++i5) {
                Column col3 = table.getColumns().getAt(i5);
                if (!col3.isPK()) continue;
                key = col3.getName();
                break;
            }
            this.out(sb, "\t\tsql.append(\"count(" + key + ")\");");
        } else {
            this.out(sb, "\t\tsql.append(\"count(" + table.getColumns().getAt(0).getName() + ")\");");
        }
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\u027e\ufffd\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param boolean");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean deleteByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"DELETE FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tboolean b=false;");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0221" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
        StringBuilder param = new StringBuilder();
        StringBuilder param2 = new StringBuilder();
        StringBuilder param3 = new StringBuilder();
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col4 = table.getColumns().getAt(i2);
            if (!col4.isPK()) continue;
            this.out(sb, "\t* @Param " + col4.getName().toLowerCase());
            param.append(col4.getJavaType() + " " + col4.getName().toLowerCase() + ",");
            param2.append("`" + col4.getName() + "`=? AND ");
            param3.append(col4.getName().toLowerCase() + ",");
        }
        if (param.length() > 1) {
            param.deleteCharAt(param.length() - 1);
        }
        if (param2.length() > 4) {
            param2.setLength(param2.length() - 4);
        }
        if (param3.length() > 1) {
            param3.deleteCharAt(param3.length() - 1);
        }
        if (table.hasPK()) {
            this.out(sb, "\t* @return " + table.getJavaName());
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " selectByPK  (" + param.toString() + ") throws SQLException{");
            this.out(sb, "\t\tStringBuilder sql = new StringBuilder();");
            this.out(sb, "\t\tsql.append(\"SELECT \");");
            this.out(sb, "\t\tsql.append(searchField());");
            this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` WHERE \"); ");
            this.out(sb, "\t\tsql.append(\"" + param2.toString() + "\" );");
            this.out(sb, "\t\t" + table.getJavaName() + " o = null;");
            this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
            this.out(sb, "\t\tPreparedStatement statement=null;");
            this.out(sb, "\t\ttry{");
            this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
            int index = 1;
            for (int i6 = 0; i6 < table.getColumns().getCount(); ++i6) {
                col = table.getColumns().getAt(i6);
                if (!col.isPK()) continue;
                this.out(sb, "\t\t\tstatement.set" + col.getJavaType2() + "(" + index + "," + col.getName().toLowerCase() + ");");
                ++index;
            }
            this.out(sb, "\t\t\tResultSet rs = statement.executeQuery();");
            this.out(sb, "\t\t\tif (rs.next()){");
            this.out(sb, "\t\t\t\to = this.mapRecord2Obj(rs);");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\t\trs.close();");
            this.out(sb, "\t\t\tif(statement!=null) statement.close();");
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\tcatch (SQLException e){");
            this.out(sb, "\t\t\te.printStackTrace();");
            this.out(sb, "\t\t\tthrow e;");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\tfinally{");
            this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
            this.out(sb, "\t\t}");
            this.out(sb, "\t\treturn o;");
            this.out(sb, "\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffdORACLE \ufffd\ufffd\ufffd\ufffd\u027e\ufffd\ufffd" + table.getComment() + "[" + table.getName() + "]\ufffd\u0435\u0135\ufffd\ufffd\ufffd\ufffd\ufffd\u00bc");
            this.out(sb, "\t* @param " + param.toString());
            this.out(sb, "\t* @return boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic boolean deleteByPK(" + param.toString() + " ) throws SQLException");
            this.out(sb, "\t{");
            this.out(sb, "\tString sql=\" WHERE " + param2.toString() + "\";");
            this.out(sb, "\tboolean b=deleteByWhereTemplate(sql," + param3.toString() + " );");
            this.out(sb, "\treturn b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObject  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"INSERT INTO `" + table.getName() + "` (\");");
        this.out(sb, "\t\tStringBuilder s1=new StringBuilder();");
        this.out(sb, "\t\tStringBuilder s2=new StringBuilder();");
        this.out(sb, "\t\tint index=1;");
        for (i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            Column col5 = table.getColumns().getAt(i2);
            this.out(sb, "\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged(" + i2 + ")==true){");
            this.out(sb, "\t\t\ts1.append(\"`" + col5.getName() + "`,\");");
            if (col5.getDatabaseType().equals("geometry")) {
                this.out(sb, "\t\t\ts2.append(\" geomfromtext(?) ,\");");
            } else {
                this.out(sb, "\t\t\ts2.append(\" ? ,\");");
            }
            this.out(sb, "\t\t}");
        }
        this.out(sb, "\t\ts1.deleteCharAt(s1.length()-1);");
        this.out(sb, "\t\ts2.deleteCharAt(s2.length()-1);");
        this.out(sb, "\t\ts2.append(\")\");");
        this.out(sb, "\t\tsql.append(s1.toString());");
        this.out(sb, "\t\tsql.append(\" ) VALUES ( \");");
        this.out(sb, "\t\tsql.append(s2.toString());");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString(),Statement.RETURN_GENERATED_KEYS);");
        int cur = 0;
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        this.out(sb, "\t\t\tb = statement.execute();");
        if (table.hasAuto()) {
            this.out(sb, "\t\t\tResultSet rs=statement.getGeneratedKeys();");
            this.out(sb, "\t\t\twhile(rs.next())");
            this.out(sb, "\t\t\t{");
            this.out(sb, "\t\t\t int index1=1;");
            for (i = 0; i < table.getColumns().getCount(); ++i) {
                col = table.getColumns().getAt(i);
                if (!col.isAuto()) continue;
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==false ){ " + table.getJavaName().toLowerCase() + ".set" + col.getName() + "(rs.get" + col.getJavaType4() + "(index1++));}");
            }
            this.out(sb, "\t\t\t}");
            this.out(sb, "\t\t\trs=null;");
        }
        this.out(sb, "\t\t\tif(statement!=null);");
        this.out(sb, "    {");
        this.out(sb, "    \tstatement.close();");
        this.out(sb, "    \tstatement=null;");
        this.out(sb, "    }");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0432\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean insertObjects  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".size();i++){");
        this.out(sb, "\t\t\tthis.insertObject(" + table.getJavaNames().toLowerCase() + ".get(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\u00b6\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @param " + table.getJavaNames().toLowerCase());
        this.out(sb, "\t* @return boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean updateObjectsByPK  (" + table.getJavaNames() + " " + table.getJavaNames().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tboolean b = false;");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getJavaNames().toLowerCase() + ".size();i++){");
        this.out(sb, "\t\t\tthis.updateObjectByPK(" + table.getJavaNames().toLowerCase() + ".get(i));");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tb=true;");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\u0438\ufffd\ufffd\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd ");
        this.out(sb, "\t* @param " + table.getName());
        this.out(sb, "\t*/  ");
        this.out(sb, "\tpublic boolean updateObjectByPK  (" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + " ) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"UPDATE `" + table.getName() + "` SET \");");
        this.out(sb, "\t\tint index=1;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (!col.isPK()) {
                System.out.println("\tCOLUMN " + i + ":" + col.isPK() + ":" + col.getName());
                if (col.getDatabaseType().equals("geometry")) {
                    this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ) sql.append(\"" + col.getName() + " =geomfromtext(?),\");");
                } else {
                    this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ) sql.append(\"" + col.getName() + " =?,\");");
                }
            }
            System.out.println("COLUMN " + i + ":" + col.isPK() + ":" + col.getName());
        }
        this.out(sb, "\t\t\tsql.deleteCharAt(sql.length()-1);");
        this.out(sb, "\t\t\tsql.append(\"  WHERE " + param2.toString() + "\");");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(sql.toString());");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.isPK()) continue;
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\t\tBlob blob" + String.valueOf(cur) + "=oracle.sql.BLOB.createTemporary(con, true, oracle.sql.BLOB.DURATION_SESSION);");
                this.out(sb, "\t\t\tblob" + String.valueOf(cur) + ".setBytes(1, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());");
                this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.setBlob(index, blob" + String.valueOf(cur++) + ");index++;}");
                continue;
            }
            this.out(sb, "\t\t\tif(" + table.getJavaName().toLowerCase() + ".getChanged( " + i + " ) ==true ){ statement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;}");
        }
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (!col.isPK()) continue;
            this.out(sb, "\t\t\tstatement.set" + col.getJavaType2() + "(index, " + table.getJavaName().toLowerCase() + ".get" + col.getName() + "());index++;");
        }
        this.out(sb, "\t\t\tb = statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e){");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/** ");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u0123\ufffd\ufffdSQL\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u013c\ufffd\u00bc  ");
        this.out(sb, "\t* <code>sqlTemplate=\"FIELDA =? ,FIELDB=? where FIELDC=?\";</code> ");
        this.out(sb, "\t* @param sqlTemplate ");
        this.out(sb, "\t* @param values  ");
        this.out(sb, "\t* @return boolean ");
        this.out(sb, "\t*/ ");
        this.out(sb, "\tpublic boolean updateBySQLTemplate  (String sqlTemplate,Object...values)  throws SQLException{");
        this.out(sb, "\t\tboolean b=false; ");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return false;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry{");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(\"UPDATE `" + table.getName() + "` SET \"+sqlTemplate);");
        this.out(sb, "\t\t\tint count=findCount(sqlTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tb=statement.execute();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    @Override
    public void exportViews(View table, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        Configure cf = conf.copy();
        System.out.println("Export views start==============");
        System.out.println(conf.getPackage());
        cf.setPackage(conf.getPackage() + ".modle");
        this.WriteViewBean(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "/modle", table.getName() + "Obj.java", sb.toString());
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewObjs(table, sb, cf);
        this.writeToFile(conf.getFilePath() + "/modle", table.getName() + "Objs.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".dao");
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewInterface(table, sb, cf);
        this.writeToFile(cf.getFilePath(), "I" + table.getName() + "DAO.java", sb.toString());
        cf = conf.copy();
        cf.setPackage(conf.getPackage() + ".dao." + cf.getDatabase() + ".impl");
        sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.WriteViewAccess(table, sb, cf);
        this.writeToFile(cf.getFilePath(), table.getName() + "DAOImpl.java", sb.toString());
    }

    private void WriteViewInterface(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".modle." + table.getJavaName() + ";");
        this.out(sb, "import " + p + ".modle." + table.getJavaNames() + ";");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\u04ff\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public interface I" + table.getName() + "DAO {\r\n");
        this.out(sb, "\tpublic Result execute(String sql) throws SQLException;");
        this.out(sb, "\tpublic ExecuteResult execute2Result(String sql) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\r\n" + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toLowerCase() + ")throws SQLException;;");
        }
        this.out(sb, "\t public void setMapByIndex(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b);");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b );");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values);");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException;");
        this.out(sb, "public ExecuteResult getSpecificRecordByWhereTemplate2ExetureResult  (String whereTemplate,int start,int end,Object...values);");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException;");
        this.out(sb, "}");
    }

    private void WriteViewAccess(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        for (int i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            if (!table.getColumns().getAt(i2).getJavaType().equals("byte[]")) continue;
            this.out(sb, "import java.sql.Blob;");
            break;
        }
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.math.BigDecimal;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        String pac = conf.getPackage();
        int pos = pac.lastIndexOf(46);
        String p = pac.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        pos = p.lastIndexOf(46);
        p = p.substring(0, pos);
        this.out(sb, "import " + p + ".base.AccessBase;");
        this.out(sb, "import " + p + ".base.ExecuteResult;");
        this.out(sb, "import " + p + ".base.IConnectionPool;\r\n");
        this.out(sb, "import " + p + ".dao.I" + table.getName() + "DAO;\r\n");
        this.out(sb, "import " + p + ".modle." + table.getJavaName() + ";\r\n");
        this.out(sb, "import " + p + ".modle." + table.getJavaNames() + ";\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment() + "  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u077f\ufffd\ufffd\ufffd");
        this.out(sb, " */");
        this.out(sb, "public class " + table.getName() + "DAOImpl extends AccessBase implements I" + table.getName() + "DAO{\r\n");
        this.out(sb, "\tpublic " + table.getName() + "DAOImpl(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t\tm_searched=new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetSearched(true);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate boolean bMapByIndex=true;\r\n");
        this.out(sb, "\tpublic void setMapByIndex(boolean b)");
        this.out(sb, "{");
        this.out(sb, "\tbMapByIndex=b;");
        this.out(sb, "}");
        this.out(sb, "\tprivate boolean[] m_searched;\r\n");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + "\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "public " + table.getJavaName() + " findBy" + col.getName() + "(" + col.getJavaType() + " " + col.getName().toLowerCase() + ") throws SQLException{");
            this.out(sb, "\t\t" + table.getJavaNames() + " objs=null;");
            this.out(sb, "\t\tString where=\"where " + col.getName() + "=? \";");
            this.out(sb, "\t\tobjs=this.selectByWhereTemplate(where," + col.getName().toLowerCase() + ");");
            this.out(sb, "\t\tif(objs.size()>0){ ");
            this.out(sb, "\t\treturn objs.get(0);");
            this.out(sb, "\t\t} ");
            this.out(sb, "\t\treturn null; ");
            this.out(sb, "\t} ");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\u01f7\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\u03b1\ufffd\u05be");
        this.out(sb, "\t * @param b");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void resetSearched(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_searched[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return Result");
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic Result selectAll2Result() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate2(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\u0221\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u043c\ufffd\u00bc");
        this.out(sb, "\t * @return " + table.getJavaNames());
        this.out(sb, "\t * @throws SQLException");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectAll() throws SQLException{");
        this.out(sb, "\t\treturn selectByWhereTemplate(\"\");");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdResultSet\ufffd\u0435\ufffd\u04bb\ufffd\ufffd\ufffd\ufffd\u00bc\u05ea\ufffd\ufffd\u03aa\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* @Param ResultSet rs");
        this.out(sb, "\t* @return " + table.getJavaName());
        this.out(sb, "\t* @throws SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + " mapRecord2Obj(ResultSet rs) throws SQLException");
        this.out(sb, "\t{");
        this.out(sb, "\t\tint i=1;");
        this.out(sb, "\t\t" + table.getJavaName() + " o=new " + table.getJavaName() + "();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i + "]) o.set" + col.getName() + "(bytesFromBlob(rs.getBlob(i++)));");
                continue;
            }
            if (col.getDatabaseType().equals("NUMBER") || col.getDatabaseType().equals("NUMERIC") || col.getDatabaseType().equals("SMALLINT") || col.getDatabaseType().equals("INTEGER") || col.getDatabaseType().equals("BIGINT") || col.getDatabaseType().equals("REAL") || col.getDatabaseType().equals("FLOAT") || col.getDatabaseType().equals("DOUBLE") || col.getDatabaseType().equals("integer") || col.getDatabaseType().equals("smallint") || col.getDatabaseType().equals("mediumint") || col.getDatabaseType().equals("int") || col.getDatabaseType().equals("bigint") || col.getDatabaseType().equals("double") || col.getDatabaseType().equals("float") || col.getDatabaseType().equals("enum") || col.getDatabaseType().equals("set")) {
                this.out(sb, "\t\tif(true ==m_searched[" + i + "]){ \r\n\t\t\trs.get" + col.getJavaType4() + "(\"" + col.getName() + "\");o.set" + col.getName() + "(true==rs.wasNull()?null:rs.get" + col.getJavaType4() + "(\"" + col.getName() + "\"));\r\n\t\t}");
                continue;
            }
            this.out(sb, "\t\tif(true ==m_searched[" + i + "]) o.set" + col.getName() + "(rs.get" + col.getJavaType4() + "(\"" + col.getName() + "\"));");
        }
        this.out(sb, "\t\to.resetChanged(false);");
        this.out(sb, "\t\treturn o;");
        this.out(sb, "\t}\r\n");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t/**");
            this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd " + col.getComment() + " [" + col.getName() + "] \ufffd\u01f7\ufffd\ufffd\u046f");
            this.out(sb, "\t* @Param boolean");
            this.out(sb, "\t*/");
            this.out(sb, "\tpublic void setSearched" + col.getName() + "( boolean b ){");
            this.out(sb, "\t\tm_searched[ " + i + " ] = b;");
            this.out(sb, "\t}\r\n");
        }
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd");
        this.out(sb, "\t* @return String");
        this.out(sb, "\t*/");
        this.out(sb, "\tprivate String searchField(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            if (col.getDatabaseType().equals("geometry")) {
                this.out(sb, "\t\tif( true == m_searched[" + i + "]){sb.append(\"astext(" + col.getName() + ") " + col.getName() + ",\");}");
                continue;
            }
            this.out(sb, "\t\tif( true == m_searched[" + i + "]){sb.append(\"`" + col.getName() + "`,\");}");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " selectByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult selectByWhereTemplate2ExetureResult  (String whereTemplate,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd \ufffd\ufffd\ufffd\u0635\u013d\ufffd\ufffd<p>");
        this.out(sb, "\t* ExecuteResult  \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b5\ufffd\u043c\ufffd\u04aa\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd\u05b5\ufffd\ufffd\u98ec\ufffd\ufffd\ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "\t* <code>if(rs!=null){.... rs.dispose();}</code>");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @see ExecuteResult");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic ExecuteResult getSpecificRecordByWhereTemplate2ExetureResult  (String whereTemplate,int start,int end,Object...values) {");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tif(whereTemplate==null )whereTemplate=\"\";");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end-start);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\treturn new ExecuteResult(this.ConnectionPool,con,rs,statement);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffdwhere\ufffd\ufffd\ufffd\ufffd\u0221\ufffd\ufffd\ufffd\u013c\ufffd\u00bc\ufffd\ufffd\ufffd\u0437\ufffd\ufffd\ufffd start < X < end \ufffd\u013c\ufffd\u00bc");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @param start");
        this.out(sb, "\t* @param end");
        this.out(sb, "\t* @return " + table.getJavaNames());
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaNames() + " getSpecificRecordByWhereTemplate  (String whereTemplate,int start, int end, Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tif(whereTemplate==null )whereTemplate=\"\";");
        this.out(sb, "\t\t    sql.append(\"select \");");
        this.out(sb, "\t\t    sql.append(searchField());");
        this.out(sb, "\t\t    sql.append(\" from `\");");
        this.out(sb, "\t\t    sql.append(\"" + table.getName() + "` \"); ");
        this.out(sb, "\t\t    sql.append(whereTemplate);");
        this.out(sb, "\t\t    sql.append(\" limit \");");
        this.out(sb, "\t\t    sql.append(start);");
        this.out(sb, "\t\t    sql.append(\",\");");
        this.out(sb, "\t\t    sql.append(end-start);");
        this.out(sb, "\t\t" + table.getJavaNames() + " os=new " + table.getJavaNames() + "();");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\twhile(rs.next()){");
        this.out(sb, "\t\t\t\t" + table.getJavaName() + " o=this.mapRecord2Obj(rs);");
        this.out(sb, "\t\t\t\tos.add(o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn os;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc\ufffd\ufffd\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param values");
        this.out(sb, "\t* @return long");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic long getCountByWhereTemplate  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tlong count=0;");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        if (table.hasPK()) {
            String key = "";
            for (int i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
                Column col2 = table.getColumns().getAt(i3);
                if (!col2.isPK()) continue;
                key = col2.getName();
                break;
            }
            this.out(sb, "\t\tsql.append(\"count(" + key + ")\");");
        } else {
            this.out(sb, "\t\tsql.append(\"count(*)\");");
        }
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return 0;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count1=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count1;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tif(rs.next()){");
        this.out(sb, "\t\t\t\tcount=rs.getLong(1);;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffdWhere\ufffd\ufffd\ufffd\ufffd\u0123\ufffd\ufffd\ufffd\u046f\ufffd\ufffd\u00bc \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u07f2\ufffd\u046f\u0427\ufffd\ufffd");
        this.out(sb, "\t* <code>whereTemplate=\"where a=? or b=?\";</code>");
        this.out(sb, "\t* @param whereTemplate");
        this.out(sb, "\t* @param Result");
        this.out(sb, "\t* @throw SQLException");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic Result selectByWhereTemplate2  (String whereTemplate,Object...values) throws SQLException{");
        this.out(sb, "\t\tStringBuilder sql=new StringBuilder();");
        this.out(sb, "\t\tResult result=null;");
        this.out(sb, "\t\tsql.append(\"SELECT \");");
        this.out(sb, "\t\tsql.append(searchField());");
        this.out(sb, "\t\tsql.append(\" FROM `" + table.getName() + "` \");");
        this.out(sb, "\t\tsql.append(whereTemplate);");
        this.out(sb, "\t\tConnection con=this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif( con==null)return null;");
        this.out(sb, "\t\tPreparedStatement statement=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tString s=sql.toString();");
        this.out(sb, "\t\t\tstatement = con.prepareStatement(s);");
        this.out(sb, "\t\t\tint count=findCount(whereTemplate,'?');");
        this.out(sb, "\t\t\tfor(int i=0;i<count;i++){");
        this.out(sb, "\t\t\t\tObject o=values[i];");
        this.out(sb, "\t\t\t\tstatement.setObject(i+1, o);");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tResultSet rs=statement.executeQuery();");
        this.out(sb, "\t\t\tresult=ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif(statement!=null) statement.close();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tcatch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn result;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "}");
    }

    private void WriteViewObjs(View table, StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import java.util.Iterator;\r\n");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " * " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "public class " + table.getJavaNames() + " extends ArrayList<" + table.getJavaName() + ">{\r\n\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic " + table.getJavaNames() + "()");
        this.out(sb, "\t{");
        this.out(sb, "\t\tsuper();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tfor(int i=0;i<this.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.get(i).toString());");
        this.out(sb, "\t\t\tsb.append(\"\\r\\n\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffdJSON\ufffd\u0131\ufffd");
        this.out(sb, "\t * @return String");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tif(this.size()>0)");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\t\tsb.append(\"[\");");
        this.out(sb, "\t\tfor(int i=0;i<this.size();i++){");
        this.out(sb, "\t\t\tsb.append(this.get(i).toJSONString());");
        this.out(sb, "\t\t\tsb.append(\",\");");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\t\tsb.append(\"]\");");
        this.out(sb, "\t\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\telse");
        this.out(sb, "\t\t{");
        this.out(sb, "\t\t\treturn \"[]\";");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**                                               ");
        this.out(sb, "\t * \ufffd\ufffd\ufffdXML\ufffd\u06b5\ufffd\ufffd\u05b7\ufffd                              ");
        this.out(sb, "\t * @return                                        ");
        this.out(sb, "\t */                                               ");
        this.out(sb, "\tpublic String toXMLString(String tag,String tag1) ");
        this.out(sb, "\t{                                                 ");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();           ");
        this.out(sb, "\t\tif(tag==null || tag.equals(\"\"))                 ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"<" + table.getName() + "S \");                           ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\telse                                            ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"<\");                               ");
        this.out(sb, "\t\t\tsb.append(tag);                               ");
        this.out(sb, "\t\t\tsb.append(\" \");                               ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tsb.append(\"size=\\\"\");                           ");
        this.out(sb, "\t\tsb.append(this.size());                         ");
        this.out(sb, "\t\tsb.append(\"\\\" >\\r\\n\");                          ");
        this.out(sb, "\t\t                                                ");
        this.out(sb, "\t\tIterator<" + table.getJavaName() + "> it=this.iterator();          ");
        this.out(sb, "\t\twhile(it.hasNext())                             ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\t" + table.getJavaName() + " obj=it.next();                       ");
        this.out(sb, "\t\t\tsb.append(\"\\t\");                              ");
        this.out(sb, "\t\t\tsb.append(obj.toXMLString(tag1));             ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tif(tag==null || tag.equals(\"\"))                 ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"</" + table.getName() + "S>\");                          ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\telse                                            ");
        this.out(sb, "\t\t{                                               ");
        this.out(sb, "\t\t\tsb.append(\"</\");                              ");
        this.out(sb, "\t\t\tsb.append(tag);                               ");
        this.out(sb, "\t\t\tsb.append(\">\");                               ");
        this.out(sb, "\t\t}                                               ");
        this.out(sb, "\t\tsb.append(\"\\r\\n\");                           ");
        this.out(sb, "\t\treturn sb.toString();                           ");
        this.out(sb, "\t}                                                 ");
        this.out(sb, "}");
    }

    private void WriteViewBean(View table, StringBuilder sb, Configure conf) {
        Column col;
        int i;
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        String s = conf.getPackage();
        int index = s.lastIndexOf(".");
        s = s.substring(0, index) + ".json";
        this.out(sb, "import " + s + ".JSONHelper;");
        this.out(sb, "/**");
        this.out(sb, " * @author ZhangJianshe@gmail.com");
        this.out(sb, " *  " + table.getComment());
        this.out(sb, " */");
        this.out(sb, "/**\r\n");
        this.out(sb, " * \ufffd\u05b6\ufffd\ufffd\u0431\ufffd");
        this.out(sb, " * @author zjs");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, " * " + col.getName() + "   " + col.getComment() + " " + col.getJavaType());
        }
        this.out(sb, " */\r\n");
        this.out(sb, "public class " + table.getJavaName() + "{");
        this.out(sb, "\tprivate boolean[] m_changed;\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\uceaf\ufffd\ufffd");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic " + table.getJavaName() + "(){");
        this.out(sb, "\t\tm_changed = new boolean[" + table.getColumns().getCount() + "];");
        this.out(sb, "\t\tresetChanged(false);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \u022b\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param b");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void resetChanged(boolean b){");
        this.out(sb, "\t\tfor(int i=0;i<" + table.getColumns().getCount() + ";i++){");
        this.out(sb, "\t\t\tm_changed[i]=b;");
        this.out(sb, "\t\t}");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\ufffd\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @param b Boolean");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setChanged(int index,boolean b){");
        this.out(sb, "\t\tm_changed[index]=b;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\u05b6\ufffd\ufffd\u01f7\ud987\udef8\ufffd\u0139\ufffd");
        this.out(sb, "\t* @param index");
        this.out(sb, "\t* @return");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic boolean getChanged(int index){");
        this.out(sb, "\t\treturn m_changed[index];");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\u0221\ufffd\ufffd\u00bcROWID");
        this.out(sb, "\t* @return rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic String getROWID(){");
        this.out(sb, "\t   return this.ROWID;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t* \ufffd\ufffd\ufffd\u00fc\ufffd\u00bcROWID");
        this.out(sb, "\t* @param rowid");
        this.out(sb, "\t*/");
        this.out(sb, "\tpublic void setROWID(String rowid){");
        this.out(sb, "\t\tthis.ROWID=rowid;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tprivate String\tROWID;");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\tprivate " + col.getJavaType() + " " + col.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + col.getJavaType() + " get" + col.getName() + "(){");
            this.out(sb, "\t\treturn " + col.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + col.getName() + "  " + col.getComment());
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + col.getName() + "(" + col.getJavaType() + " " + col.getName() + "){");
            this.out(sb, "\t\tthis." + col.getName() + "=" + col.getName() + ";");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "\t\t}\r\n");
        }
        this.out(sb, "\tpublic String toString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"----\":this.get" + col.getName() + "().toString());");
            this.out(sb, "\t\tsb.append(\" | \");");
        }
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic void copyTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\t" + table.getJavaName().toLowerCase() + "." + col.getName() + " = this." + col.getName() + ";");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic void mergeTo(" + table.getJavaName() + " " + table.getJavaName().toLowerCase() + "){");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tif(this.getChanged(" + i + ")==true){" + table.getJavaName().toLowerCase() + "." + col.getName() + " = this." + col.getName() + ";}");
        }
        this.out(sb, "\t}");
        this.out(sb, "\tpublic String toJSONString(){");
        this.out(sb, "\t\tStringBuilder sb=new StringBuilder();");
        this.out(sb, "\t\tsb.append(\"{\");");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + ":\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(JSONHelper.escape(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
                this.out(sb, "\t\tsb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
                this.out(sb, "sb.append(\"\\\"\");");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "sb.append(\"\\\"\");");
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
                this.out(sb, "sb.append(\"\\\"\");");
            }
            this.out(sb, "\t\tsb.append(\",\");");
        }
        this.out(sb, "\t\tsb.deleteCharAt(sb.length()-1);");
        this.out(sb, "\t\tsb.append(\"}\");");
        this.out(sb, "\treturn sb.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t\t/**                                     ");
        this.out(sb, "\t\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u03aaXML\ufffd\ufffd\ufffd\ufffd                  ");
        this.out(sb, "\t\t * @return                              ");
        this.out(sb, "\t\t */                                     ");
        this.out(sb, "\t\tpublic String toXMLProperty()   ");
        this.out(sb, "\t\t{                                       ");
        this.out(sb, "\t\t\tStringBuilder sb=new StringBuilder(); ");
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            col = table.getColumns().getAt(i);
            this.out(sb, "\t\tsb.append(\"" + col.getName() + "=\\\"\");");
            if (col.getJavaType().equals("String")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXML(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.math.BigDecimal")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Boolean")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Byte")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Short")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Integer")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Float")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Double")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("byte[]")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXMLthis.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.sql.Date")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("java.sql.Time")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString());");
            } else if (col.getJavaType().equals("Long")) {
                this.out(sb, "\t\tsb.append(JSONHelper.escapeForXML(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString()));");
            } else if (col.getJavaType().equals("java.sql.Timestamp")) {
                this.out(sb, "\t\tsb.append(this.get" + col.getName() + "()==null?\"null\":this.get" + col.getName() + "().toString().substring(0,19));");
            }
            this.out(sb, "\t\tsb.append(\"\\\" \");");
        }
        this.out(sb, "\t\treturn sb.toString();                   ");
        this.out(sb, "\t\t}                                       ");
        this.out(sb, "\t\t/**                                     ");
        this.out(sb, "\t\t * \ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\u03aaXML\ufffd\ufffd\ufffd\ufffd                    ");
        this.out(sb, "\t\t * @param tag                           ");
        this.out(sb, "\t\t * @return                              ");
        this.out(sb, "\t\t */                                     ");
        this.out(sb, "\t\tpublic String toXMLString(String tag)   ");
        this.out(sb, "\t\t{                                       ");
        this.out(sb, "\t\t\tStringBuilder sb=new StringBuilder(); ");
        this.out(sb, "\t\t\tif(tag==null || tag.equals(\"\"))       ");
        this.out(sb, "\t\t\t{                                     ");
        this.out(sb, "\t\t\t\tsb.append(\"<" + table.getName().toUpperCase() + " \");         ");
        this.out(sb, "\t\t\t}                                     ");
        this.out(sb, "\t\t\telse                                  ");
        this.out(sb, "\t\t\t{                                     ");
        this.out(sb, "\t\t\t\tsb.append(\"<\");                     ");
        this.out(sb, "\t\t\t\tsb.append(tag);                     ");
        this.out(sb, "\t\t\t\tsb.append(\" \");                     ");
        this.out(sb, "\t\t\t}                                     ");
        this.out(sb, "\t\t\tsb.append(toXMLProperty());                                      ");
        this.out(sb, "\t\t\tsb.append(\"/>\\r\\n\");                     ");
        this.out(sb, "\t\t\treturn sb.toString();                 ");
        this.out(sb, "\t\t}  ");
        this.out(sb, "}");
    }

    @Override
    public void exportProcedures(Configure confProcedure) {
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        this.out(sb, "package " + confProcedure.getPackage() + ".dao." + confProcedure.getDatabase() + ".impl;\r\n");
        this.out(sb, "import java.sql.CallableStatement;");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;\r\n");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        this.out(sb, "import " + confProcedure.getPackage() + ".dao.IProcedures;\r\n");
        this.out(sb, "import " + confProcedure.getPackage() + ".base.AccessBase;");
        this.out(sb, "import " + confProcedure.getPackage() + ".base.ExecuteResult;");
        this.out(sb, "import " + confProcedure.getPackage() + ".base.IConnectionPool;\r\n");
        StringBuilder imports = new StringBuilder();
        StringBuilder t1 = new StringBuilder();
        StringBuilder t2 = new StringBuilder();
        for (int i = 0; i < this.getPackages().getCount(); ++i) {
            Pack pack = this.getPackages().getAt(i);
            Procedures procs = pack.getProcedures();
            for (int j = 0; j < procs.getCount(); ++j) {
                Procedure proc = procs.getAt(j);
                imports.append("\r\nimport " + confProcedure.getPackage() + ".modle.Arg_" + proc.getName() + ";");
                this.exportProcedureArgument(proc, confProcedure);
                this.exportProcedure(proc, confProcedure, t1);
                this.exportProcedureInterface(proc, confProcedure, t2);
                System.out.println("Export Database PL/SQL Package -Procedure " + proc.getName());
            }
        }
        this.out(sb, imports.toString());
        this.out(sb, "public class  ProceduresImpl extends AccessBase implements IProcedures{\r\n");
        this.out(sb, "\tpublic ProceduresImpl(IConnectionPool pool){");
        this.out(sb, "\t\tsuper(pool);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tString errMessage=\"\";");
        this.out(sb, "\tpublic String getErrMessage() {");
        this.out(sb, "\t\treturn errMessage;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic void setErrMessage(String errMessage) {");
        this.out(sb, "\t\tthis.errMessage = errMessage;");
        this.out(sb, "\t}\r\n");
        this.out(sb, t1.toString());
        this.out(sb, "}");
        this.out(sb1, "package " + confProcedure.getPackage() + ".dao;\r\n");
        this.out(sb1, imports.toString());
        this.out(sb1, "public interface  IProcedures{\r\n");
        this.out(sb1, t2.toString());
        this.out(sb1, "}");
        this.writeToFile(confProcedure.getFilePath() + "/dao/" + confProcedure.getDatabase() + "/impl", "ProceduresImpl.java", sb.toString());
        this.writeToFile(confProcedure.getFilePath() + "/dao", "IProcedures.java", sb1.toString());
    }

    private void exportProcedureArgument(Procedure func, Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, "package " + conf.getPackage() + ".modle;");
        this.out(sb, "\r\n");
        this.out(sb, this.findImport(func.getArguments()));
        this.out(sb, "public class Arg_" + func.getName() + "{");
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            this.out(sb, "\tprivate " + arg.getJavaType() + " " + arg.getName() + ";\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @return " + arg.getName() + " " + arg.getJavaType());
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else if (arg.getProperty().equals("OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u05b5");
            } else if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd");
            }
            this.out(sb, "\t */");
            this.out(sb, "\tpublic " + arg.getJavaType() + " get" + arg.getName() + "(){");
            this.out(sb, "\t\treturn " + arg.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            this.out(sb, "\t/**");
            this.out(sb, "\t * @param " + arg.getName() + " " + arg.getJavaType());
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd");
            } else if (arg.getProperty().equals("OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd\u04aa\ufffd\ufffd\u05b5");
            } else if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t * \ufffd\u02f2\ufffd\ufffd\ufffd\ufffd\u01f4\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd");
            }
            this.out(sb, "\t */");
            this.out(sb, "\tpublic void set" + arg.getName() + "(" + arg.getJavaType() + " " + arg.getName() + "){");
            this.out(sb, "\t\tthis." + arg.getName() + "=" + arg.getName() + ";");
            this.out(sb, "\t\t}\r\n");
            if (!arg.getJavaType().equals("MDSYS.SDO_GEOMETRY") && !arg.getJavaType().equals("SDO_GEOMETRY")) continue;
            this.out(sb, "\tpublic String get" + arg.getName() + "AsWKT(){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\treturn String(wkt.fromJGeometry(g));");
            this.out(sb, "}");
            this.out(sb, "\tpublic void set" + arg.getName() + "AsWKT(String wktString){");
            this.out(sb, "\tWKT wkt=new WKT();");
            this.out(sb, "\tthis." + arg.getName() + "= wkt.toJGeometry(wktString.getBytes()));");
            this.out(sb, "\t\tsetChanged( " + i + " ,true);");
            this.out(sb, "}");
        }
        this.out(sb, "}");
        this.writeToFile(conf.getFilePath() + "/modle", "Arg_" + func.getName() + ".java", sb.toString());
    }

    private void exportProcedureInterface(Procedure func, Configure conf, StringBuilder body) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic   boolean " + func.getName() + "(Arg_" + func.getName() + " arg);");
        body.append(sb.toString());
    }

    private void exportProcedure(Procedure func, Configure conf, StringBuilder body) {
        StringBuilder sb = new StringBuilder();
        sb.append("\tpublic final  boolean " + func.getName() + "(Arg_" + func.getName() + " arg)");
        this.out(sb, "\t{");
        this.out(sb, "\t\tboolean b=false;");
        String head = "";
        String que = "";
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getPosition() == 0) {
                head = " ?:= ";
                continue;
            }
            que = que + "?,";
        }
        if (que.length() > 1) {
            que = que.substring(0, que.length() - 1);
        }
        String sche = "";
        sche = func.getPackageName().equals("") ? "" : func.getPackageName() + ".";
        String sql = "{call " + head + " " + sche + func.getName() + "(" + que + ")}";
        this.out(sb, "\t\tString sql=\"" + sql + "\";");
        this.out(sb, "\t\tConnection con= this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tCallableStatement cstm=null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tcstm= con.prepareCall(sql);");
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getProperty().equals("IN")) {
                this.out(sb, "\t\t\tcstm.set" + arg.getJavaType2() + "(" + (i + 1) + ",arg.get" + arg.getName() + "());");
                continue;
            }
            if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t\t\tcstm.set" + arg.getJavaType2() + "(" + (i + 1) + ",arg.get" + arg.getName() + "());");
                this.out(sb, "\t\t\tcstm.registerOutParameter(" + (i + 1) + ", " + arg.getJavaType3() + ");");
                continue;
            }
            if (!arg.getProperty().equals("OUT")) continue;
            this.out(sb, "\t\t\tcstm.registerOutParameter(" + (i + 1) + ", " + arg.getJavaType3() + ");");
        }
        this.out(sb, "\t\t\tb=cstm.execute();");
        boolean hasREF = false;
        for (int i = 0; i < func.getArguments().getCount(); ++i) {
            Argument arg = func.getArguments().getAt(i);
            if (arg.getProperty().equals("IN/OUT")) {
                this.out(sb, "\t\t\targ.set" + arg.getName() + "(cstm.get" + arg.getJavaType4() + "(" + (i + 1) + "));");
                continue;
            }
            if (!arg.getProperty().equals("OUT")) continue;
            System.out.println("argument  " + arg.getName() + " " + arg.getType());
            if (arg.getType().equals("REF CURSOR")) {
                if (!hasREF) {
                    this.out(sb, "\t\t\tResultSet rs=null;");
                    this.out(sb, "\t\t\tResult r=null;");
                    hasREF = true;
                }
                this.out(sb, "\t\t\trs=(ResultSet)cstm.getObject(" + (i + 1) + ");");
                this.out(sb, "\t\t\tr=ResultSupport.toResult(rs);");
                this.out(sb, "\t\t\trs.close();");
                this.out(sb, "\t\t\targ.set" + arg.getName() + "(r);");
                continue;
            }
            this.out(sb, "\t\t\targ.set" + arg.getName() + "(cstm.get" + arg.getJavaType4() + "(" + (i + 1) + "));");
        }
        this.out(sb, "\t\t\tcstm.close();");
        this.out(sb, "\t\t\tb=true;");
        this.out(sb, "\t\t} catch (SQLException e) {");
        this.out(sb, "\t\t\tsetErrMessage(e.getMessage());");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\tfinally{");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\t}\r\n");
        body.append(sb.toString());
    }

    private String findImport(Arguments arguments) {
        StringBuilder imports = new StringBuilder();
        for (int i = 0; i < arguments.getCount(); ++i) {
            Argument arg = arguments.getAt(i);
            if (arg.getJavaType().equals("Result")) {
                imports.append("import javax.servlet.jsp.jstl.sql.Result;\r\nimport javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
                continue;
            }
            if (!arg.getJavaType().equals("JGeometry")) continue;
            imports.append("import oracle.spatial.geometry.JGeometry;\r\n");
            imports.append("import oracle.spatial.util.GeometryExceptionWithContext;\r\n");
            imports.append("import oracle.spatial.util.WKT;\r\n");
            imports.append("import oracle.sql.STRUCT;\r\n");
        }
        return imports.toString();
    }

    @Override
    public void exportSpringConfigure(Configure conf) {
        StringBuilder sb = new StringBuilder();
        String header = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\r\n<beans xmlns=\"http://www.springframework.org/schema/beans\"\r\n\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\r\n\txsi:schemaLocation=\"http://www.springframework.org/schema/beans http://www.springframework.org/schema/beans/spring-beans-2.0.xsd\">\r\n\t<bean id=\"MyPool\" class=\"com.mapway.youeryuan.database.base.MyPool\"\r\n\tfactory-method=\"getInstance\">\r\n\t<constructor-arg>\r\n\t\t<value>MySQL</value>\r\n\t</constructor-arg>\r\n\t</bean>\r\n";
        sb.append(header);
        Tables ts = this.getTables();
        for (int i = 0; i < ts.getCount(); ++i) {
            ITable t = ts.getAt(i);
            sb.append("\t<bean id=\"" + t.getName() + "DAO\" scope=\"prototype\"\tclass=\"" + conf.getPackage() + ".dao.mysql.impl." + t.getJavaAccessName() + "\">\r\n\t\t<constructor-arg ref=\"MyPool\"></constructor-arg>\r\n\t</bean>\r\n");
        }
        sb.append("</beans>");
        this.writeToFile(conf.getFilePath(), "bean_dao_mysql.xml", sb.toString());
    }

    @Override
    public void exportDwrConfigure(Configure conf) {
        StringBuilder sb = new StringBuilder();
        String header = "<!DOCTYPE dwr PUBLIC \"-//GetAhead Limited//DTD Direct Web Remoting 3.0//EN\" \"http://directwebremoting.org/schema/dwr30.dtd\"><dwr >\t<allow>";
        sb.append(header);
        Tables ts = this.getTables();
        for (int i = 0; i < ts.getCount(); ++i) {
            ITable t = ts.getAt(i);
            sb.append("\t\t<convert converter=\"bean\" match=\"" + conf.getPackage() + ".modle." + t.getJavaName() + "\"/>\r\n");
        }
        sb.append("\t</allow>\r\n</dwr>");
        this.writeToFile(conf.getFilePath(), "dwr_objs.xml", sb.toString());
    }
}

