/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.schema;

import com.mapway.database2java.model.base.naming.CamelConvert;
import com.mapway.database2java.model.base.naming.INameConvertor;
import com.mapway.database2java.model.schema.TypeMapper;

public class Column {
    String DatabaseType;
    String JavaType;
    String Name;
    String comment;
    boolean isPK;
    boolean isAuto = false;
    int length;
    INameConvertor convertor;
    String m_seq;

    public Column(INameConvertor convertor) {
        if (convertor == null) {
            convertor = new CamelConvert();
        }
        this.convertor = convertor;
    }

    public Column() {
        this(null);
    }

    public String getJavaName() {
        return this.convertor.convert(this.getName());
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        int end;
        int index;
        this.comment = comment;
        if (this.comment != null && !this.comment.equals("") && (index = this.comment.indexOf("@Seq(")) >= 0 && (end = this.comment.indexOf(")", index)) > 0) {
            String str = this.comment.substring(index + 5, end);
            this.m_seq = str.trim().toUpperCase();
            this.isAuto = true;
        }
    }

    public String getDatabaseType() {
        return this.DatabaseType;
    }

    public String getSequence() {
        return this.m_seq;
    }

    public void setDatabaseType(String databaseType) {
        this.DatabaseType = databaseType;
    }

    public String getJavaType() {
        TypeMapper tm = TypeMapper.getInstance();
        return tm.getOracle2JDBC().likeValue(this.DatabaseType);
    }

    public String getNetType() {
        TypeMapper tm = TypeMapper.getInstance();
        return tm.getOracle2Net().likeValue(this.DatabaseType);
    }

    public String getName() {
        return this.Name;
    }

    public void setName(String name) {
        this.Name = name;
    }

    public boolean isPK() {
        return this.isPK;
    }

    public void setPK(boolean isPK) {
        this.isPK = isPK;
    }

    public String getJavaType2() {
        TypeMapper tm = TypeMapper.getInstance();
        return tm.getOracle2JDBC2().likeValue(this.DatabaseType);
    }

    public boolean isAuto() {
        return this.isAuto;
    }

    public void setAuto(boolean isAuto) {
        this.isAuto = isAuto;
    }

    public String getJavaType4() {
        TypeMapper tm = TypeMapper.getInstance();
        return tm.getOracle2JDBC4().likeValue(this.DatabaseType);
    }
}

