/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.base;

import com.mapway.database2java.database.AccessBase;
import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.itf.ISQLClause;
import com.mapway.database2java.model.itf.ISchema;
import com.mapway.database2java.model.schema.ITable;
import com.mapway.database2java.model.schema.Packages;
import com.mapway.database2java.model.schema.Sequences;
import com.mapway.database2java.model.schema.Tables;
import com.mapway.database2java.model.schema.View;
import com.mapway.database2java.model.schema.Views;
import com.squareup.javawriter.JavaWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.servlet.jsp.jstl.sql.Result;
import org.nutz.dao.entity.annotation.Column;
import org.nutz.dao.entity.annotation.Id;
import org.nutz.dao.entity.annotation.Name;
import org.nutz.dao.entity.annotation.PK;
import org.nutz.dao.entity.annotation.Table;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.stream.StringOutputStream;

public class SchemaBase
implements ISchema {
    public static final String FIELD_STYLE_CAMEL = "CAMEL";
    public static final String FIELD_STYLE_LOWER_CASE = "LOWER_CASE";
    public static final String FIELD_STYLE_UPPER_CASE = "UPPER_CASE";
    public AccessBase a = null;
    Tables tables = null;
    Sequences sequences = null;
    Packages packages = null;
    Views views = null;
    ISQLClause sqlClause = null;
    Configure m_configure = null;
    Object[][] pks = null;
    String copyright = "\r\n<pre>\r\n\r\n           =============================================================\r\n           -   ____ _  _ ____ _  _ ____  _ _ ____ _  _ ____ _  _ ____  -\r\n           -    __] |__| |__| |\\ | | __  | | |__| |\\ | [__  |__| |___  -\r\n           -   [___ |  | |  | | \\| |__| _| | |  | | \\| ___] |  | |___  -\r\n           -           http://hi.baidu.com/zhangjianshe                -\r\n           =============================================================\r\n\r\n</pre>\r\n";

    public SchemaBase(IConnectionPool pool, Configure configure) {
        this.a = new AccessBase(pool);
        this.tables = new Tables();
        this.sequences = new Sequences();
        this.packages = new Packages();
        this.views = new Views();
        this.m_configure = configure;
        this.pks = new Object[0][0];
    }

    @Override
    public boolean fetchSchema() {
        try {
            Result r = this.a.execute(this.getSQLClause().getPKSQL());
            this.pks = r.getRowsByIndex();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
    }

    public String getHeader() {
        return "";
    }

    public void setSQLClause(ISQLClause c) {
        this.sqlClause = c;
    }

    public Configure getConfigure() {
        return this.m_configure;
    }

    public boolean isPK(String tn, String cn) {
        boolean b = false;
        for (int i = 0; i < this.pks.length; ++i) {
            String tna = (String)this.pks[i][0];
            String cna = (String)this.pks[i][1];
            String pktype = (String)this.pks[i][2];
            if (!tna.equals(tn) || !cna.equals(cn) || pktype.compareToIgnoreCase("PRIMARY") != 0) continue;
            b = true;
            break;
        }
        return b;
    }

    public ISQLClause getSQLClause() {
        return this.sqlClause;
    }

    @Override
    public Tables getTables() {
        return this.tables;
    }

    public Sequences getSequences() {
        return this.sequences;
    }

    public Packages getPackages() {
        return this.packages;
    }

    @Override
    public Views getViews() {
        return this.views;
    }

    public Object[][] getPKS() {
        return this.pks;
    }

    public void writeToFile(String path, String fn, String s) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path + File.separator + fn), "UTF-8");
            out.write(s);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String exportJSONTools(Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJSONTools(sb, conf);
        this.writeToFile(conf.getFilePath(), "JSONHelper.java", sb.toString());
        return "";
    }

    private void writeJSONTools(StringBuilder sb, Configure conf) {
        this.out(sb, "package " + conf.getPackage() + ";");
        this.out(sb, "public class JSONHelper");
        this.out(sb, "{");
        this.out(sb, "private static final char[] QUOTE_ENCODE = \"&quot;\".toCharArray();");
        this.out(sb, "                                                                  ");
        this.out(sb, "\tprivate static final char[] AMP_ENCODE = \"&amp;\".toCharArray(); ");
        this.out(sb, "                                                                  ");
        this.out(sb, "\tprivate static final char[] LT_ENCODE = \"&lt;\".toCharArray();   ");
        this.out(sb, "                                                                  ");
        this.out(sb, "\tprivate static final char[] GT_ENCODE = \"&gt;\".toCharArray();   ");
        this.out(sb, "                                                                  ");
        this.out(sb, "\tpublic static final String escapeForXML(String string) {        ");
        this.out(sb, "\t\tif (string == null) {                                         ");
        this.out(sb, "\t\t\treturn null;                                                ");
        this.out(sb, "\t\t}                                                             ");
        this.out(sb, "\t\tchar ch;                                                      ");
        this.out(sb, "\t\tint i = 0;                                                    ");
        this.out(sb, "\t\tint last = 0;                                                 ");
        this.out(sb, "\t\tchar[] input = string.toCharArray();                          ");
        this.out(sb, "\t\tint len = input.length;                                       ");
        this.out(sb, "\t\tStringBuffer out = new StringBuffer((int) (len * 1.3));       ");
        this.out(sb, "\t\tfor (; i < len; i++) {                                        ");
        this.out(sb, "\t\t\tch = input[i];                                              ");
        this.out(sb, "\t\t\tif (ch > '>') {                                             ");
        this.out(sb, "\t\t\t\tcontinue;                                                 ");
        this.out(sb, "\t\t\t} else if (ch == '<') {                                     ");
        this.out(sb, "\t\t\t\tif (i > last) {                                           ");
        this.out(sb, "\t\t\t\t\tout.append(input, last, i - last);                      ");
        this.out(sb, "\t\t\t\t}                                                         ");
        this.out(sb, "\t\t\t\tlast = i + 1;                                             ");
        this.out(sb, "\t\t\t\tout.append(LT_ENCODE);                                    ");
        this.out(sb, "\t\t\t} else if (ch == '&') {                                     ");
        this.out(sb, "\t\t\t\tif (i > last) {                                           ");
        this.out(sb, "\t\t\t\t\tout.append(input, last, i - last);                      ");
        this.out(sb, "\t\t\t\t}                                                         ");
        this.out(sb, "\t\t\t\tlast = i + 1;                                             ");
        this.out(sb, "\t\t\t\tout.append(AMP_ENCODE);                                   ");
        this.out(sb, "\t\t\t} else if (ch == '\"') {                                     ");
        this.out(sb, "\t\t\t\tif (i > last) {                                           ");
        this.out(sb, "\t\t\t\t\tout.append(input, last, i - last);                      ");
        this.out(sb, "\t\t\t\t}                                                         ");
        this.out(sb, "\t\t\t\tlast = i + 1;                                             ");
        this.out(sb, "\t\t\t\tout.append(QUOTE_ENCODE);                                 ");
        this.out(sb, "\t\t\t}                                                           ");
        this.out(sb, "\t\t}                                                             ");
        this.out(sb, "\t\tif (last == 0) {                                              ");
        this.out(sb, "\t\t\treturn string;                                              ");
        this.out(sb, "\t\t}                                                             ");
        this.out(sb, "\t\tif (i > last) {                                               ");
        this.out(sb, "\t\t\tout.append(input, last, i - last);                          ");
        this.out(sb, "\t\t}                                                             ");
        this.out(sb, "\t\treturn out.toString();                                        ");
        this.out(sb, "\t}                                                               ");
        this.out(sb, "/**                                         ");
        this.out(sb, "\t * @param s                               ");
        this.out(sb, "\t * @return                                ");
        this.out(sb, "\t */                                       ");
        this.out(sb, "\tpublic static String escape(String s){    ");
        this.out(sb, "\t\tif(s==null)                             ");
        this.out(sb, "\t\t\treturn null;                          ");
        this.out(sb, "\t\tStringBuffer sb=new StringBuffer();     ");
        this.out(sb, "\t\tfor(int i=0;i<s.length();i++){          ");
        this.out(sb, "\t\t\tchar ch=s.charAt(i);                  ");
        this.out(sb, "\t\t\tswitch(ch){                           ");
        this.out(sb, "\t\t\tcase '\"':                             ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\\\\"\");                  ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\\\':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\\\\\\");                  ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\b':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\b\");                   ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\f':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\f\");                   ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\n':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\n\");                   ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\r':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\r\");                   ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '\\t':                            ");
        this.out(sb, "\t\t\t\tsb.append(\"\\\\t\");                   ");
        this.out(sb, "\t\t\t\tbreak;                              ");
        this.out(sb, "\t\t\tcase '/':                             ");
        this.out(sb, "        \t\t\t\tsb.append(\"\\\\/\");                    ");
        this.out(sb, "        \t\t\t\tbreak;                               ");
        this.out(sb, "        \t\t\tdefault:                               ");
        this.out(sb, "        \t\t\t\tif(ch>='\\u0000' && ch<='\\u001F'){      ");
        this.out(sb, "        \t\t\t\t\tString ss=Integer.toHexString(ch); ");
        this.out(sb, "        \t\t\t\t\tsb.append(\"\\\\u\");                ");
        this.out(sb, "        \t\t\t\t\tfor(int k=0;k<4-ss.length();k++){    ");
        this.out(sb, "        \t\t\t\t\t\tsb.append('0');                  ");
        this.out(sb, "        \t\t\t\t\t}                                  ");
        this.out(sb, "        \t\t\t\t\tsb.append(ss.toUpperCase());         ");
        this.out(sb, "        \t\t\t\t}                                    ");
        this.out(sb, "        \t\t\t\telse{                                ");
        this.out(sb, "        \t\t\t\t\tsb.append(ch);                       ");
        this.out(sb, "        \t\t\t\t}                                    ");
        this.out(sb, "        \t\t\t}                                      ");
        this.out(sb, "        \t\t}//for                                   ");
        this.out(sb, "        \t\treturn sb.toString();                    ");
        this.out(sb, "        \t}                                         ");
        this.out(sb, "}");
    }

    public void out(StringBuilder sb, String s) {
        sb.append(s + "\r\n");
    }

    @Override
    public String exportTable(ITable table, Configure conf) {
        return null;
    }

    @Override
    public void exportPoolInterface(Configure conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.sql.Connection;\r\n");
        this.out(sb, "public interface IConnectionPool {");
        this.out(sb, "\tpublic Connection getConnection();");
        this.out(sb, "\tpublic void releaseConnection(Connection con);");
        this.out(sb, "}");
        this.writeToFile(conf.getFilePath(), "IConnectionPool.java", sb.toString());
        InputStream ins = this.getClass().getResourceAsStream("/template/MyPool.txt");
        String txt = SchemaBase.readUTF8TextFile(ins);
        txt = txt.replace("${package}", conf.getPackage());
        this.writeToFile(conf.getFilePath(), "MyPool.java", txt);
        try {
            ins.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readUTF8TextFile(InputStream ins) {
        String txt = "";
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            int len = ins.read(bytes);
            while (len > 0) {
                out.write(bytes, 0, len);
                len = ins.read(bytes);
            }
            ins.close();
            txt = out.toString("UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return txt;
    }

    public static String readUTF8TextFile(String fileName) {
        byte[] bytes = SchemaBase.ReadFromFile(fileName);
        String str = "";
        try {
            str = new String(bytes, "UTF-8");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String readTextFile(String fileName, String encoding) {
        byte[] bytes = SchemaBase.ReadFromFile(fileName);
        String str = "";
        try {
            str = new String(bytes, encoding);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static byte[] ReadFromFile(String fileName) {
        File ff = new File(fileName);
        long filelength = ff.length();
        byte[] code = new byte[(int)filelength];
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            ((InputStream)inStream).read(code);
            ((InputStream)inStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return code;
    }

    @Override
    public void exportExecuteResult(Configure conf) {
        System.out.println("Export ExecuteResult.....");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.Statement;");
        this.out(sb, "public class ExecuteResult {");
        this.out(sb, "public ResultSet result;");
        this.out(sb, "public Statement statement;");
        this.out(sb, "Connection       con;");
        this.out(sb, "IConnectionPool  pool;");
        this.out(sb, "/**");
        this.out(sb, "* \u8bb0\u5f97\u7528\u5b8c\u540e \u8c03\u7528 dispose \u91ca\u653e\u8d44\u6e90");
        this.out(sb, "* ");
        this.out(sb, "* @param rs");
        this.out(sb, "* @param stm");
        this.out(sb, "*/");
        this.out(sb, "public ExecuteResult(IConnectionPool pool, Connection con, ResultSet rs,");
        this.out(sb, "Statement stm) {");
        this.out(sb, "this.con = con;");
        this.out(sb, "this.pool = pool;");
        this.out(sb, "result = rs;");
        this.out(sb, "statement = stm;");
        this.out(sb, "}");
        this.out(sb, "public void dispose()");
        this.out(sb, "{");
        this.out(sb, "try");
        this.out(sb, "{");
        this.out(sb, "if (result != null )");
        this.out(sb, "{");
        this.out(sb, "result.close();");
        this.out(sb, "result = null;");
        this.out(sb, "}");
        this.out(sb, "if (statement != null )");
        this.out(sb, "{");
        this.out(sb, "statement.close();");
        this.out(sb, "statement = null;");
        this.out(sb, "}");
        this.out(sb, "} catch (SQLException e)");
        this.out(sb, "{");
        this.out(sb, "e.printStackTrace();");
        this.out(sb, "} finally");
        this.out(sb, "{");
        this.out(sb, "if (this.pool != null)");
        this.out(sb, "{");
        this.out(sb, "this.pool.releaseConnection(con);");
        this.out(sb, "}");
        this.out(sb, "}");
        this.out(sb, "}");
        this.out(sb, "/**");
        this.out(sb, "* \u83b7\u53d6\u6267\u884c\u7684\u7ed3\u679c");
        this.out(sb, "* ");
        this.out(sb, "* @return");
        this.out(sb, "*/");
        this.out(sb, "public ResultSet getResultSet()");
        this.out(sb, "{");
        this.out(sb, "return this.result;");
        this.out(sb, "}");
        this.out(sb, "}");
        this.writeToFile(conf.getFilePath(), "ExecuteResult.java", sb.toString());
    }

    @Override
    public void exportAccessBase(Configure conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.io.IOException;");
        this.out(sb, "import java.io.Reader;");
        this.out(sb, "import java.io.InputStream;");
        this.out(sb, "import java.sql.Clob;");
        this.out(sb, "import java.sql.Blob;");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.PreparedStatement;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.Statement;");
        this.out(sb, "import java.util.ArrayList;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.Result;");
        this.out(sb, "import javax.servlet.jsp.jstl.sql.ResultSupport;\r\n");
        this.out(sb, "public class AccessBase {\r\n");
        this.out(sb, "\tprotected IConnectionPool ConnectionPool;\r\n");
        this.out(sb, "\tpublic final static String ERROR_DATABASE = \"Database Access Error\";");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u6c60");
        this.out(sb, "\t * @return IConnectionPool");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic IConnectionPool getConnectionPool() {");
        this.out(sb, "\t\treturn this.ConnectionPool;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/**");
        this.out(sb, "\t * \u8bbe\u7f6e\u6570\u636e\u5e93\u8fde\u63a5\u6c60");
        this.out(sb, "\t * @param IConnectionPool");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void setConnectionPool(IConnectionPool pool) {");
        this.out(sb, "\t\tthis.ConnectionPool = pool;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic AccessBase(IConnectionPool pool) {");
        this.out(sb, "\t\tthis.ConnectionPool = pool;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic Result execute(String sql) throws SQLException {");
        this.out(sb, "\t\tResult r = null;");
        this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif (con == null)");
        this.out(sb, "\t\t\treturn null;");
        this.out(sb, "\t\tStatement statement = null;");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tstatement = con.createStatement();");
        this.out(sb, "\t\t\tResultSet rs = statement.executeQuery(sql);");
        this.out(sb, "\t\t\tr = ResultSupport.toResult(rs);");
        this.out(sb, "\t\t\trs.close();");
        this.out(sb, "\t\t\tif (statement != null)");
        this.out(sb, "\t\t\t\tstatement.close();");
        this.out(sb, "\t\t} catch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t} finally {");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn r;");
        this.out(sb, "\t}");
        this.out(sb, "\tpublic ExecuteResult execute2Result(String sql) throws SQLException {");
        this.out(sb, "\t\tConnection con = this.ConnectionPool.getConnection();");
        this.out(sb, "if (con == null)");
        this.out(sb, "return null;");
        this.out(sb, "\tPreparedStatement statement = null;");
        this.out(sb, "\ttry {");
        this.out(sb, "\t\tstatement = con.prepareStatement(sql);");
        this.out(sb, "\t\tResultSet rs = statement.executeQuery();");
        this.out(sb, "\t\t\t\treturn new ExecuteResult(this.ConnectionPool, con, rs, statement);");
        this.out(sb, "\t} catch (SQLException e) {");
        this.out(sb, "\t\te.printStackTrace();");
        this.out(sb, "\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t\treturn null;");
        this.out(sb, "\t}");
        this.out(sb, "}");
        this.out(sb, "\tpublic int findCount(String src, char match) {");
        this.out(sb, "\t\tint count = 0;");
        this.out(sb, "\t\tfor (int index = 0; index < src.length(); index++) {");
        this.out(sb, "\t\t\tchar c = src.charAt(index);");
        this.out(sb, "\t\t\tif (c == match) {");
        this.out(sb, "\t\t\t\tcount++;");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn count;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic void Log(String info) {");
        this.out(sb, "\t\tSystem.out.println(info);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic static byte[] bytesFromBlob(Blob blob)throws SQLException\t{");
        this.out(sb, "\t\tif(blob==null)return new byte[0];");
        this.out(sb, "\t      byte[] r = new byte[(int) blob.length()];");
        this.out(sb, "\t      InputStream in=blob.getBinaryStream();");
        this.out(sb, "\t          for (int i=0 ; i < blob.length() ; i++) {");
        this.out(sb, "\t              try {");
        this.out(sb, "\t\t\t\t\tr[i]=(byte)in.read();");
        this.out(sb, "\t\t\t\t} catch (IOException e) {");
        this.out(sb, "\t\t\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\t\t}");
        this.out(sb, "\t\t          }");
        this.out(sb, "\t\treturn r;");
        this.out(sb, "\t}\t\n");
        this.out(sb, "public boolean executeDDL(String ddl) throws SQLException {");
        this.out(sb, "\tboolean b = false;");
        this.out(sb, "\tConnection con = this.ConnectionPool.getConnection();");
        this.out(sb, " if (con == null)");
        this.out(sb, "\t\treturn b;");
        this.out(sb, "\tStatement statement = null;");
        this.out(sb, "\ttry {");
        this.out(sb, "\t\tstatement = con.createStatement();");
        this.out(sb, "\t\tb = statement.execute(ddl);");
        this.out(sb, "\t\tif (statement != null)");
        this.out(sb, "\t\t\tstatement.close();");
        this.out(sb, "\t} catch (SQLException e) {");
        this.out(sb, "\t\t\tb = false;");
        this.out(sb, "\t\te.printStackTrace();");
        this.out(sb, "\t    throw e;");
        this.out(sb, "\t} finally {");
        this.out(sb, "\t\tthis.ConnectionPool.releaseConnection(con);");
        this.out(sb, "\t}");
        this.out(sb, "\treturn b;");
        this.out(sb, "}");
        this.out(sb, "\tpublic static String StringFromClob(Clob clob) throws SQLException {");
        this.out(sb, "\t\tif (clob == null)");
        this.out(sb, "\t\t\treturn \"\";");
        this.out(sb, "\t\tReader clobStream = null; ");
        this.out(sb, "\t\ttry { ");
        this.out(sb, "\t\t\tclobStream = clob.getCharacterStream();");
        this.out(sb, "\t\t} catch (SQLException e) {");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow e;");
        this.out(sb, "\t\t}\r\n");
        this.out(sb, "\t\tStringBuilder suggestions = new StringBuilder();");
        this.out(sb, "\t\tint nchars = 0; // Number of characters read  ");
        this.out(sb, "\t\tchar[] buffer = new char[10];                 ");
        this.out(sb, "\t\ttry { ");
        this.out(sb, "\t\t\twhile ((nchars = clobStream.read(buffer)) != -1)");
        this.out(sb, "\t\t\t\tsuggestions.append(buffer, 0, nchars);");
        this.out(sb, "\t\t} catch (IOException e) { ");
        this.out(sb, "\t\t\te.printStackTrace();    ");
        this.out(sb, "\t\t\tthrow new SQLException();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\ttry { ");
        this.out(sb, "\t\t\tclobStream.close();");
        this.out(sb, "\t\t} catch (IOException e){ ");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "\t\t\tthrow new SQLException();");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn suggestions.toString();");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\tpublic ArrayList<String> m_SQLs;\r\n");
        this.out(sb, "\t/* ");
        this.out(sb, "\t * @param sql");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void AddSQL(String sql) {");
        this.out(sb, "\t\tif (sql.equals(\"\"))");
        this.out(sb, "\t\t\treturn;");
        this.out(sb, "\t\tif (m_SQLs == null)");
        this.out(sb, "\t\t\tm_SQLs = new ArrayList<String>();");
        this.out(sb, "\t\tm_SQLs.add(sql);");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/*      ");
        this.out(sb, "\t *  @return int[]    ");
        this.out(sb, "\t */     ");
        this.out(sb, "\tpublic int[] executeBatch() throws SQLException {");
        this.out(sb, "\t\tint[] rs = new int[0];");
        this.out(sb, "\t\tConnection conn = this.ConnectionPool.getConnection();");
        this.out(sb, "\t\tif (conn == null)");
        this.out(sb, "\t\t\treturn rs;");
        this.out(sb, "\t\tStatement statement = null;");
        this.out(sb, "\t\tboolean defaultCommit;");
        this.out(sb, "\t\tdefaultCommit = conn.getAutoCommit();");
        this.out(sb, "\t\ttry {");
        this.out(sb, "\t\t\tconn.setAutoCommit(false);");
        this.out(sb, "\t\t\tstatement = conn.createStatement();");
        this.out(sb, "\t\t\tint c = 0;");
        this.out(sb, "\t\t\tif (m_SQLs != null && m_SQLs.size() > 0) {");
        this.out(sb, "\t\t\t\tc = m_SQLs.size();");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tif (c > 0) {");
        this.out(sb, "\t\t\t\tfor (int i = 0; i < c; i++) {");
        this.out(sb, "\t\t\t\t\tstatement.addBatch(m_SQLs.get(i));");
        this.out(sb, "\t\t\t\t}");
        this.out(sb, "          ");
        this.out(sb, "\t\t\t\trs = statement.executeBatch();");
        this.out(sb, "\t\t\t\tconn.commit();");
        this.out(sb, "\t\t\t} else {");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t} catch (Exception e) {");
        this.out(sb, "\t\t\tconn.rollback();");
        this.out(sb, "\t\t\te.printStackTrace();");
        this.out(sb, "          ");
        this.out(sb, "\t\t} finally {");
        this.out(sb, "\t\t\tconn.setAutoCommit(defaultCommit);");
        this.out(sb, "\t\t\tif (statement != null) {");
        this.out(sb, "\t\t\t\tstatement.clearBatch();");
        this.out(sb, "\t\t\t\tstatement.close();");
        this.out(sb, "\t\t\t}");
        this.out(sb, "\t\t\tClearSQL();");
        this.out(sb, "\t\t\tthis.ConnectionPool.releaseConnection(conn);");
        this.out(sb, "\t\t}");
        this.out(sb, "\t\treturn rs;");
        this.out(sb, "\t}\r\n");
        this.out(sb, "\t/* ");
        this.out(sb, "\t *   Clear SQL Batch   ");
        this.out(sb, "\t */");
        this.out(sb, "\tpublic void ClearSQL() {");
        this.out(sb, "\t\tif (m_SQLs == null)");
        this.out(sb, "\t\t\tm_SQLs = new ArrayList<String>();");
        this.out(sb, "\t\telse");
        this.out(sb, "\t\t\tm_SQLs.clear();");
        this.out(sb, "\t}");
        this.out(sb, "}");
        this.writeToFile(conf.getFilePath(), "AccessBase.java", sb.toString());
    }

    @Override
    public String getCopyright() {
        return "";
    }

    @Override
    public void exportViews(View at, Configure confTable) {
    }

    @Override
    public void exportProcedures(Configure confProcedure) {
    }

    public String findPrevPath(String path) {
        int index = path.lastIndexOf(46);
        if (index >= 0) {
            return path.substring(0, index);
        }
        return "";
    }

    @Override
    public void exportSequence(Configure conf) {
    }

    @Override
    public void exportSpringConfigure(Configure conf) {
    }

    @Override
    public void exportDwrConfigure(Configure conf) {
    }

    @Override
    public void exportGwtModule(Configure conf) {
        InputStream ins = this.getClass().getResourceAsStream("/template/gwt.xml");
        String txt = SchemaBase.readUTF8TextFile(ins);
        String[] gpaths = this.upPath(conf.path, conf.Package);
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("GWT_SOURCE_PATH", gpaths[1]);
        txt = this.replace(m2, txt);
        System.out.println("gwt module information " + gpaths[0] + " " + conf.getSchema() + "Data.gwt.xml");
        this.writeToFile(gpaths[0], conf.getSchema() + "Data.gwt.xml", txt);
        try {
            ins.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String[] upPath(String dataPath, String packageName) {
        String p = packageName.replace('.', '/');
        p = dataPath + "/" + p;
        int index = p.lastIndexOf(47);
        String[] r = new String[]{p.substring(0, index) + "/", p.substring(index + 1)};
        return r;
    }

    private String replace(Map<String, String> mapper, String template) {
        for (String key : mapper.keySet()) {
            template = template.replaceAll(key, mapper.get(key));
        }
        return template;
    }

    public String esacpeQuoto(String s) {
        if (Strings.isBlank((CharSequence)s)) {
            return "";
        }
        return s.replaceAll("\"", "\\\\\"");
    }

    public void genSimple(Configure conf, ITable table, StringBuilder sb) throws IOException {
        int i;
        com.mapway.database2java.model.schema.Column col;
        boolean needDocument = "1".equals(conf.getUseDocument());
        boolean needGwt = "1".equals(conf.getUseGwt());
        boolean needNutz = "1".equals(conf.getUseNutz());
        boolean needFieldIndex = "1".equals(conf.getUseFieldIndex());
        StringOutputStream ops = Lang.ops((StringBuilder)sb);
        JavaWriter writer = new JavaWriter((Writer)new OutputStreamWriter((OutputStream)ops));
        StringBuilder paras = new StringBuilder();
        this.out(paras, "<b>\u5b57\u6bb5\u5217\u8868</b>");
        for (int i2 = 0; i2 < table.getColumns().getCount(); ++i2) {
            com.mapway.database2java.model.schema.Column col2 = table.getColumns().getAt(i2);
            this.out(paras, col2.getJavaType() + " " + col2.getName() + " //" + col2.getComment());
        }
        int count = 0;
        for (int i3 = 0; i3 < table.getColumns().getCount(); ++i3) {
            com.mapway.database2java.model.schema.Column col3 = table.getColumns().getAt(i3);
            if (!col3.isPK()) continue;
            ++count;
        }
        writer.emitPackage(conf.getPackage()).emitImports(new Class[]{Date.class, BigDecimal.class, Timestamp.class});
        writer.emitEmptyLine().emitJavadoc("\u6570\u636e\u5e93\u8868-" + table.getComment(), new Object[]{paras.toString()});
        if (needNutz) {
            writer.emitAnnotation(Table.class, (Object)("\"" + table.getName() + "\""));
            if (count > 1) {
                StringBuilder pk = new StringBuilder();
                pk.append("{");
                for (int i4 = 0; i4 < table.getColumns().getCount(); ++i4) {
                    col = table.getColumns().getAt(i4);
                    if (!col.isPK()) continue;
                    if (pk.length() > 1) {
                        pk.append(",");
                    }
                    pk.append("\"").append(col.getJavaName()).append("\"");
                }
                pk.append("}");
                writer.emitAnnotation(PK.class, (Object)pk.toString());
            }
        }
        if (needDocument) {
            writer.emitAnnotation("cn.mapway.document.annotation.Doc", (Object)("\"" + table.getName() + " " + table.getComment() + "\""));
        }
        if (needGwt) {
            String i1 = "com.google.gwt.user.client.rpc.IsSerializable";
            String i2 = "com.ksyzt.gwt.client.data.IFieldValue";
            writer.beginType(conf.getPackage() + "." + table.getJavaName(), "class", EnumSet.of(Modifier.PUBLIC), null, new String[]{i1, i2});
        } else {
            writer.beginType(conf.getPackage() + "." + table.getJavaName(), "class", EnumSet.of(Modifier.PUBLIC));
        }
        if (needFieldIndex) {
            writer.emitJavadoc("\u8868" + table.getComment() + "\u4ee3\u7801\u540d\u79f0", new Object[0]);
            writer.emitField(String.class.getSimpleName(), "TBL_" + table.getName().toUpperCase(), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), "\"" + table.getName() + "\"");
        }
        writer.beginConstructor(EnumSet.of(Modifier.PUBLIC), new String[0]).endConstructor();
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            HashMap<String, String> attr;
            com.mapway.database2java.model.schema.Column col4 = table.getColumns().getAt(i);
            if (needFieldIndex) {
                writer.emitJavadoc("\u5b57\u6bb5\u7d22\u5f15" + col4.getComment() + " " + col4.getName(), new Object[0]);
                writer.emitField(String.class.getSimpleName(), "FLD_" + col4.getName().toUpperCase(), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), "\"" + col4.getName() + "\"");
            }
            writer.emitEmptyLine().emitJavadoc("\u5b57\u6bb5 " + col4.getName() + " " + col4.getComment(), new Object[0]);
            if (needNutz) {
                if (count == 1 && col4.isPK()) {
                    if (col4.getJavaType().contains("String")) {
                        writer.emitAnnotation(Name.class);
                    } else if (col4.isAuto()) {
                        writer.emitAnnotation(Id.class);
                    } else {
                        attr = new HashMap();
                        attr.put("auto", "false");
                        writer.emitAnnotation(Id.class, attr);
                    }
                }
                writer.emitAnnotation(Column.class, (Object)("\"" + col4.getName() + "\""));
            }
            if (needDocument) {
                attr = new HashMap<String, String>();
                String v = Strings.escapeHtml((CharSequence)col4.getComment());
                if (Strings.isEmpty((CharSequence)v)) {
                    v = col4.getName();
                }
                attr.put("value", "\"" + v + "\"");
                attr.put("example", "\"\"");
                writer.emitAnnotation("cn.mapway.document.annotation.ApiField", attr);
            }
            writer.emitField(col4.getJavaType(), col4.getJavaName(), EnumSet.of(Modifier.PUBLIC));
        }
        for (i = 0; i < table.getColumns().getCount(); ++i) {
            com.mapway.database2java.model.schema.Column col5 = table.getColumns().getAt(i);
            String retString = "return " + col5.getName() + "  " + col5.getComment() + "  " + col5.getDatabaseType();
            writer.emitJavadoc("\u8fd4\u56de\u5b57\u6bb5" + col5.getName() + " " + col5.getComment(), new Object[]{retString});
            writer.beginMethod(col5.getJavaType(), "get" + Strings.upperFirst((CharSequence)col5.getJavaName()), EnumSet.of(Modifier.PUBLIC), new String[0]);
            writer.emitStatement("return this.%s", new Object[]{col5.getJavaName()});
            writer.endMethod();
            String paraString = "@param " + col5.getName() + "  " + col5.getComment() + "  " + col5.getDatabaseType();
            writer.emitJavadoc("\u8bbe\u7f6e\u5b57\u6bb5" + col5.getName() + " " + col5.getComment(), new Object[]{paraString});
            ArrayList<String> paraList = new ArrayList<String>(2);
            paraList.add(col5.getJavaType());
            paraList.add(col5.getJavaName());
            writer.beginMethod("void", "set" + Strings.upperFirst((CharSequence)col5.getJavaName()), EnumSet.of(Modifier.PUBLIC), paraList, null);
            writer.emitStatement("this.%s=%s", new Object[]{col5.getJavaName(), col5.getJavaName()});
            writer.endMethod();
        }
        if (needGwt) {
            int i5;
            if (needFieldIndex) {
                for (i = 0; i < table.getColumns().getCount(); ++i) {
                    com.mapway.database2java.model.schema.Column col6 = table.getColumns().getAt(i);
                    writer.emitJavadoc("\u83b7\u53d6\u5b57" + col6.getName() + "\u7d22\u5f15", new Object[0]).emitField(Integer.class.getSimpleName(), "IDX_" + col6.getName().toUpperCase(), EnumSet.of(Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL), i + "");
                }
            }
            writer.emitJavadoc("\u6839\u636e\u5b57\u6bb5\u540d\u79f0\u83b7\u53d6\u5b57\u6bb5\u7684.", new Object[0]);
            writer.emitAnnotation(Override.class);
            ArrayList<String> methodParas = new ArrayList<String>(4);
            methodParas.add(String.class.getSimpleName());
            methodParas.add("fieldName");
            methodParas.add(Integer.class.getSimpleName());
            methodParas.add("fieldIndex");
            writer.beginMethod(Object.class.getSimpleName(), "getFieldValue", EnumSet.of(Modifier.PUBLIC), methodParas, null);
            writer.beginControlFlow("if (fieldName != null && fieldName.length() > 0)");
            for (i5 = 0; i5 < table.getColumns().getCount(); ++i5) {
                col = table.getColumns().getAt(i5);
                writer.beginControlFlow("if (FLD_%s.equals(fieldName))", new Object[]{col.getName().toUpperCase()});
                writer.emitStatement("return this.%s", new Object[]{col.getJavaName()});
                writer.endControlFlow();
            }
            writer.nextControlFlow("else if (fieldIndex != null && fieldIndex >= 0 && fieldIndex < %s)", new Object[]{table.getColumns().getCount()});
            for (i5 = 0; i5 < table.getColumns().getCount(); ++i5) {
                col = table.getColumns().getAt(i5);
                writer.beginControlFlow("if (fieldIndex == %d)", new Object[]{i5});
                writer.emitStatement("return this.%s", new Object[]{col.getJavaName()});
                writer.endControlFlow();
            }
            writer.nextControlFlow("else");
            writer.emitStatement("return null", new Object[0]);
            writer.endControlFlow();
            writer.emitStatement("return null", new Object[0]);
            writer.endMethod();
        }
        writer.endType();
        writer.close();
    }

    @Override
    public void exportSimpleBean(Configure conf) throws IOException {
        StringBuilder sb;
        String fileName = conf.getFilePath();
        Tables tables = this.getTables();
        for (int i = 0; i < tables.getCount(); ++i) {
            ITable t = tables.getAt(i);
            sb = new StringBuilder();
            this.genSimple(conf, t, sb);
            this.writeToFile(fileName, t.getJavaName() + ".java", sb.toString());
        }
        Tables views = this.getTables();
        for (int i = 0; i < tables.getCount(); ++i) {
            ITable t = views.getAt(i);
            sb = new StringBuilder();
            this.genSimple(conf, t, sb);
            this.writeToFile(fileName, t.getJavaName() + ".java", sb.toString());
        }
    }

    public static void main(String[] args) {
    }
}

