/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.module;

import cn.mapway.document.module.Entry;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class Group
implements Serializable {
    public String name = "";
    public String summary;
    private Group parent;
    public String fullName = "/";
    public List<Entry> entries = new ArrayList<Entry>();
    public List<Group> subGroups = new ArrayList<Group>();

    public Group() {
        this.setParent(null);
    }

    public void addChildGroup(Group g) {
        g.setParent(this);
        this.subGroups.add(g);
    }

    public void clearChildGroup() {
        this.subGroups.clear();
    }

    public void removeChildGroup(Group g) {
        this.subGroups.remove(g);
    }

    public List<Group> getChildGroups() {
        return this.subGroups;
    }

    public String getPath() {
        ArrayList<String> strArray = new ArrayList<String>();
        for (Group g = this.getParent(); g != null; g = g.getParent()) {
            strArray.add(g.name);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = strArray.size() - 1; i >= 0; --i) {
            if (((String)strArray.get(i)).equals("/")) continue;
            sb.append("/" + (String)strArray.get(i));
        }
        return sb.toString();
    }

    public Group getParent() {
        return this.parent;
    }

    public void setParent(Group parent) {
        this.parent = parent;
    }

    public void sort() {
        Collections.sort(this.subGroups, new Comparator<Group>(){

            @Override
            public int compare(Group o1, Group o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        Collections.sort(this.entries, new Comparator<Entry>(){

            @Override
            public int compare(Entry o1, Entry o2) {
                return o1.order > o2.order ? 1 : -1;
            }
        });
        for (Group g : this.subGroups) {
            g.sort();
        }
    }
}

