/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.parser;

import cn.mapway.document.annotation.ApiField;
import cn.mapway.document.annotation.DevelopmentState;
import cn.mapway.document.annotation.Doc;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.module.Entry;
import cn.mapway.document.module.Group;
import cn.mapway.document.module.ObjectInfo;
import cn.mapway.document.parser.Deeps;
import cn.mapway.document.parser.GenContext;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nutz.castor.Castors;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Mirror;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.resource.Scans;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

public class SpringParser {
    private static final Log log = Logs.getLog(SpringParser.class);
    GenContext mContext;
    Deeps deeps;

    public ApiDoc parse(GenContext context, String ... packageNames) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        this.mContext = context;
        if (packageNames.length == 0) {
            return new ApiDoc();
        }
        ArrayList clzs = new ArrayList();
        for (String pk : packageNames) {
            List clz = Scans.me().scanPackage(pk);
            clzs.addAll(clz);
        }
        log.debug((Object)("mapway-doc parse classes: " + clzs.size()));
        ApiDoc doc = new ApiDoc();
        doc.author = context.getAuthor();
        doc.basePath = context.getBasepath();
        doc.title = context.getDocTitle();
        for (Class clz : clzs) {
            if (clz.getAnnotation(Controller.class) == null && clz.getAnnotation(RestController.class) == null) continue;
            this.parseClass(doc, clz);
        }
        doc.root.name = doc.title;
        doc.root.fullName = "/" + doc.title;
        doc.root.summary = "";
        doc.sort();
        return doc;
    }

    private void parseClass(ApiDoc document, Class<?> clz) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Doc doc = clz.getAnnotation(Doc.class);
        if (doc == null) {
            log.debug((Object)("class " + clz.getName() + " is not annotated with Doc"));
            return;
        }
        this.populateGroup(document, clz);
    }

    private void populateGroup(ApiDoc document, Class<?> c) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Method m;
        int i;
        String[] paths;
        log.debug((Object)("process " + c.getName()));
        Doc doc = c.getAnnotation(Doc.class);
        String group_base_path = doc.group();
        Group apigroup = document.findGroup(group_base_path);
        apigroup.summary = apigroup.summary + (doc.desc().length() > 0 ? doc.desc() : "");
        apigroup.order = doc.order();
        String basepath = "";
        RequestMapping rm = c.getAnnotation(RequestMapping.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            basepath = paths[0];
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            RequestMapping rm1 = m.getAnnotation(RequestMapping.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        for (i = 0; i < list.size(); ++i) {
            m = (Method)list.get(i);
            Entry entry = this.handleMethod(document, group_base_path, m);
            entry.parentClassName = c.getName();
            if (entry == null) continue;
            entry.relativePath = this.mContext.getBasepath() + basepath + entry.relativePath;
        }
    }

    private Entry handleMethod(ApiDoc document, String group_base_path, Method m) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Entry e = new Entry();
        RequestMapping rm = m.getAnnotation(RequestMapping.class);
        if (rm != null) {
            String[] paths = rm.value();
            if (paths != null && paths.length != 0) {
                e.relativePath = paths[0];
            }
            e.invokeMethod = "GET";
            RequestMethod[] ms = rm.method();
            if (ms != null) {
                for (int i = 0; i < ms.length; ++i) {
                    Class<?>[] rm0 = ms[i];
                    if (!rm0.equals((Object)RequestMethod.POST)) continue;
                    e.invokeMethod = "POST";
                    break;
                }
            }
        }
        if (e.relativePath.length() == 0) {
            return null;
        }
        e.methodName = m.getName();
        Doc summary = m.getAnnotation(Doc.class);
        if (summary != null) {
            e.title = summary.value();
            e.summary = summary.desc() == null ? "" : summary.desc();
            e.order = summary.order();
            e.author = summary.author();
            e.state = this.transState(summary.state());
        }
        Class<?>[] ps = m.getParameterTypes();
        Class<?> out = m.getReturnType();
        for (Class<?> clz : ps) {
            ObjectInfo p;
            String name = clz.getSimpleName();
            String pname = clz.getPackage().getName();
            if (name.startsWith("Http") || pname.startsWith("org.") || (p = this.handleParameter(clz, name)) == null) continue;
            e.input.add(p);
        }
        e.output = this.handleParameter(out, "out");
        String group_path = group_base_path + summary.group();
        Group apiGroup = document.findGroup(group_path);
        apiGroup.entries.add(e);
        return e;
    }

    private String transState(DevelopmentState state) {
        if (state == DevelopmentState.FINISH) {
            return "\u5df2\u5b8c\u6210";
        }
        if (state == DevelopmentState.OBSOLETED) {
            return "\u5df2\u5e9f\u5f03";
        }
        if (state == DevelopmentState.PROCESS) {
            return "\u5f00\u53d1\u4e2d";
        }
        if (state == DevelopmentState.UNSTART) {
            return "\u672a\u5f00\u53d1";
        }
        return "";
    }

    private ObjectInfo handleParameter(Class<?> clz, String name) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ObjectInfo p = new ObjectInfo();
        Doc summary = clz.getAnnotation(Doc.class);
        p.name = name == null ? clz.getSimpleName() : name;
        p.title = summary == null ? "" : summary.value();
        p.summary = summary == null ? "" : summary.desc();
        p.type = this.isPrimitive(clz) ? clz.getSimpleName() : clz.getName();
        String sum = "";
        for (Class<?> superclazz = clz.getSuperclass(); superclazz != null; superclazz = superclazz.getSuperclass()) {
            Doc summary1 = superclazz.getAnnotation(Doc.class);
            if (sum.length() > 0) {
                sum = sum + "<br/>";
            }
            sum = sum + (summary1 == null ? "" : summary1.desc());
        }
        p.summary = sum + (summary == null ? "" : summary.desc());
        this.deeps = new Deeps();
        this.deeps.push(clz.getName(), this.deeps.getLevel());
        Object instance = null;
        instance = this.newInstance(clz);
        for (Field f : clz.getFields()) {
            ObjectInfo fld = this.handleField(instance, f);
            if (fld == null) continue;
            p.fields.add(fld);
        }
        p.json = instance != null ? Json.toJson((Object)instance, (JsonFormat)JsonFormat.full()) : "{}";
        return p;
    }

    private ObjectInfo handleField(Object instance, Field f) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        this.deeps.incLevel();
        ApiField wf = f.getAnnotation(ApiField.class);
        if (wf != null) {
            ObjectInfo fi = new ObjectInfo();
            fi.manditary = wf.mandidate();
            fi.title = wf.value();
            fi.length = wf.length();
            fi.example = wf.example();
            fi.name = f.getName();
            fi.type = f.getType().getName();
            this.deeps.push(f.getType().getName(), this.deeps.getLevel());
            if (this.isPrimitive(f.getType())) {
                fi.type = f.getType().getSimpleName();
                if (instance != null) {
                    f.set(instance, Castors.me().castTo((Object)wf.example(), f.getType()));
                }
            } else if (this.isList(f)) {
                int count;
                Type type = this.getGenericType(f);
                Class c = (Class)type;
                fi.type = "List<" + c.getSimpleName() + ">";
                ArrayList<Object> list = new ArrayList<Object>();
                if (instance != null) {
                    f.set(instance, list);
                }
                if ((count = this.deeps.getPreLevelCount(c.getName(), this.deeps.getLevel())) > 2) {
                    this.deeps.decLevel();
                    return null;
                }
                Object cinstance = this.newInstance(c);
                Doc fdoc = c.getAnnotation(Doc.class);
                if (fdoc != null) {
                    fi.summary = fdoc.desc();
                }
                list.add(cinstance);
                for (Field f1 : c.getFields()) {
                    ObjectInfo o = this.handleField(cinstance, f1);
                    if (o == null) continue;
                    fi.fields.add(o);
                }
            } else {
                int count = this.deeps.getPreLevelCount(f.getType().getName(), this.deeps.getLevel());
                if (count > 2) {
                    this.deeps.decLevel();
                    return null;
                }
                Object cinstance = null;
                cinstance = this.newInstance(f.getType());
                f.set(instance, cinstance);
                Doc fdoc = cinstance.getClass().getAnnotation(Doc.class);
                if (fdoc != null) {
                    fi.summary = fdoc.desc();
                }
                for (Field f1 : f.getType().getFields()) {
                    ObjectInfo o = this.handleField(cinstance, f1);
                    if (o == null) continue;
                    fi.fields.add(o);
                }
            }
            this.deeps.decLevel();
            return fi;
        }
        this.deeps.decLevel();
        return null;
    }

    private Object newInstance(Class<?> c) {
        Mirror m = Mirror.me(c);
        if (m.isInt()) {
            return 0;
        }
        if (m.isMap()) {
            return new HashMap();
        }
        if (m.isDouble()) {
            return 0.0;
        }
        if (m.isFloat()) {
            return Float.valueOf(0.0f);
        }
        if (m.isBoolean()) {
            return true;
        }
        if (m.isByte()) {
            Byte b = new Byte("0");
            return b;
        }
        if (m.isLong()) {
            return new Long(0L);
        }
        return m.born(new Object[0]);
    }

    private boolean isList(Field f) {
        return f.getType().isAssignableFrom(List.class);
    }

    private Type getGenericType(Field f) {
        ParameterizedType pt = (ParameterizedType)f.getGenericType();
        return pt.getActualTypeArguments()[0];
    }

    private boolean isPrimitive(Class<?> c) {
        String[] ps;
        String name = c.getName();
        for (String s : ps = new String[]{"int", "Integer", "float", "FLoat", "Double", "double", "long", "Long", "Date", "DateTime", "String", "boolean", "Boolean", "char", "short", "byte", "Timestamp"}) {
            if (!name.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        SpringParser p = new SpringParser();
        ApiDoc doc = p.parse(new GenContext(), "cn.mapway.doc2.test");
        System.out.println(Json.toJson((Object)doc));
    }
}

