package cn.mapway.document.word;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;

import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.BreakClear;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.UnderlinePatterns;
import org.apache.poi.xwpf.usermodel.VerticalAlign;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

import cn.mapway.document.module.ApiDoc;

// TODO: Auto-generated Javadoc
/**
 * 输出WORD文档.
 *
 * @author zhangjianshe
 */
public class WordExport {

	/**
	 * 转成WORD文件格式.
	 *
	 * @param api the api
	 * @param fileName the file name
	 * @throws IOException Signals that an I/O exception has occurred.
	 */
	public void toWord(ApiDoc api, String fileName) throws IOException {
		XWPFDocument doc = new XWPFDocument();
		createCover(doc, api);
		FileOutputStream out = new FileOutputStream(fileName);
		doc.write(out);
		out.close();
		doc.close();
	}

	/**
	 * Creates the cover.
	 *
	 * @param doc the doc
	 * @param api the api
	 */
	private void createCover(XWPFDocument doc, ApiDoc api) {

		for (int i = 0; i < 10; i++) {
			doc.createParagraph();
		}

		XWPFParagraph p1 = doc.createParagraph();

		p1.setAlignment(ParagraphAlignment.CENTER);
		XWPFRun r1 = p1.createRun();
		r1.setBold(true);
		r1.setText(api.title + "API接口文档");
		r1.setBold(true);
		r1.setFontSize(34);
		r1.setFontFamily("黑体");
		r1.setTextPosition(100);

		doc.createParagraph();

		p1 = doc.createParagraph();
		p1.setAlignment(ParagraphAlignment.CENTER);
		r1 = p1.createRun();
		r1.setText("张建设");

		p1 = doc.createParagraph();
		p1.setAlignment(ParagraphAlignment.CENTER);
		r1 = p1.createRun();
		Date d = new Date();
		r1.setText(d.toLocaleString());

		r1.addBreak(BreakType.PAGE);
	}

	
}
