/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.GwtConnextorExport;
import cn.mapway.document.helper.JarInfo;
import cn.mapway.document.helper.JavaConnextorExport;
import cn.mapway.document.helper.StrUtil;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.resource.Template;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;

public class JarHelper {
    private String antHome = "";

    public void setAntHome(String home) {
        this.antHome = home;
    }

    public List<JarInfo> jar(ApiDoc api, String path, String packageName, String className, String libPath) {
        ArrayList<JarInfo> jars = new ArrayList<JarInfo>();
        String strpath = path;
        String packname = packageName;
        String clsName = className;
        String strlibPath = libPath;
        JarInfo jar = this.exportJavaConnector(api, strpath, packname, clsName, strlibPath);
        if (jar != null) {
            jars.add(jar);
        }
        if ((jar = this.exportGwtConnector(api, path, packageName, className, libPath)) != null) {
            jars.add(jar);
        }
        Files.createDirIfNoExists((String)(path + "/source/gwt"));
        return jars;
    }

    public JarInfo exportGwtConnector(ApiDoc api, String path, String packageName, String className, String libPath) {
        packageName = packageName + ".client";
        String fileName = className + "Gwt";
        Files.createDirIfNoExists((String)path);
        String javaConnectorPath = path + "/source/gwt";
        String javaConnectorSourcePath = javaConnectorPath + "/src";
        Files.createDirIfNoExists((String)javaConnectorSourcePath);
        GwtConnextorExport exportJava = new GwtConnextorExport();
        String code = exportJava.export(api, packageName, fileName);
        String p = JarHelper.makePathFile(javaConnectorSourcePath, packageName, fileName);
        Files.write((String)p, (Object)code);
        String template = "";
        try {
            template = Template.readTemplate("/cn/mapway/document/resource/gwtmodule.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        String gwtmoduleName = this.makeGwtModuleFile(javaConnectorSourcePath, packageName, fileName);
        Files.write((String)gwtmoduleName, (Object)template);
        try {
            template = Template.readTemplate("/cn/mapway/document/resource/buildgwt.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        javaConnectorPath = javaConnectorPath.replace('\\', '/');
        javaConnectorSourcePath = javaConnectorSourcePath.replace('\\', '/');
        libPath = libPath.replace('\\', '/');
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("--SOURCE-PATH--", javaConnectorSourcePath);
        vars.put("--OUT-PATH--", javaConnectorPath + "/target");
        vars.put("--OUT-FILE-NAME--", fileName + ".jar");
        vars.put("--LIB-PATH--", libPath);
        String t = StrUtil.replace2(template, vars);
        String buildFile = javaConnectorPath + File.separator + "build.xml";
        Files.write((String)buildFile, (Object)t);
        String cmd = Lang.isWin() ? "\\bin\\ant.bat" : "/bin/ant";
        String exec = this.antHome + cmd;
        this.exec(exec, javaConnectorPath);
        JarInfo info = new JarInfo();
        info.fileName = fileName + ".jar";
        info.path = javaConnectorPath + "/target";
        File f = new File(info.path + "/" + info.fileName);
        info.size = f.length();
        info.summary = "Gwt\u8bbf\u95eeAPI\u8fde\u63a5\u5668";
        return info;
    }

    private JarInfo exportJavaConnector(ApiDoc api, String path, String packageName, String className, String libPath) {
        Files.createDirIfNoExists((String)path);
        String javaConnectorPath = path + "/source/java";
        String javaConnectorSourcePath = javaConnectorPath + "/src";
        String fileName = className + "Java";
        Files.createDirIfNoExists((String)javaConnectorSourcePath);
        JavaConnextorExport exportJava = new JavaConnextorExport();
        String code = exportJava.export(api, packageName, fileName);
        String p = JarHelper.makePathFile(javaConnectorSourcePath, packageName, className + "Java");
        Files.write((String)p, (Object)code);
        String template = "";
        try {
            template = Template.readTemplate("/cn/mapway/document/resource/build.xml");
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        javaConnectorPath = javaConnectorPath.replace('\\', '/');
        javaConnectorSourcePath = javaConnectorSourcePath.replace('\\', '/');
        libPath = libPath.replace('\\', '/');
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("--SOURCE-PATH--", javaConnectorSourcePath);
        vars.put("--OUT-PATH--", javaConnectorPath + "/target");
        vars.put("--OUT-FILE-NAME--", fileName + ".jar");
        vars.put("--LIB-PATH--", libPath);
        String t = StrUtil.replace2(template, vars);
        String buildFile = javaConnectorPath + File.separator + "build.xml";
        Files.write((String)buildFile, (Object)t);
        String cmd = Lang.isWin() ? "\\bin\\ant.bat" : "/bin/ant";
        String exec = this.antHome + cmd;
        this.exec(exec, javaConnectorPath);
        JarInfo info = new JarInfo();
        info.fileName = fileName + ".jar";
        info.path = javaConnectorPath + "/target";
        File f = new File(info.path + "/" + info.fileName);
        info.size = f.length();
        info.summary = "Java\u8bbf\u95eeAPI\u8fde\u63a5\u5668";
        return info;
    }

    private String makeGwtModuleFile(String javaConnectorSourcePath, String packageName, String className) {
        String p = packageName.replace(".", File.separator);
        return javaConnectorSourcePath + "/" + p + "/" + className + ".gwt.xml";
    }

    public static String makePathFile(String javaConnectorSourcePath, String packageName, String className) {
        String p = packageName.replace(".", File.separator);
        return javaConnectorSourcePath + File.separator + p + File.separator + className + ".java";
    }

    private void exec(String cmd, String dir) {
        try {
            Runtime.getRuntime().exec(cmd, null, new File(dir));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

