/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.JarHelper;
import cn.mapway.document.helper.JarInfo;
import cn.mapway.document.helper.JavascriptExport;
import cn.mapway.document.helper.ParseType;
import cn.mapway.document.helper.Scans;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.parser.GenContext;
import cn.mapway.document.parser.SpringParser;
import java.io.IOException;
import java.util.List;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Strings;

public class DocHelper {
    private String antHome = "";
    private static byte[] gifdata = new byte[]{71, 73, 70, 56, 57, 97, 1, 0, 1, 0, -128, 0, 0, -1, -1, -1, -1, -1, -1, 33, -7, 4, 1, 10, 0, 1, 0, 44, 0, 0, 0, 0, 1, 0, 1, 0, 0, 2, 2, 76, 1, 0, 59};

    public void setAntHome(String home) {
        this.antHome = home;
    }

    public void toWord(ApiDoc api, String fileName) throws IOException {
    }

    public ApiDoc toDoc(ParseType pt, GenContext context, String ... packages) {
        if (pt == ParseType.PT_SPRING) {
            SpringParser parser = new SpringParser();
            ApiDoc doc = new ApiDoc();
            try {
                doc = parser.parse(context, packages);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            return doc;
        }
        return new ApiDoc();
    }

    public String genHTML(ParseType pt, GenContext context, String ... packages) {
        ApiDoc doc = this.toDoc(pt, context, packages);
        return this.genHTML(doc);
    }

    public String genHTML(ApiDoc doc) {
        String template = Scans.readResource("cn.mapway.document.resource", "doctemplate.html");
        String ui = Scans.readResource("cn.mapway.document.resource", "apidoc.nocache.js");
        String json = Json.toJson((Object)doc, (JsonFormat)JsonFormat.tidy());
        String customStyle = "";
        if (!Strings.isBlank((CharSequence)doc.cssStyle) && doc.cssStyle.length() > 4) {
            String start = doc.cssStyle.substring(0, 4);
            if (start.compareToIgnoreCase("http") == 0) {
                customStyle = "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + doc.cssStyle + "\">";
            } else {
                customStyle = "<style>";
                customStyle = customStyle + doc.cssStyle;
                customStyle = customStyle + "</style>";
            }
        }
        System.out.print("custom style>" + customStyle);
        template = template.replace("API_CSS_STYLE", customStyle);
        template = template.replace("API_DOC_DATA", json);
        template = template.replace("API_DOC_UI", ui);
        return template;
    }

    public static byte[] getClearGifData() {
        return gifdata;
    }

    public String genDoc(ParseType pt, GenContext context, String ... packages) {
        ApiDoc doc = this.toDoc(pt, context, packages);
        String wordFile = "";
        return wordFile;
    }

    public List<JarInfo> jar(ApiDoc api, String path, String packageName, String className, String libPath) {
        JarHelper helper = new JarHelper();
        helper.setAntHome(this.antHome);
        return helper.jar(api, path, packageName, className, libPath);
    }

    public String toJavascript(ParseType ptSpring, GenContext context, String packageNames, String exportName) {
        ApiDoc doc = this.toDoc(ptSpring, context, packageNames);
        JavascriptExport export = new JavascriptExport();
        String data = export.toJavascript(doc, context.getBasepath(), exportName);
        return data;
    }
}

