/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.main.ApiTree;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.Group;
import cn.mapway.document.ui.client.resource.SysResource;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class EntryList
extends Grid {
    int row = 0;

    public EntryList() {
        this.init();
    }

    private void init() {
        Element e = this.getElement();
        e.setAttribute("borderCollapse", "collapse");
        e.setAttribute("cellPadding", "7px");
        e.setAttribute("cellSpacing", "1px");
        e.setAttribute("bgColor", "#c0c0c0");
        this.resize(1, 5);
        int row = 0;
        int col = 0;
        Label l = new Label("\u5e8f\u53f7");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u63a5\u53e3\u540d\u79f0");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u6620\u5c04\u7f51\u5740");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u5f00\u53d1\u72b6\u6001");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u5f00\u53d1\u8005");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        this.getCellFormatter().setHorizontalAlignment(row, col - 1, HasHorizontalAlignment.ALIGN_RIGHT);
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        rf.setStylePrimaryName(row, SysResource.INSTANCE.getCss().rowh());
    }

    public String parse(Group group, String searchText) {
        this.row = 1;
        int count = this.findCount(group, searchText);
        this.resize(count + 1, 5);
        String html = this.parseGroup(group, searchText);
        return html;
    }

    private String parseGroup(Group group, String searchText) {
        int i;
        String html = "";
        if (group.summary() != null && !group.summary().equals("null") && group.summary().length() > 0) {
            html = "<div class='" + SysResource.INSTANCE.getCss().entryTitle() + "'>" + group.name() + "</div><div class='" + SysResource.INSTANCE.getCss().desc() + "'>" + group.summary() + "</div>";
        }
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        for (i = 0; i < group.entries().length(); ++i) {
            Entry e = (Entry)group.entries().get(i);
            boolean ok = false;
            ok = searchText == null || searchText.length() == 0 ? true : e.title().contains(searchText) || e.url().contains(searchText) || e.author().contains(searchText);
            if (!ok) continue;
            int column = 0;
            this.setWidget(this.row, column++, (Widget)new Label(this.row + ""));
            String tags = ApiTree.buildTags(e.tags());
            HTML title = new HTML();
            title.setHTML(tags + e.title());
            this.setWidget(this.row, column++, (Widget)title);
            this.setWidget(this.row, column++, (Widget)new Label(e.url()));
            this.setWidget(this.row, column++, (Widget)new Label(e.state()));
            this.setWidget(this.row, column++, (Widget)new Label(e.author()));
            this.getCellFormatter().setHorizontalAlignment(this.row, column - 1, HasHorizontalAlignment.ALIGN_RIGHT);
            String style = this.row % 2 == 0 ? SysResource.INSTANCE.getCss().row0() : SysResource.INSTANCE.getCss().row1();
            rf.setStylePrimaryName(this.row, style);
            ++this.row;
        }
        for (i = 0; i < group.subGroups().length(); ++i) {
            html = html + this.parseGroup((Group)group.subGroups().get(i), searchText);
        }
        return html;
    }

    public int findCount(Group group, String searchText) {
        int i;
        Integer count = 0;
        for (i = 0; i < group.entries().length(); ++i) {
            boolean ok = false;
            Entry e = (Entry)group.entries().get(i);
            ok = searchText == null || searchText.length() == 0 ? true : e.title().contains(searchText) || e.url().contains(searchText) || e.author().contains(searchText);
            if (!ok) continue;
            count = count + 1;
        }
        for (i = 0; i < group.subGroups().length(); ++i) {
            count = count + this.findCount((Group)group.subGroups().get(i), searchText);
        }
        return count;
    }
}

