/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.tools;

import java.util.LinkedList;
import java.util.List;
import org.nutz.lang.Strings;
import org.nutz.lang.random.R;

public class TableBuilder {
    public static String[][] UTF8TABLE = new String[][]{{"\u250c", "\u2500", "\u252c", "\u2500", "\u2510"}, {"\u2502", " ", "\u253c", " ", "\u2502"}, {"\u251c", "\u2500", "\u253c", "\u2500", "\u2524"}, {"\u2502", " ", "\u253c", " ", "\u2502"}, {"\u2514", "\u2500", "\u2534", "\u2500", "\u2518"}};
    public static String[][] ASICIITABLE = new String[][]{{"+", "-", "+", "-", "+"}, {"+", "-", "+", "-", "+"}, {"+", "-", "+", "-", "+"}, {"+", "-", "+", "-", "+"}, {"+", "-", "+", "-", "+"}};
    public String[][] TABLE = ASICIITABLE;
    int padding = 1;
    List<String[]> rows = new LinkedList<String[]>();
    int columns = 0;

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void addRow(String ... cols) {
        this.rows.add(cols);
    }

    private int[] colWidths() {
        for (String[] row : this.rows) {
            this.columns = Math.max(this.columns, row.length);
        }
        int[] widths = new int[this.columns];
        for (String[] row : this.rows) {
            for (int colNum = 0; colNum < row.length; ++colNum) {
                widths[colNum] = Math.max(widths[colNum], Strings.charLength((CharSequence)row[colNum]));
            }
        }
        return widths;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int[] colWidths = this.colWidths();
        this.printTopLine(buf, colWidths);
        for (int index = 0; index < this.rows.size(); ++index) {
            String[] row = this.rows.get(index);
            for (int colNum = 0; colNum < row.length; ++colNum) {
                if (colNum == 0) {
                    buf.append(this.TABLE[3][0]);
                }
                int colwidth = colWidths[colNum];
                buf.append(Strings.dup((char)' ', (int)this.padding));
                buf.append(row[colNum]);
                buf.append(Strings.dup((char)' ', (int)(colwidth - row[colNum].length())));
                buf.append(Strings.dup((char)' ', (int)this.padding));
                if (colNum == colWidths.length - 1) {
                    buf.append('\u2502');
                    continue;
                }
                buf.append('\u2502');
            }
            buf.append('\n');
            if (index == this.rows.size() - 1) {
                this.printBottomLine(buf, colWidths, row);
                continue;
            }
            this.printMiddleLine(buf, colWidths, row);
        }
        return buf.toString();
    }

    private void printTopLine(StringBuilder buf, int[] colWidths) {
        for (int colNum = 0; colNum < colWidths.length; ++colNum) {
            if (colNum == 0) {
                buf.append(this.TABLE[0][0]);
            }
            int colwidth = colWidths[colNum];
            buf.append(Strings.dup((CharSequence)this.TABLE[0][1], (int)(colwidth + this.padding * 2)));
            if (colNum == colWidths.length - 1) {
                buf.append(this.TABLE[0][4]);
                continue;
            }
            buf.append(this.TABLE[0][2]);
        }
        buf.append('\n');
    }

    private void printMiddleLine(StringBuilder buf, int[] colWidths, String[] row) {
        for (int colNum = 0; colNum < colWidths.length; ++colNum) {
            if (colNum == 0) {
                buf.append(this.TABLE[1][0]);
            }
            int colwidth = colWidths[colNum];
            buf.append(Strings.dup((CharSequence)this.TABLE[1][1], (int)(colwidth + this.padding * 2)));
            if (colNum == colWidths.length - 1) {
                buf.append(this.TABLE[1][2]);
                continue;
            }
            buf.append(this.TABLE[1][1]);
        }
        buf.append('\n');
    }

    private void printBottomLine(StringBuilder buf, int[] colWidths, String[] row) {
        for (int colNum = 0; colNum < colWidths.length; ++colNum) {
            if (colNum == 0) {
                buf.append(this.TABLE[2][0]);
            }
            int colwidth = colWidths[colNum];
            buf.append(Strings.dup((CharSequence)this.TABLE[2][1], (int)(colwidth + this.padding * 2)));
            if (colNum == colWidths.length - 1) {
                buf.append(this.TABLE[1][2]);
                continue;
            }
            buf.append(this.TABLE[2][2]);
        }
        buf.append('\n');
    }

    public static void main(String[] args) {
        TableBuilder tb = new TableBuilder();
        tb.addRow("title", "url", "special");
        for (int i = 0; i < 10; ++i) {
            tb.addRow(R.sg((int)4, (int)25).next(), "http://www.baidu.com/" + i);
        }
        tb.addRow("", "", "Hello", "touch");
        System.out.println(tb);
    }
}

