/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.Scans;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.module.Entry;
import cn.mapway.document.module.Group;
import org.nutz.lang.random.R;

public class JavascriptExport {
    private void exportGroup(ApiDoc api, Group group, StringBuilder sb, String clsName) {
        for (Entry e : group.entries) {
            sb.append("/*\r\n");
            sb.append(" *" + e.methodName + "\r\n");
            sb.append("*/\r\n");
            sb.append(clsName + ".prototype." + e.methodName + "=function(data,ondata,onerror){\r\n");
            if (e.invokeMethods.contains("GET")) {
                sb.append("\t data=\\$.extend(data,{token:\\$.cookie('token')});\r\n");
                sb.append("\t return this.http_get(this.basepath+'" + e.relativePath + "',data,ondata,onerror);\r\n");
            } else if (e.invokeMethods.contains("POST")) {
                sb.append("\t data=\\$.extend(data,{token:\\$.cookie('token')});\r\n");
                sb.append("\t return this.http_post(this.basepath+'" + e.relativePath + "',data,ondata,onerror);\r\n");
            }
            sb.append("}\r\n");
        }
        for (Group g : group.getChildGroups()) {
            this.exportGroup(api, g, sb, clsName);
        }
    }

    public final String toJavascript(ApiDoc api, String basepath, String exportName) {
        String template = Scans.readResource("cn.mapway.document.resource", "javascript.txt");
        StringBuilder sb = new StringBuilder();
        String clsName = "a" + R.UU16();
        this.exportGroup(api, api.root, sb, clsName);
        template = template.replaceAll("\\$\\{title\\}", api.title);
        template = template.replaceAll("\\$\\{name\\}", clsName);
        template = template.replaceAll("\\$\\{methods\\}", sb.toString());
        template = template.replaceAll("\\$\\{basepath\\}", basepath);
        template = template.replaceAll("\\$\\{exportName\\}", exportName);
        return template;
    }
}

