/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.test;

import cn.mapway.document.ui.client.component.Clients;
import cn.mapway.document.ui.client.component.ace.AceEditor;
import cn.mapway.document.ui.client.component.ace.AceEditorMode;
import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.ObjectInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.rpc.ApiDocProxy;
import cn.mapway.document.ui.client.rpc.IOnData;
import cn.mapway.document.ui.client.test.HeaderEditor;
import cn.mapway.document.ui.client.test.HeaderItem;
import cn.mapway.document.ui.client.test.HistoryData;
import cn.mapway.document.ui.client.test.InputHistoryPanel;
import cn.mapway.document.ui.client.test.KeyValueObj;
import cn.mapway.document.ui.client.test.KeyValueObjs;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;

public class TestPanel
extends Composite
implements HasCloseHandlers<Void> {
    public static final String GWT_USER_HEADER = "gwt_user_token_1";
    private static TestPanelUiBinder uiBinder = (TestPanelUiBinder)GWT.create(TestPanelUiBinder.class);
    private CloseHandler<String> itemDeleted = new CloseHandler<String>(){

        public void onClose(CloseEvent<String> closeEvent) {
            HeaderItem item = (HeaderItem)((Object)closeEvent.getSource());
            TestPanel.this.htmlHeaders.remove((Widget)item);
            TestPanel.this.headers.remove((String)closeEvent.getTarget());
            TestPanel.this.saveHeader();
        }
    };
    @UiField
    HorizontalPanel htmlHeaders;
    KeyValueObjs headers;
    @UiField
    Label lbUrl;
    @UiField
    AceEditor editor;
    @UiField
    AceEditor result;
    Entry mEntry;
    boolean initialize = false;
    @UiField
    Button btnExecute;
    @UiField
    Image imgLoadding;
    @UiField
    Button btnHistory;
    @UiField
    Button btnHeader;
    PopupPanel pop = null;
    InputHistoryPanel historyPanel;
    private CloseHandler<HistoryData> itemSelected = new CloseHandler<HistoryData>(){

        public void onClose(CloseEvent<HistoryData> event) {
            TestPanel.this.editor.setValue(((HistoryData)event.getTarget()).value);
            TestPanel.this.pop.hide();
        }
    };
    HeaderEditor headEditor;
    DialogBox dlg;

    public TestPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        String css = SysResource.INSTANCE.getCss().btn();
        this.btnExecute.setStyleName(css);
        this.btnHistory.setStyleName(css);
        this.btnHeader.setStyleName(css);
        this.imgLoadding.setUrl(SysResource.INSTANCE.loading().getSafeUri());
    }

    private void loadHeader() {
        this.htmlHeaders.clear();
        String key = LocalStorage.val(GWT_USER_HEADER);
        this.headers = KeyValueObjs.parse(key);
        for (int i = 0; i < this.headers.length(); ++i) {
            KeyValueObj kv = (KeyValueObj)this.headers.get(i);
            HeaderItem item = new HeaderItem();
            item.setData(kv.getKey(), kv.getValue());
            item.addCloseHandler(this.itemDeleted);
            this.htmlHeaders.add((Widget)item);
        }
    }

    private void saveHeader() {
        LocalStorage.save(GWT_USER_HEADER, this.headers.toJSON());
    }

    protected void onLoad() {
        super.onLoad();
        this.initJsonEditor();
    }

    private void initJsonEditor() {
        if (!this.initialize) {
            this.editor.startEditor();
            this.editor.setMode(AceEditorMode.JSON);
            this.editor.setShowPrintMargin(false);
            this.editor.setFontSize(16);
            this.result.startEditor();
            this.result.setMode(AceEditorMode.JSON);
            this.result.setShowPrintMargin(false);
            this.result.setFontSize(16);
            this.result.setReadOnly(true);
            this.initialize = true;
        }
    }

    public void invoke(Entry entry) {
        this.loadHeader();
        this.mEntry = entry;
        this.lbUrl.setText(Clients.getHostPort() + entry.url());
        String his = this.readHistory();
        if (his.length() == 0) {
            his = ((ObjectInfo)entry.input().get(0)).json();
        }
        this.editor.setValue(his);
        this.editor.redisplay();
        this.result.setValue("");
    }

    private String readHistory() {
        String r = "";
        String v = LocalStorage.val(this.mEntry.relativePath());
        if (v == null || v.length() == 0) {
            return "";
        }
        String[] vs = v.split("\\|");
        if (vs.length > 0) {
            String[] itemdata = vs[0].split("`");
            r = itemdata[1];
            return r;
        }
        return r;
    }

    @UiHandler(value={"btnExecute"})
    void onExecute(ClickEvent ev) {
        this.imgLoadding.setVisible(true);
        this.result.setValue("");
        String v = LocalStorage.val(this.mEntry.relativePath());
        Date d = new Date();
        String key = d.getYear() + 1900 + "-" + (d.getMonth() + 1) + "-" + d.getDate() + " " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
        String va = this.editor.getValue();
        if (v == null || v.length() == 0) {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + va);
        } else {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + va + "|" + v);
        }
        try {
            ApiDocProxy.fetchString(this.mEntry.url(), va, "", this.mEntry.invokeMethods().get(0), new IOnData<String>(){

                @Override
                public void onError(String url, String error) {
                    TestPanel.this.result.setValue(error);
                    TestPanel.this.imgLoadding.setVisible(false);
                }

                @Override
                public void onSuccess(String url, String data) {
                    GWT.log((String)data);
                    JavaScriptObject obj = JsonUtils.safeEval((String)data);
                    TestPanel.this.result.setValue(JsonUtils.stringify((JavaScriptObject)obj, (String)"\t"));
                    TestPanel.this.imgLoadding.setVisible(false);
                    TestPanel.this.processToken(url, data);
                }
            });
        }
        catch (RequestException e) {
            this.result.setValue(e.getMessage());
            this.imgLoadding.setVisible(false);
        }
    }

    protected void processToken(String url, String data) {
    }

    public HandlerRegistration addCloseHandler(CloseHandler<Void> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    @UiHandler(value={"btnHistory"})
    void onHistory(ClickEvent e) {
        if (this.pop == null) {
            this.pop = new PopupPanel(true, true);
            this.historyPanel = new InputHistoryPanel();
            this.historyPanel.addCloseHandler(this.itemSelected);
            this.pop.add((Widget)this.historyPanel);
        }
        this.pop.showRelativeTo((UIObject)this.btnHistory);
        this.historyPanel.render(this.mEntry.relativePath());
    }

    @UiHandler(value={"btnHeader"})
    public void btnHeaderClick(ClickEvent event) {
        if (this.dlg == null) {
            this.dlg = new DialogBox();
            this.dlg.getElement().getStyle().setZIndex(10000);
            this.headEditor = new HeaderEditor();
            this.dlg.setText("\u7f16\u8f91HTTP\u5934\u90e8\u4fe1\u606f");
            this.dlg.setWidget((Widget)this.headEditor);
            this.headEditor.addCloseHandler(new CloseHandler<KeyValueObjs>(){

                public void onClose(CloseEvent<KeyValueObjs> closeEvent) {
                    TestPanel.this.dlg.hide();
                    TestPanel.this.loadHeader();
                }
            });
        }
        this.dlg.center();
    }

    static interface TestPanelUiBinder
    extends UiBinder<Widget, TestPanel> {
    }
}

