/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.configure;

import cn.mapway.document.configure.ApiDocProperties;
import cn.mapway.document.servlet.MapwayDocServlet;
import java.util.Arrays;
import java.util.HashMap;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(prefix="mapway.apidoc", name={"enabled"}, havingValue="true", matchIfMissing=false)
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
@EnableConfigurationProperties(value={ApiDocProperties.class})
public class DocAutoConfigure {
    @Autowired
    ApiDocProperties properties;

    public DocAutoConfigure() {
        System.out.println("auto configure started");
    }

    @Bean
    ServletRegistrationBean apiDocumentServlet() {
        ServletRegistrationBean srb = new ServletRegistrationBean();
        MapwayDocServlet servlet = new MapwayDocServlet();
        srb.setServlet((Servlet)servlet);
        srb.setUrlMappings(Arrays.asList(this.properties.url));
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("author", this.properties.author);
        params.put("basePath", this.properties.basePath);
        params.put("domain", this.properties.domain);
        params.put("scanPackages", this.properties.scans);
        params.put("subtitle", this.properties.subTitle);
        params.put("title", this.properties.title);
        params.put("copyright", this.properties.copyright);
        params.put("apiVersion", this.properties.version);
        params.put("logoBase64", this.properties.logo);
        params.put("homeUrl", this.properties.home);
        params.put("cssStyle", this.properties.style);
        srb.setInitParameters(params);
        srb.setLoadOnStartup(1);
        return srb;
    }
}

