/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.module.ApiDoc;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.Group;
import cn.mapway.document.ui.client.resource.CssStyle;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.resource.TreeResource;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.OpenEvent;
import com.google.gwt.event.logical.shared.OpenHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Tree;
import com.google.gwt.user.client.ui.TreeItem;
import com.google.gwt.user.client.ui.Widget;

public class ApiTree
extends Tree {
    CssStyle css;
    private OpenHandler<TreeItem> openHandler = new OpenHandler<TreeItem>(){

        public void onOpen(OpenEvent<TreeItem> event) {
            Group g = (Group)((Object)((TreeItem)event.getTarget()).getUserObject());
            ApiTree.this.setOpen(g.fullName(), true);
        }
    };
    private CloseHandler<TreeItem> closeHandler = new CloseHandler<TreeItem>(){

        public void onClose(CloseEvent<TreeItem> event) {
            Group g = (Group)((Object)((TreeItem)event.getTarget()).getUserObject());
            ApiTree.this.setOpen(g.fullName(), false);
        }
    };

    public ApiTree() {
        super((Tree.Resources)new TreeResource(), false);
        this.css = SysResource.INSTANCE.getCss();
        this.addOpenHandler(this.openHandler);
        this.addCloseHandler(this.closeHandler);
    }

    public boolean isOpen(String key) {
        String data = LocalStorage.val(key);
        return "1".equals(data);
    }

    public void setOpen(String key, boolean open) {
        LocalStorage.save(key, open ? "1" : "0");
    }

    public void parseData(ApiDoc data) {
        this.clear();
        Group group = data.root();
        this.parseGroup(null, group);
    }

    private void parseGroup(TreeItem root, Group group) {
        JsArray<Group> subs = group.subGroups();
        for (int i = 0; i < subs.length(); ++i) {
            Group g = (Group)subs.get(i);
            TreeItem item = new TreeItem();
            Label lb = new Label(g.name());
            lb.setStyleName(this.css.group());
            item.setUserObject((Object)g);
            item.setWidget((Widget)lb);
            if (root == null) {
                this.addItem(item);
            } else {
                root.addItem(item);
            }
            this.parseGroup(item, g);
        }
        JsArray<Entry> entries = group.entries();
        for (int i = 0; i < entries.length(); ++i) {
            Entry e = (Entry)entries.get(i);
            TreeItem item = new TreeItem();
            String tags = ApiTree.buildTags(e.tags());
            String html = "<div >" + (i + 1) + "." + tags + e.title() + "</div>";
            HTML widget = new HTML(html);
            item.setWidget((Widget)widget);
            item.setUserObject((Object)e);
            item.setTitle("\u5b9e\u73b0\u7c7b:" + e.parentClassName() + "\r\n\u65b9\u6cd5" + e.methodName());
            if (root == null) {
                this.addItem(item);
                continue;
            }
            root.addItem(item);
        }
        if (root != null) {
            root.setState(this.isOpen(group.fullName()));
        }
    }

    public static String buildTags(String[] tags) {
        if (tags == null) {
            return "";
        }
        String html = "";
        String style = SysResource.INSTANCE.getCss().tag();
        for (String tag : tags) {
            String[] kv = tag.split("/");
            if (kv.length == 2) {
                style = kv[1];
                tag = kv[0];
            }
            html = html + "<span class='" + style + "'>" + tag + "</span>";
        }
        return html;
    }

    private String findApiStyle(Entry e) {
        if (e.style().equalsIgnoreCase("IMPORTANT")) {
            return this.css.entryImportent();
        }
        return this.css.entry();
    }
}

