/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.component.CustomAnchor;
import cn.mapway.document.ui.client.main.FieldCode;
import cn.mapway.document.ui.client.main.ObjectInfoPanel;
import cn.mapway.document.ui.client.module.ObjectInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class ObjectsInfoPanel
extends Grid
implements HasSelectionHandlers<ObjectInfo>,
ClickHandler {
    private Label lbTitle;
    private HTML lbSummary;
    private static String[] ps = new String[]{"int", "Integer", "float", "FLoat", "Double", "double", "long", "Long", "Date", "DateTime", "String", "boolean", "Boolean", "char", "short", "byte", "Timestamp"};

    public void onClick(ClickEvent arg0) {
        CustomAnchor anchor = (CustomAnchor)((Object)arg0.getSource());
        ObjectInfo info = (ObjectInfo)((Object)anchor.getData());
        SelectionEvent.fire((HasSelectionHandlers)this, (Object)((Object)info));
    }

    public ObjectsInfoPanel() {
        this.init();
        this.setStyleName(SysResource.INSTANCE.getCss().cssTable());
    }

    void init() {
        Element e = this.getElement();
        e.setAttribute("borderCollapse", "collapse");
        e.setAttribute("cellPadding", "10px");
        e.setAttribute("cellSpacing", "1px");
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        this.lbTitle = new Label();
        this.lbTitle.setStyleName(SysResource.INSTANCE.getCss().title());
        this.lbSummary = new HTML();
        this.lbSummary.setStyleName(SysResource.INSTANCE.getCss().summary());
        HTMLPanel vp = new HTMLPanel("");
        vp.add((Widget)this.lbTitle);
        vp.add((Widget)this.lbSummary);
        this.resize(2, 6);
        int row = 0;
        rf.setStyleName(row, SysResource.INSTANCE.getCss().rowTitle());
        this.setWidget(row, 0, (Widget)vp);
        this.getCellFormatter().getElement(0, 0).setAttribute("colspan", "6");
        this.removeCell(0, 1);
        this.removeCell(0, 1);
        this.removeCell(0, 1);
        this.removeCell(0, 1);
        this.removeCell(0, 1);
        int col = 0;
        Label l = new Label("\u540d\u79f0");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(++row, col++, (Widget)l);
        l = new Label("\u7c7b\u578b");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u4e3e\u4f8b");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u957f\u5ea6");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u9009\u9879");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        l = new Label("\u89e3\u91ca");
        l.setStyleName(SysResource.INSTANCE.getCss().tableHeader());
        this.setWidget(row, col++, (Widget)l);
        rf.setStylePrimaryName(row, SysResource.INSTANCE.getCss().rowh());
        HTMLTable.CellFormatter cf = this.getCellFormatter();
        cf.setWidth(row, 0, "200px");
        cf.setWidth(row, 1, "200px");
        cf.setWidth(row, 2, "80px");
        cf.setWidth(row, 3, "80px");
        cf.setWidth(row, 4, "100px");
    }

    public void parse(JsArray<ObjectInfo> objs, String title, String html) {
        this.lbTitle.setText(title);
        this.lbSummary.setHTML(html);
        this.resizeRows(objs.length() + 2);
        HTMLTable.RowFormatter rf = this.getRowFormatter();
        int row = 2;
        for (int i = 0; i < objs.length(); ++i) {
            ObjectInfo o = (ObjectInfo)objs.get(i);
            int col = 0;
            if (row % 2 == 0) {
                rf.setStyleName(row, SysResource.INSTANCE.getCss().row0());
            } else {
                rf.setStyleName(row, SysResource.INSTANCE.getCss().row1());
            }
            Label l = new Label(o.name());
            l.setStyleName(SysResource.INSTANCE.getCss().name());
            this.setWidget(row, col++, (Widget)l);
            String type = o.type();
            if (this.isPrimitive(type)) {
                l = new Label(o.type());
                l.setStyleName(SysResource.INSTANCE.getCss().type());
                this.setWidget(row, col++, (Widget)l);
            } else {
                CustomAnchor a = new CustomAnchor();
                a.setText(ObjectInfoPanel.simple(type));
                a.setData((Object)o);
                a.setStyleName(SysResource.INSTANCE.getCss().typeLink());
                a.addClickHandler(this);
                this.setWidget(row, col++, (Widget)a);
            }
            l = new Label(o.example());
            l.setStyleName(SysResource.INSTANCE.getCss().text());
            this.setWidget(row, col++, (Widget)l);
            l = ObjectInfoPanel.handleLengthConstrain(o);
            l.setStyleName(SysResource.INSTANCE.getCss().text());
            this.setWidget(row, col++, (Widget)l);
            l = new Label(o.manditary() ? "\u5fc5\u987b" : "\u53ef\u9009");
            l.setStyleName(SysResource.INSTANCE.getCss().text());
            this.setWidget(row, col++, (Widget)l);
            FlowPanel fp = new FlowPanel();
            l = new Label(o.title());
            l.setStyleName(SysResource.INSTANCE.getCss().summary());
            fp.add((Widget)l);
            this.setWidget(row, col++, (Widget)fp);
            JsArray<FieldCode> codes = o.codes();
            if (codes != null && codes.length() > 0) {
                FlexTable g = new FlexTable();
                Element ele = g.getElement();
                ele.setAttribute("borderCollapse", "collapse");
                ele.setAttribute("rules", "rows");
                ele.setAttribute("border", "1px");
                ele.setAttribute("cellPadding", "3px");
                g.setWidget(0, 0, (Widget)new Label("\u4ee3\u7801"));
                g.setWidget(0, 1, (Widget)new Label("\u8bf4\u660e"));
                HTMLTable.CellFormatter cf = g.getCellFormatter();
                cf.setAlignment(0, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
                for (int index = 0; index < codes.length(); ++index) {
                    FieldCode fc = (FieldCode)codes.get(index);
                    l = new Label(fc.value());
                    l.setStyleName(SysResource.INSTANCE.getCss().type());
                    g.setWidget(index + 1, 0, (Widget)l);
                    cf.setAlignment(index + 1, 0, HasHorizontalAlignment.ALIGN_RIGHT, HasVerticalAlignment.ALIGN_MIDDLE);
                    l = new Label(fc.desc());
                    l.setStyleName(SysResource.INSTANCE.getCss().summary());
                    g.setWidget(index + 1, 1, (Widget)l);
                }
                fp.add((Widget)g);
            }
            ++row;
        }
    }

    private boolean isPrimitive(String type) {
        for (String s : ps) {
            if (!type.contains(s)) continue;
            return true;
        }
        return false;
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<ObjectInfo> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }
}

