/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import cn.mapway.document.helper.JavaClassContent;
import cn.mapway.document.helper.Scans;
import cn.mapway.document.helper.StrUtil;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.module.Entry;
import cn.mapway.document.module.Group;
import cn.mapway.document.module.ObjectInfo;
import cn.mapway.document.resource.Template;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.lang.Strings;

public class GwtConnextorExport {
    Map<String, ObjectInfo> modules;
    HashMap<String, Integer> entries = new HashMap();
    private static String[] ps = new String[]{"int", "Integer", "float", "Float", "Double", "double", "long", "Long", "Date", "DateTime", "String", "boolean", "Boolean", "char", "short", "byte", "Timestamp", "Map"};

    public GwtConnextorExport() {
        this.modules = new HashMap<String, ObjectInfo>();
    }

    public List<JavaClassContent> export2(ApiDoc api, String packageName, String className) {
        this.entries = new HashMap();
        ArrayList<JavaClassContent> clazzs = new ArrayList<JavaClassContent>();
        StringBuilder imports = new StringBuilder();
        imports.append("import " + packageName + ".module.*;\r\n");
        StringBuilder sb = new StringBuilder();
        this.modules = new HashMap<String, ObjectInfo>();
        Group root = api.root;
        this.recurse(sb, root, this.modules);
        String template = Scans.readResource("cn.mapway.document.resource", "gwtconnect.txt");
        this.processModuleMody(packageName, this.modules, clazzs);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("package", packageName);
        map.put("name", className);
        map.put("basepath", "");
        map.put("importModules", imports.toString());
        map.put("apis", sb.toString());
        map.put("modules", "");
        JavaClassContent jcc = new JavaClassContent();
        jcc.body = this.replace(template, map);
        jcc.className = className;
        jcc.packageName = packageName;
        clazzs.add(jcc);
        return clazzs;
    }

    private void processModuleMody(String packageName, Map<String, ObjectInfo> ms, ArrayList<JavaClassContent> clazzs) {
        for (String key : ms.keySet()) {
            ObjectInfo oi = ms.get(key);
            StringBuilder sb = new StringBuilder();
            sb.append("package " + packageName + ".module;\r\n\r\n");
            sb.append("import com.google.gwt.core.client.*;\r\n");
            sb.append("\r\n/**\r\n");
            sb.append("  (" + oi.title + ").\r\n");
            sb.append("  " + oi.summary + "\r\n");
            sb.append("  */\r\n");
            sb.append("public  class " + this.getType(this.unwrapType(oi.type)) + " extends JavaScriptObject {\r\n");
            sb.append("  protected " + this.getType(this.unwrapType(oi.type)) + "(){}\r\n");
            sb.append("  public final static native " + this.getType(this.unwrapType(oi.type)) + " create()/*-{\r\n        return {};\r\n  }-*/;\r\n");
            for (ObjectInfo fi : oi.fields) {
                sb.append("  /**\r\n  * \u83b7\u53d6" + fi.title + " " + fi.summary + ".\r\n   */\r\n");
                sb.append("  public final  native " + this.getType(fi.type) + " get" + Strings.upperFirst((CharSequence)fi.name) + "() /*-{\r\n        return this." + fi.name + ";\r\n  }-*/;\r\n");
                sb.append("  /**\r\n  " + fi.title + "\r\n " + fi.summary + "\r\n */\r\n");
                sb.append("  public final  native void set" + Strings.upperFirst((CharSequence)fi.name) + "(" + this.getType(fi.type) + " v) /*-{\r\n        this." + fi.name + " = v;\r\n  }-*/;\r\n");
            }
            sb.append(" /**\r\n   * \u5bf9\u8c61\u5b57\u7b26\u4e32\r\n   */\r\n  public final String toJson() {\r\n    return JsonUtils.stringify(this);\r\n  }");
            sb.append("}\r\n");
            JavaClassContent jcc = new JavaClassContent();
            jcc.body = sb.toString();
            jcc.className = this.getType(this.unwrapType(oi.type));
            jcc.packageName = packageName + ".module";
            clazzs.add(jcc);
        }
    }

    public String export(ApiDoc api, String packageName, String className) {
        String template;
        this.entries = new HashMap();
        StringBuilder imports = new StringBuilder();
        StringBuilder sb = new StringBuilder();
        StringBuilder modulesBody = new StringBuilder();
        this.modules = new HashMap<String, ObjectInfo>();
        Group root = api.root;
        this.recurse(sb, root, this.modules);
        try {
            template = Template.readTemplate("/main/java/mapway/document/resource/gwtconnect.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        this.processModuleMody(this.modules, modulesBody);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("package", packageName);
        map.put("name", className);
        map.put("basepath", "");
        map.put("importModules", imports.toString());
        map.put("apis", sb.toString());
        map.put("modules", modulesBody.toString());
        return this.replace(template, map);
    }

    public String replace(String str, Map<String, String> data) {
        try {
            return StrUtil.composeMessage(str, data);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private void processModuleMody(Map<String, ObjectInfo> ms, StringBuilder modulesBody) {
        for (String key : ms.keySet()) {
            ObjectInfo oi = ms.get(key);
            modulesBody.append("\r\n/**");
            modulesBody.append("  " + oi.title + "\r\n");
            modulesBody.append("  " + oi.summary);
            modulesBody.append("*/\r\n");
            modulesBody.append("public static class " + this.getType(this.unwrapType(oi.type)) + " extends JavaScriptObject{\r\n");
            modulesBody.append("protected " + this.getType(this.unwrapType(oi.type)) + "(){}\r\n");
            modulesBody.append("public final static native " + this.getType(this.unwrapType(oi.type)) + " create()/*-{return {}}-*/;\r\n");
            for (ObjectInfo fi : oi.fields) {
                modulesBody.append("/**\r\n  \u83b7\u53d6" + fi.title + "\r\n " + fi.summary + "\r\n */\r\n");
                modulesBody.append(" public final  native " + this.getType(fi.type) + " " + fi.name + "() /*-{\r\nreturn this." + fi.name + ";}-*/;\r\n");
                modulesBody.append("/**\r\n  " + fi.title + "\r\n " + fi.summary + "\r\n */\r\n");
                modulesBody.append(" public final  native void " + fi.name + "(" + this.getType(fi.type) + " v) /*-{\r\nthis." + fi.name + "=v;}-*/;\r\n");
            }
            modulesBody.append("}\r\n");
        }
    }

    private String getType(String type) {
        if (type.startsWith("List")) {
            String subtype = type.substring(5, type.length() - 1);
            if (subtype.equals("java.lang.String")) {
                return "JsArrayString";
            }
            if (subtype.equals("java.lang.Boolean") || subtype.equals("bool")) {
                return "JsArrayBoolean";
            }
            if (subtype.equals("int") || subtype.equals("java.lang.Integer") || subtype.equals("java.lang.Long") || subtype.equals("long") || subtype.equals("java.lang.Byte") || subtype.equals("byte") || subtype.equals("java.lang.Short") || subtype.equals("short")) {
                return "JsArrayInteger";
            }
            if (subtype.equals("double") || subtype.equals("java.lang.Double") || subtype.equals("float") || subtype.equals("java.lang.Float")) {
                return "JsArrayNumber";
            }
            if (subtype.equals("java.util.Map")) {
                return "JsArray";
            }
            return "JsArray<" + this.getType(subtype) + ">";
        }
        String t = type;
        int index = type.lastIndexOf(".");
        if (index > 0) {
            return type.substring(index + 1);
        }
        return this.changeTypeFromObject2Native(t);
    }

    private String changeTypeFromObject2Native(String type) {
        if ("Integer".equals(type)) {
            return "int";
        }
        if ("Double".equals(type)) {
            return "double";
        }
        if ("Boolean".equals(type)) {
            return "boolean";
        }
        if ("Char".equals(type)) {
            return "char";
        }
        if ("Short".equals(type)) {
            return "int";
        }
        if ("Long".equals(type)) {
            return "int";
        }
        if ("long".equals(type)) {
            return "int";
        }
        if ("Float".equals(type)) {
            return "double";
        }
        if ("float".equals(type)) {
            return "double";
        }
        return type;
    }

    private void recurse(StringBuilder sb, Group root, Map<String, ObjectInfo> modules2) {
        for (Entry e : root.entries) {
            this.processEntry(e, sb, modules2);
        }
        for (Group g : root.subGroups) {
            this.recurse(sb, g, modules2);
        }
    }

    private void processEntry(Entry e, StringBuilder sb, Map<String, ObjectInfo> modules2) {
        for (ObjectInfo info : e.input) {
            this.processModule(info, modules2);
        }
        this.processModule(e.output, modules2);
        this.processEntryBodyAsync(e, sb);
    }

    private void processEntryBodyAsync(Entry e, StringBuilder sb) {
        if (e.input.size() == 0) {
            return;
        }
        int count = 0;
        if (this.entries.containsKey(e.methodName)) {
            count = this.entries.get(e.methodName);
            this.entries.put(e.methodName, ++count);
        } else {
            count = 0;
            this.entries.put(e.methodName, 0);
        }
        sb.append("/**\r\n");
        sb.append("  *" + e.title + "\r\n");
        sb.append("  *" + Strings.sBlank((Object)e.summary) + "\r\n");
        sb.append("*/\r\n");
        sb.append("public void " + e.methodName + (count == 0 ? "" : "" + count) + "(final " + this.getType(this.unwrapType(e.input.get((int)0).type)) + " req ,final ICallback<" + this.getType(this.unwrapType(e.output.type)) + "> handler) throws Exception{\r\n");
        sb.append("\tif (handler == null) {\r\n");
        sb.append("\treturn;\r\n}\r\n");
        String type = this.getType(this.unwrapType(e.output.type));
        String invokeMethod = e.invokeMethods.get(0);
        if (invokeMethod.compareToIgnoreCase("post") == 0) {
            if (type.equals("String")) {
                sb.append("doPostString(\"" + e.relativePath + "\", JsonUtils.stringify(req), handler);");
            } else {
                sb.append("    doPost(\"" + e.relativePath + "\", JsonUtils.stringify(req), handler);");
            }
        } else if (type.equals("String")) {
            sb.append("    doGetString(\"" + e.relativePath + "\", JsonUtils.stringify(req), handler);");
        } else {
            sb.append("    doGet(\"" + e.relativePath + "\", JsonUtils.stringify(req), handler);");
        }
        sb.append("\t\r\n");
        sb.append("}\r\n");
    }

    String unwrapType(String t) {
        if (t.startsWith("List")) {
            return t.substring(5, t.length() - 1);
        }
        return t;
    }

    private void processModule(ObjectInfo info, Map<String, ObjectInfo> modules2) {
        String t = this.unwrapType(info.type);
        if (this.isPrimitive(t)) {
            return;
        }
        if (!modules2.containsKey(t)) {
            this.checkDoubleName(modules2, info);
            modules2.put(t, info);
        }
        for (ObjectInfo oi : info.fields) {
            this.processModule(oi, modules2);
        }
    }

    private void checkDoubleName(Map<String, ObjectInfo> modules2, ObjectInfo info) {
        String t = this.getType(this.unwrapType(info.type));
        for (String key : modules2.keySet()) {
            String t1 = this.getType(this.unwrapType(key));
            if (!t.equals(t1)) continue;
            info.type = info.type.replaceAll("\\.", "");
            break;
        }
    }

    private boolean isPrimitive(String type) {
        for (String s : ps) {
            if (!type.contains(s)) continue;
            return true;
        }
        return false;
    }
}

