/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import java.util.Arrays;
import java.util.List;
import org.commonmark.Extension;
import org.commonmark.ext.gfm.tables.TablesExtension;
import org.commonmark.node.Node;
import org.commonmark.parser.Parser;
import org.commonmark.renderer.html.HtmlRenderer;

public class Markdowns {
    private static Markdowns INSTANCE;
    private Parser parser;
    private HtmlRenderer renderer;
    private List<Extension> extensions;

    protected Markdowns() {
    }

    public static final Markdowns get() {
        if (INSTANCE == null) {
            INSTANCE = new Markdowns();
        }
        return INSTANCE;
    }

    public synchronized Parser getParser() {
        if (this.parser == null) {
            this.parser = Parser.builder().extensions(this.getExtensions()).build();
        }
        return this.parser;
    }

    public final synchronized HtmlRenderer getHtmlRender() {
        if (this.renderer == null) {
            this.renderer = HtmlRenderer.builder().extensions(this.getExtensions()).build();
        }
        return this.renderer;
    }

    public final synchronized List<Extension> getExtensions() {
        if (this.extensions == null) {
            this.extensions = Arrays.asList(TablesExtension.create());
        }
        return this.extensions;
    }

    public String translate(String desc) {
        Node node = this.getParser().parse(desc);
        String html = this.getHtmlRender().render(node);
        return html;
    }
}

