/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.component.ace;

import cn.mapway.document.ui.client.component.ace.AceEditorCursorPosition;
import cn.mapway.document.ui.client.component.ace.AceSelectionListener;
import com.google.gwt.core.client.JavaScriptObject;
import java.util.ArrayList;
import java.util.List;

public class AceSelection {
    private final JavaScriptObject selection;
    private final AceSelectionListener rootListener;
    private final List<AceSelectionListener> subListeners = new ArrayList<AceSelectionListener>();

    public AceSelection(JavaScriptObject selection) {
        this.selection = selection;
        this.rootListener = new AceSelectionListener(){

            @Override
            public void onChangeSelection(AceSelection ignore) {
                for (AceSelectionListener lst : AceSelection.this.subListeners) {
                    lst.onChangeSelection(AceSelection.this);
                }
            }
        };
        AceSelection.registerRootListener(selection, this.rootListener);
    }

    private static native void registerRootListener(JavaScriptObject var0, AceSelectionListener var1);

    public void addSelectionListener(AceSelectionListener listener) {
        this.subListeners.add(listener);
    }

    public void removeSelectionListener(AceSelectionListener listener) {
        this.subListeners.remove(listener);
    }

    public native boolean isEmpty();

    public native boolean isMultiLine();

    private AceEditorCursorPosition getCursorPositionImpl(double row, double column) {
        return new AceEditorCursorPosition((int)row, (int)column);
    }

    public native AceEditorCursorPosition getSelectionLead();

    public native AceEditorCursorPosition getSelectionAnchor();

    public native boolean isBackwards();

    public native void clearSelection();

    public native void selectAll();

    public native void select(int var1, int var2, int var3, int var4);

    public native void selectLine();
}

