/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.main.EntryList;
import cn.mapway.document.ui.client.module.Group;
import cn.mapway.document.ui.client.resource.SysResource;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;

public class EntryListPanel
extends Composite {
    private static EntryListPanelUiBinder uiBinder = (EntryListPanelUiBinder)GWT.create(EntryListPanelUiBinder.class);
    @UiField
    Label lbTitle;
    @UiField
    EntryList list;
    @UiField
    Button btnSearch;
    Group mGroup;
    String searchText;
    @UiField
    HTML html;
    @UiField
    VerticalPanel entries;
    @UiField
    TextBox txtSEARCH;

    public EntryListPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.btnSearch.setStyleName(SysResource.INSTANCE.getCss().btn());
        this.txtSEARCH.addKeyUpHandler(new KeyUpHandler(){

            public void onKeyUp(KeyUpEvent event) {
                EntryListPanel.this.search();
            }
        });
        this.txtSEARCH.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                if (EntryListPanel.this.txtSEARCH.getValue() != null && EntryListPanel.this.txtSEARCH.getValue().length() > 0) {
                    EntryListPanel.this.txtSEARCH.setSelectionRange(0, EntryListPanel.this.txtSEARCH.getValue().length());
                }
            }
        });
    }

    public void parse(Group group, String searchText) {
        if (group == null) {
            return;
        }
        this.searchText = searchText;
        this.txtSEARCH.setValue((Object)searchText);
        this.mGroup = group;
        this.lbTitle.setText(group.name() == null ? "\u6240\u6709\u63a5\u53e3" : group.fullName());
        int count = this.list.findCount(group, "");
        String h = this.list.parse(group, searchText);
        if (count == 0) {
            this.entries.setVisible(false);
        } else {
            this.entries.setVisible(true);
        }
        this.html.setHTML(h);
    }

    @UiHandler(value={"btnSearch"})
    void onSearch(ClickEvent e) {
        this.search();
    }

    private void search() {
        String key = this.txtSEARCH.getValue();
        if (key == null || key.length() == 0) {
            this.parse(this.mGroup, "");
        }
        this.parse(this.mGroup, key);
    }

    static interface EntryListPanelUiBinder
    extends UiBinder<Widget, EntryListPanel> {
    }
}

