/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.helper;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.nutz.lang.Files;
import org.nutz.lang.Streams;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Scans {
    private static Log log = Logs.getLog(Scans.class);

    public static byte[] readBinResource(String packageName, String resName) {
        String src = packageName.replace('.', '/');
        if (src.length() > 0) {
            src = src + "/";
        }
        src = src + resName;
        String pacakgeName = "";
        String fileName = "";
        if (src.length() > 0) {
            int pos = src.lastIndexOf(47);
            if (pos > 0) {
                pacakgeName = src.substring(0, pos);
                fileName = src.substring(pos + 1);
            } else {
                pacakgeName = "";
                resName = src;
            }
            try {
                byte[] bytes = Scans.innerReadResource(pacakgeName, fileName);
                return bytes;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return new byte[0];
        }
        return new byte[0];
    }

    public static String readResource(String packageName, String resName) {
        String src = packageName.replace('.', '/');
        if (src.length() > 0) {
            src = src + "/";
        }
        src = src + resName;
        String pacakgeName = "";
        String fileName = "";
        if (src.length() > 0) {
            int pos = src.lastIndexOf(47);
            if (pos > 0) {
                pacakgeName = src.substring(0, pos);
                fileName = src.substring(pos + 1);
            } else {
                pacakgeName = "";
                resName = src;
            }
            try {
                byte[] bytes = Scans.innerReadResource(pacakgeName, fileName);
                String data = new String(bytes, "UTF-8");
                data = data.replaceAll("\\$\\{PACKAGE\\}", pacakgeName);
                return data;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            return "";
        }
        return "";
    }

    private static byte[] innerReadResource(String packageName, String fileName) throws IOException {
        System.out.println(packageName + "," + fileName);
        URL url = Scans.class.getClassLoader().getResource(packageName);
        if (url == null) {
            System.out.println("sorry cannot find resource :" + packageName + "/" + fileName);
            return "".getBytes();
        }
        String protocol = url.getProtocol();
        if ("file".equals(protocol)) {
            String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
            filePath = filePath + File.separator + fileName;
            return Files.readBytes((String)filePath);
        }
        if ("jar".equals(protocol)) {
            JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(fileName)) continue;
                InputStream input = jar.getInputStream(entry);
                return Streams.readBytesAndClose((InputStream)input);
            }
        }
        return new byte[0];
    }

    public static Set<Class<?>> getClasses(String pack) {
        LinkedHashSet classes = new LinkedHashSet();
        boolean recursive = true;
        String packageName = pack;
        String packageDirName = packageName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(packageDirName);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    Scans.findAndAddClassesInPackageByFile(packageName, filePath, recursive, classes);
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                try {
                    JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                    Enumeration<JarEntry> entries = jar.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        String name = entry.getName();
                        if (name.charAt(0) == '/') {
                            name = name.substring(1);
                        }
                        if (!name.startsWith(packageDirName)) continue;
                        int idx = name.lastIndexOf(47);
                        if (idx != -1) {
                            packageName = name.substring(0, idx).replace('/', '.');
                        }
                        if (idx == -1 && !recursive || !name.endsWith(".class") || entry.isDirectory()) continue;
                        String className = name.substring(packageName.length() + 1, name.length() - 6);
                        try {
                            classes.add(Class.forName(packageName + '.' + className));
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return classes;
    }

    public static void findAndAddClassesInPackageByFile(String packageName, String packagePath, final boolean recursive, Set<Class<?>> classes) {
        File[] dirfiles;
        File dir = new File(packagePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        for (File file : dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return recursive && file.isDirectory() || file.getName().endsWith(".class");
            }
        })) {
            if (file.isDirectory()) {
                Scans.findAndAddClassesInPackageByFile(packageName + "." + file.getName(), file.getAbsolutePath(), recursive, classes);
                continue;
            }
            String className = file.getName().substring(0, file.getName().length() - 6);
            try {
                classes.add(Thread.currentThread().getContextClassLoader().loadClass(packageName + '.' + className));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

