/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.parser;

import cn.mapway.document.annotation.ApiField;
import cn.mapway.document.annotation.ApiStyle;
import cn.mapway.document.annotation.Code;
import cn.mapway.document.annotation.Codes;
import cn.mapway.document.annotation.DevelopmentState;
import cn.mapway.document.annotation.Doc;
import cn.mapway.document.annotation.RuntimeType;
import cn.mapway.document.helper.Markdowns;
import cn.mapway.document.helper.Scans;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.module.Entry;
import cn.mapway.document.module.FieldCode;
import cn.mapway.document.module.Group;
import cn.mapway.document.module.ObjectInfo;
import cn.mapway.document.parser.Deeps;
import cn.mapway.document.parser.GenContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.nutz.castor.Castors;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import sun.reflect.generics.reflectiveObjects.TypeVariableImpl;

public class SpringParser {
    private static final Log log = Logs.getLog(SpringParser.class);
    GenContext mContext;
    Deeps deeps;

    /*
     * WARNING - void declaration
     */
    public ApiDoc parse(GenContext context, String ... packageNames) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        void var6_8;
        this.mContext = context;
        if (packageNames.length == 0) {
            return new ApiDoc();
        }
        ArrayList clzs = new ArrayList();
        String[] stringArray = packageNames;
        int n = stringArray.length;
        boolean bl = false;
        while (var6_8 < n) {
            String pk = stringArray[var6_8];
            Set<Class<?>> clz = this.scanPackage(pk);
            clzs.addAll(clz);
            ++var6_8;
        }
        ApiDoc doc = new ApiDoc();
        doc.author = context.getAuthor();
        doc.basePath = context.getBasepath();
        doc.title = context.getDocTitle();
        doc.wordUrl = context.getWordURL();
        doc.summary = context.getSubtitle();
        doc.domain = context.getDomain();
        doc.copyright = context.getCopyright();
        doc.apiVersion = context.getApiVersion();
        doc.logo = context.getLogobase64();
        doc.homeUrl = context.getHomeUrl();
        doc.cssStyle = context.getCssStyle();
        if (Strings.isEmpty((CharSequence)doc.apiVersion)) {
            doc.apiVersion = "1.0";
        }
        doc.copyright = doc.copyright + "-" + "[2.3.0]@2020\u5e7410\u670812\u65e5 15:20:44";
        for (Class clazz : clzs) {
            if (clazz.getAnnotation(Controller.class) == null && clazz.getAnnotation(RestController.class) == null) continue;
            this.parseClass(doc, clazz);
        }
        doc.root.name = doc.title;
        doc.root.fullName = "/" + doc.title;
        doc.root.summary = "";
        doc.sort();
        return doc;
    }

    private Set<Class<?>> scanPackage(String pk) {
        Set<Class<?>> clzs = Scans.getClasses(pk);
        return clzs;
    }

    private void parseClass(ApiDoc document, Class<?> clz) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Doc doc = clz.getAnnotation(Doc.class);
        if (doc == null) {
            return;
        }
        this.populateGroup(document, clz);
    }

    private void populateGroup(ApiDoc document, Class<?> c) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Method m;
        int i;
        String[] paths;
        Doc doc = c.getAnnotation(Doc.class);
        String group_base_path = doc.group();
        Group apigroup = document.findGroup(group_base_path);
        apigroup.summary = apigroup.summary + (doc.desc().length() > 0 ? doc.desc() : "");
        apigroup.summary = apigroup.summary + this.parseRef(c, doc.refs());
        apigroup.order = doc.order();
        String basepath = "";
        RequestMapping rm = c.getAnnotation(RequestMapping.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            basepath = paths[0];
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            RequestMapping rm1 = m.getAnnotation(RequestMapping.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        for (i = 0; i < list.size(); ++i) {
            m = (Method)list.get(i);
            Entry entry = this.handleMethod(c, document, group_base_path, m);
            if (entry == null) continue;
            entry.parentClassName = c.getName();
            entry.relativePath = basepath + entry.relativePath;
            entry.url = this.mContext.getBasepath() + entry.relativePath;
        }
    }

    private Entry handleMethod(Class<?> clsType, ApiDoc document, String group_base_path, Method m) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        Doc summary = m.getAnnotation(Doc.class);
        if (null == summary) {
            return null;
        }
        Entry e = new Entry();
        RequestMapping rm = m.getAnnotation(RequestMapping.class);
        if (rm != null) {
            RequestMethod[] requestMethodArray;
            String[] paths = rm.value();
            if (paths != null && paths.length != 0) {
                e.relativePath = paths[0];
            }
            if ((requestMethodArray = rm.method()) != null) {
                for (int i = 0; i < requestMethodArray.length; ++i) {
                    RequestMethod rm0 = requestMethodArray[i];
                    e.invokeMethods.add(rm0.name());
                }
            }
        }
        if (e.invokeMethods.size() == 0) {
            e.invokeMethods.add("GET");
        }
        if (e.relativePath.length() == 0) {
            return null;
        }
        e.methodName = m.getName();
        Class retClz = null;
        if (summary != null) {
            e.title = summary.value();
            e.summary = summary.desc() == null ? "" : summary.desc();
            e.summary = e.summary + this.parseRef(clsType, summary.refs());
            e.order = summary.order();
            e.author = summary.author();
            e.state = this.transState(summary.state());
            e.apiStyle = this.transApiStyle(summary.style());
            if (summary.tags() != null) {
                for (String string : summary.tags()) {
                    e.tags.add(string);
                }
            }
            if (summary.retClazz() != null && summary.retClazz().length > 0) {
                retClz = summary.retClazz()[0];
            }
        }
        Class<?>[] classArray = m.getParameterTypes();
        Class<?> out = m.getReturnType();
        if (retClz != null) {
            out = retClz;
        }
        int i = 0;
        for (Class<?> clz : classArray) {
            String name = clz.getSimpleName();
            String pname = "";
            if (clz.getPackage() != null) {
                pname = clz.getPackage().getName();
            }
            if (name.startsWith("Http") || pname.startsWith("org.")) continue;
            Annotation[][] parameterAnnotations = m.getParameterAnnotations();
            Annotation[] ass = parameterAnnotations[i];
            PathVariable pathVariable = null;
            RequestParam queryVariable = null;
            RequestBody isRequestBody = null;
            ApiField paraDoc = null;
            Size stringConstrain = null;
            NotNull nullConstrain = null;
            Min minConstrain = null;
            Max maxConstrain = null;
            for (Annotation a : ass) {
                if (a instanceof PathVariable) {
                    pathVariable = (PathVariable)a;
                    continue;
                }
                if (a instanceof RequestParam) {
                    queryVariable = (RequestParam)a;
                    continue;
                }
                if (a instanceof ApiField) {
                    paraDoc = (ApiField)a;
                    continue;
                }
                if (a instanceof RequestBody) {
                    isRequestBody = (RequestBody)a;
                    continue;
                }
                if (a instanceof Size) {
                    stringConstrain = (Size)a;
                    continue;
                }
                if (a instanceof NotNull) {
                    nullConstrain = (NotNull)a;
                    continue;
                }
                if (a instanceof Min) {
                    minConstrain = (Min)a;
                    continue;
                }
                if (!(a instanceof Max)) continue;
                maxConstrain = (Max)a;
            }
            ObjectInfo p = this.handleParameter(clz, name);
            if (p == null) continue;
            if (paraDoc != null) {
                p.example = paraDoc.example();
                p.manditary = paraDoc.mandidate();
                p.title = paraDoc.value();
                p.summary = this.parseRef(clsType, paraDoc.refs());
            }
            if (stringConstrain != null) {
                p.minLength = stringConstrain.min();
                p.maxLength = stringConstrain.max();
            }
            if (minConstrain != null) {
                p.min = minConstrain.value();
            }
            if (maxConstrain != null) {
                p.max = maxConstrain.value();
            }
            if (nullConstrain != null) {
                p.manditary = true;
            }
            if (pathVariable != null) {
                p.name = Strings.isBlank((CharSequence)pathVariable.value()) ? "\u672a\u77e5" : pathVariable.value();
                e.pathParas.add(p);
            } else if (queryVariable != null) {
                p.name = queryVariable.value();
                e.queryParas.add(p);
            } else if (isRequestBody != null) {
                e.input.add(p);
            }
            ++i;
        }
        ApiField apiField = m.getAnnotation(ApiField.class);
        e.output = this.handleParameter(out, "out");
        if (apiField != null && apiField.example() != null && apiField.example().length() > 0) {
            e.output.example = apiField.example();
        }
        String group_path = group_base_path + summary.group();
        Group apiGroup = document.findGroup(group_path);
        apiGroup.entries.add(e);
        return e;
    }

    private String parseRef(Class<?> type, String[] refs) {
        if (refs == null || refs.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String ref : refs) {
            if (Strings.isBlank((CharSequence)ref)) continue;
            boolean isMarkdown = Files.getSuffixName((String)ref).equalsIgnoreCase("md");
            String desc = Scans.readResource(type.getPackage().getName(), ref);
            if (isMarkdown) {
                desc = this.translateMarkdown(desc);
                sb.append("<div class='md'>").append(desc).append("</div>");
                continue;
            }
            sb.append(desc);
        }
        return sb.toString();
    }

    private String translateMarkdown(String desc) {
        if (Strings.isBlank((CharSequence)desc)) {
            return "";
        }
        return Markdowns.get().translate(desc);
    }

    private String transApiStyle(ApiStyle style) {
        return style.name();
    }

    private String transState(DevelopmentState state) {
        if (state == DevelopmentState.FINISH) {
            return "\u5df2\u5b8c\u6210";
        }
        if (state == DevelopmentState.OBSOLETED) {
            return "\u5df2\u5e9f\u5f03";
        }
        if (state == DevelopmentState.PROCESS) {
            return "\u5f00\u53d1\u4e2d";
        }
        if (state == DevelopmentState.UNSTART) {
            return "\u672a\u5f00\u53d1";
        }
        return "";
    }

    private ObjectInfo handleParameter(Class<?> clz, String name) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        ObjectInfo p = new ObjectInfo();
        Doc doc = clz.getAnnotation(Doc.class);
        p.name = name == null ? clz.getSimpleName() : name;
        p.title = doc == null ? "" : doc.value();
        p.type = this.isPrimitive(clz) ? clz.getSimpleName() : clz.getName();
        String sum = doc == null ? "" : (Strings.isBlank((CharSequence)doc.desc()) ? doc.value() : doc.desc());
        for (Class<?> superclazz = clz.getSuperclass(); superclazz != null; superclazz = superclazz.getSuperclass()) {
            Doc summary1 = superclazz.getAnnotation(Doc.class);
            if (sum.length() > 0) {
                sum = sum + "<br/>";
            }
            sum = sum + (summary1 == null ? "" : summary1.desc());
        }
        if (doc != null) {
            p.summary = sum + this.parseRef(clz, doc.refs());
        }
        this.deeps = new Deeps();
        this.deeps.push(clz.getName(), this.deeps.getLevel());
        Object instance = null;
        instance = this.newInstance(clz);
        for (Field f : clz.getFields()) {
            ObjectInfo fld = this.handleField(instance, f);
            if (fld == null) continue;
            p.fields.add(fld);
        }
        p.json = instance != null ? Json.toJson((Object)instance, (JsonFormat)JsonFormat.full()) : "{}";
        return p;
    }

    private ObjectInfo handleField(Object instance, Field f) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        this.deeps.incLevel();
        ApiField wf = f.getAnnotation(ApiField.class);
        Annotation[] ass = f.getAnnotations();
        if (wf != null) {
            ObjectInfo fi = new ObjectInfo();
            fi.manditary = wf.mandidate();
            fi.title = wf.value();
            fi.example = wf.example();
            fi.name = f.getName();
            fi.type = f.getType().getName();
            Codes codes = f.getAnnotation(Codes.class);
            if (codes != null) {
                for (Code code : codes.value()) {
                    FieldCode fieldCode = new FieldCode(code.value(), code.desc());
                    fi.codes.add(fieldCode);
                }
            }
            Size stringConstrain = null;
            NotNull nullConstrain = null;
            Min minConstrain = null;
            Max maxConstrain = null;
            for (Annotation a : ass) {
                if (a instanceof Size) {
                    stringConstrain = (Size)a;
                    continue;
                }
                if (a instanceof NotNull) {
                    nullConstrain = (NotNull)a;
                    continue;
                }
                if (a instanceof Min) {
                    minConstrain = (Min)a;
                    continue;
                }
                if (!(a instanceof Max)) continue;
                maxConstrain = (Max)a;
            }
            if (stringConstrain != null) {
                fi.minLength = stringConstrain.min();
                fi.maxLength = stringConstrain.max();
            }
            if (minConstrain != null) {
                fi.min = minConstrain.value();
            }
            if (maxConstrain != null) {
                fi.max = maxConstrain.value();
            }
            if (nullConstrain != null) {
                fi.manditary = true;
            }
            this.deeps.push(f.getType().getName(), this.deeps.getLevel());
            if (this.isPrimitive(f.getType())) {
                this.tacklePrimitive(instance, f, wf, fi);
            } else if (this.isList(f)) {
                ArrayList arrayList = new ArrayList();
                Type type = this.getGenericType(f);
                Logs.get().info((Object)("handle list field " + f.getName() + " with type " + type.getTypeName()));
                Class c = null;
                if (type instanceof ParameterizedType) {
                    ParameterizedType t = (ParameterizedType)type;
                    c = (Class)t.getRawType();
                } else {
                    c = type instanceof TypeVariableImpl ? Object.class : (Class)type;
                }
                f.set(instance, arrayList);
                fi.type = "List<" + type.getTypeName() + ">";
                if (this.isMap(type.getClass())) {
                    this.tackleMap(fi, arrayList);
                } else if (this.isGeneric(c)) {
                    this.tackleListGnericType(arrayList, f, fi);
                } else {
                    this.tackleListObject(fi, arrayList, c);
                }
            } else if (this.isGeneric(f.getType())) {
                this.tackleGnericType(instance, f, fi);
            } else {
                int n = this.deeps.getPreLevelCount(f.getType().getName(), this.deeps.getLevel());
                if (n > 2) {
                    this.deeps.decLevel();
                    return null;
                }
                this.tackleObject(instance, f, fi);
            }
            this.deeps.decLevel();
            return fi;
        }
        this.deeps.decLevel();
        return null;
    }

    private void tacklePrimitive(Object instance, Field f, ApiField wf, ObjectInfo fi) {
        fi.type = f.getType().getSimpleName();
        if (instance != null && !Strings.isBlank((CharSequence)wf.example())) {
            Object obj = Castors.me().castTo((Object)wf.example(), f.getType());
            Mirror.me((Object)instance).setValue(instance, f, obj);
        }
    }

    private void tackleObject(Object instance, Field f, ObjectInfo fi) throws IllegalAccessException, InstantiationException {
        Object cinstance = null;
        cinstance = this.newInstance(f.getType());
        f.set(instance, cinstance);
        Doc fdoc = cinstance.getClass().getAnnotation(Doc.class);
        if (fdoc != null) {
            fi.summary = fdoc.desc();
        }
        for (Field f1 : f.getType().getFields()) {
            ObjectInfo o = this.handleField(cinstance, f1);
            if (o == null) continue;
            fi.fields.add(o);
        }
    }

    private void tackleGnericType(Object instance, Field f, ObjectInfo fi) throws IllegalAccessException, InstantiationException {
        fi.type = "Object";
        RuntimeType rt = f.getAnnotation(RuntimeType.class);
        if (rt == null) {
            fi.summary = "\u8bf7\u7a0b\u5e8f\u5458\u6dfb\u52a0\u6ce8\u89e3 RuntimeType";
        } else {
            for (int i = 0; i < rt.value().length; ++i) {
                Class cls = rt.value()[i];
                fi.refs.add(this.handleParameter(cls, ""));
            }
        }
        f.set(instance, new Object());
    }

    private void tackleListGnericType(List instance, Field f, ObjectInfo fi) throws IllegalAccessException, InstantiationException {
        fi.type = "List<Object>";
        RuntimeType rt = f.getAnnotation(RuntimeType.class);
        if (rt == null) {
            fi.summary = "\u8bf7\u7a0b\u5e8f\u5458\u6dfb\u52a0\u6ce8\u89e3 RuntimeType";
        } else {
            for (int i = 0; i < rt.value().length; ++i) {
                Class cls = rt.value()[i];
                fi.refs.add(this.handleParameter(cls, ""));
            }
        }
        instance.add(new Object());
    }

    private void tackleMap(ObjectInfo fi, ArrayList list) {
        if (fi.example == null || fi.example.length() == 0) {
            fi.example = "key:345";
        }
        String[] items = fi.example.split(",");
        HashMap<String, String> mdata = new HashMap<String, String>();
        for (int i = 0; i < items.length; ++i) {
            String item = items[i];
            String[] kv = (item = Strings.trim((CharSequence)item)).split(":");
            if (kv.length == 1) {
                mdata.put(kv[0], "\u4f8b\u5b50");
                continue;
            }
            mdata.put(kv[0], kv[1]);
        }
        list.add(mdata);
    }

    private void tackleListObject(ObjectInfo fi, ArrayList list, Class<?> c) throws IllegalAccessException, InstantiationException {
        Object cinstance = this.newInstance(c);
        Logs.get().info((Object)("create instance " + c.getName() + " is " + Json.toJson((Object)cinstance)));
        Doc fdoc = c.getAnnotation(Doc.class);
        if (fdoc != null) {
            fi.summary = fdoc.desc();
        }
        if (this.isPrimitive(c)) {
            List listObj = Lang.list4((String)fi.example);
            if (listObj != null) {
                list.addAll(listObj);
            }
        } else {
            list.add(cinstance);
        }
        for (Field f1 : c.getFields()) {
            ObjectInfo o = this.handleField(cinstance, f1);
            if (o == null) continue;
            fi.fields.add(o);
        }
    }

    private Doc getClassDoc(Class<?> cls) {
        Doc doc = cls.getAnnotation(Doc.class);
        return doc;
    }

    private boolean isGeneric(Class<?> c) {
        return c.getSimpleName().equals("Object");
    }

    private boolean isMap(Class<?> c) {
        return c.isAssignableFrom(Map.class);
    }

    private Object newInstance(Class<?> c) {
        Mirror m = Mirror.me(c);
        if (m.isArray()) {
            return new ArrayList();
        }
        if (m.isInt()) {
            return 0;
        }
        if (m.isMap()) {
            return new HashMap();
        }
        if (m.isDouble()) {
            return 0.0;
        }
        if (m.isFloat()) {
            return Float.valueOf(0.0f);
        }
        if (m.isBoolean()) {
            return true;
        }
        if (m.isByte()) {
            Byte b = new Byte("0");
            return b;
        }
        if (m.isLong()) {
            return new Long(0L);
        }
        return m.born(new Object[0]);
    }

    private boolean isList(Field f) {
        if (f.getType().getSimpleName().equals("Object")) {
            return false;
        }
        return f.getType().isAssignableFrom(List.class);
    }

    private Type getGenericType(Field f) {
        if (f.getGenericType() instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)f.getGenericType();
            return pt.getActualTypeArguments()[0];
        }
        return f.getType();
    }

    private boolean isPrimitive(Class<?> c) {
        String[] ps;
        String name = c.getName();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        for (String s : ps = new String[]{"int", "Integer", "float", "Float", "Double", "double", "long", "Long", "Date", "DateTime", "String", "boolean", "Boolean", "char", "short", "byte", "Timestamp"}) {
            if (!name.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws IllegalArgumentException, IllegalAccessException, InstantiationException {
        SpringParser p = new SpringParser();
        ApiDoc doc = p.parse(new GenContext(), "cn.mapway.doc2.test");
        System.out.println(Json.toJson((Object)doc));
    }
}

