/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.servlet;

import cn.mapway.document.helper.DocHelper;
import cn.mapway.document.helper.ParseType;
import cn.mapway.document.helper.Scans;
import cn.mapway.document.module.ApiDoc;
import cn.mapway.document.parser.GenContext;
import cn.mapway.document.resource.Template;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Streams;
import org.nutz.lang.Strings;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class MapwayDocServlet
extends HttpServlet {
    private static Log log = Logs.getLog((String)"Mapway-Document");
    private GenContext context;
    private String packageNames;
    private String connectorPackageName;
    private String connectorClassName;
    private String antHome;
    private static final long serialVersionUID = 1L;
    public static final String PARAM_AUTHOR = "author";
    public static final String PARAM_TITLE = "title";
    public static final String PARAM_SUB_TITLE = "subtitle";
    public static final String PARAM_BASE_PATH = "basePath";
    public static final String PARAM_DOMAIN = "domain";
    public static final String PARAM_ANT_HOME = "antHome";
    public static final String PARAM_SCAN_PACKAGES = "scanPackages";
    public static final String PARAM_CONNECTOR_PACKAGE_NAME = "connectorPackageName";
    public static final String PARAM_CONNECTOR_CLASS_NAME = "connectorClassName";
    public static final String PARAM_COPY_RIGHT = "copyright";
    public static final String PARAM_ENABLE_JAVA_CONNECTOR = "enableJavaConnector";
    public static final String PARAM_ENABLE_GWT_CONNECTOR = "enableGwtConnector";
    public static final String PARAM_API_VERSION = "apiVersion";
    public static final String PARAM_HOME_URL = "homeUrl";
    public static final String PARAM_LOGO_BASE64 = "logoBase64";
    public static final String PARAM_CSS_STYLE = "cssStyle";

    public void destroy() {
        super.destroy();
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pathInfo = request.getPathInfo();
        this.dispatch(pathInfo, request, response);
    }

    private void dispatch(String path, HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (Strings.isBlank((CharSequence)path) || path.equals("/") || path.equals("/index") || path.equals("/index.html")) {
            this.genhtml(request, response);
            return;
        }
        if (path.endsWith("/clear.cache.gif")) {
            this.byteout(response, DocHelper.getClearGifData(), null);
        } else if (path.equals("/help")) {
            this.html(response, Template.readTemplate("/main/java/mapway/document/resource/help.html"));
        } else if (path.equals("/data")) {
            DocHelper helper = new DocHelper();
            ApiDoc api = helper.toDoc(ParseType.PT_SPRING, this.context, this.packageNames);
            this.json(response, api);
        } else if (path.startsWith("/javascript")) {
            String exportName = request.getParameter("apiName");
            if (Strings.isBlank((CharSequence)exportName)) {
                exportName = "Api";
            }
            DocHelper helper = new DocHelper();
            String data = helper.toJavascript(ParseType.PT_SPRING, this.context, this.packageNames, exportName);
            this.out(response, data, "text/javascript");
        } else if (path.startsWith("/ref/")) {
            String url = path.substring(5);
            int pos = url.lastIndexOf(47);
            String packageName = url.substring(0, pos);
            String resName = url.substring(pos + 1);
            byte[] data = Scans.readBinResource(packageName, resName);
            this.byteout(response, data, null);
        }
    }

    private static String getDownloadLocal(HttpServletRequest req) {
        String root = req.getServletContext().getRealPath("/");
        String downloadPath = root + "/download/jar";
        Files.createDirIfNoExists((String)downloadPath);
        return downloadPath;
    }

    private void genhtml(HttpServletRequest request, HttpServletResponse response) {
        File htmlFile = this.getCacheFileName();
        if (!htmlFile.exists()) {
            this.writeToLocal(htmlFile);
        }
        try {
            response.setCharacterEncoding("UTF-8");
            Streams.writeAndClose((Writer)response.getWriter(), (Reader)Streams.utf8r((InputStream)Streams.fileIn((File)htmlFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeToLocal(File htmlFile) {
        DocHelper helper = new DocHelper();
        helper.setAntHome(this.antHome);
        ApiDoc api = helper.toDoc(ParseType.PT_SPRING, this.context, this.packageNames);
        String html = helper.genHTML(api);
        Files.write((File)htmlFile, (Object)Streams.utf8r((InputStream)Lang.ins((CharSequence)html)));
    }

    private File getCacheFileName() {
        return new File(this.getTempFolder() + "/html.data");
    }

    private String getDocRoot(HttpServletRequest request) {
        return MapwayDocServlet.getDownloadLocal(request);
    }

    private void byteout(HttpServletResponse response, byte[] data, String contentType) {
        if (!Strings.isBlank((CharSequence)contentType)) {
            response.setContentType(contentType);
        }
        try {
            response.getOutputStream().write(data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void json(HttpServletResponse response, Object data) {
        this.out(response, Json.toJson((Object)data), "application/json");
    }

    private void html(HttpServletResponse response, String data) {
        this.out(response, data, "text/html");
    }

    private void out(HttpServletResponse response, String data, String contentType) {
        response.setContentType(contentType);
        response.setCharacterEncoding("UTF-8");
        try {
            Lang.writeAll((Writer)response.getWriter(), (String)data);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getBasePath(HttpServletRequest request) {
        String path = request.getContextPath();
        String port = request.getServerPort() == 80 ? "" : ":" + request.getServerPort();
        String basePath = request.getScheme() + "://" + request.getServerName() + port + path + "/";
        return basePath;
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void init() throws ServletException {
        log.info((Object)"\u6587\u6863\u670d\u52a1\u521d\u59cb\u5316");
        Enumeration keys = this.getInitParameterNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            this.log(key + ">" + this.getInitParameter(key));
        }
        this.context = new GenContext();
        this.context.setAuthor(Strings.sBlank((Object)this.getInitParameter(PARAM_AUTHOR)));
        this.context.setDocTitle(Strings.sBlank((Object)this.getInitParameter(PARAM_TITLE)));
        this.context.setDomain(Strings.sBlank((Object)this.getInitParameter(PARAM_DOMAIN)));
        this.context.setBasepath(Strings.sBlank((Object)this.getInitParameter(PARAM_BASE_PATH)));
        this.antHome = Strings.sBlank((Object)this.getInitParameter(PARAM_ANT_HOME));
        this.context.setSubtitle(Strings.sBlank((Object)this.getInitParameter(PARAM_SUB_TITLE)));
        this.packageNames = Strings.sBlank((Object)this.getInitParameter(PARAM_SCAN_PACKAGES));
        this.connectorPackageName = Strings.sBlank((Object)this.getInitParameter(PARAM_CONNECTOR_PACKAGE_NAME));
        this.connectorClassName = Strings.sBlank((Object)this.getInitParameter(PARAM_CONNECTOR_CLASS_NAME));
        this.context.setCopyright(Strings.sBlank((Object)this.getInitParameter(PARAM_COPY_RIGHT)));
        this.context.setEnableJavaConnector(Strings.sBlank((Object)this.getInitParameter(PARAM_ENABLE_JAVA_CONNECTOR)));
        this.context.setEnableGwtConnector(Strings.sBlank((Object)this.getInitParameter(PARAM_ENABLE_GWT_CONNECTOR)));
        this.context.setLogobase64(Strings.sBlank((Object)this.getInitParameter(PARAM_LOGO_BASE64)));
        this.context.setApiversion(Strings.sBlank((Object)this.getInitParameter(PARAM_API_VERSION)));
        this.context.setHomeUrl(Strings.sBlank((Object)this.getInitParameter(PARAM_HOME_URL)));
        this.context.setCssStyle(Strings.sBlank((Object)this.getInitParameter(PARAM_CSS_STYLE)));
        File htmlCache = this.getCacheFileName();
        if (htmlCache.exists()) {
            htmlCache.delete();
        }
    }

    public String getTempFolder() {
        String folder = System.getProperty("java.io.tmpdir");
        System.out.printf("temporary fold >" + folder, new Object[0]);
        return folder;
    }
}

