/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.component.ace;

import cn.mapway.document.ui.client.component.ace.AceAnnotation;
import cn.mapway.document.ui.client.component.ace.AceAnnotationType;
import cn.mapway.document.ui.client.component.ace.AceCommand;
import cn.mapway.document.ui.client.component.ace.AceCommandArgs;
import cn.mapway.document.ui.client.component.ace.AceCommandDescription;
import cn.mapway.document.ui.client.component.ace.AceCommandLine;
import cn.mapway.document.ui.client.component.ace.AceCommandLineListener;
import cn.mapway.document.ui.client.component.ace.AceCompletionCallback;
import cn.mapway.document.ui.client.component.ace.AceCompletionCallbackImpl;
import cn.mapway.document.ui.client.component.ace.AceCompletionProvider;
import cn.mapway.document.ui.client.component.ace.AceEditorCallback;
import cn.mapway.document.ui.client.component.ace.AceEditorCursorPosition;
import cn.mapway.document.ui.client.component.ace.AceEditorMode;
import cn.mapway.document.ui.client.component.ace.AceEditorTheme;
import cn.mapway.document.ui.client.component.ace.AceMarkerType;
import cn.mapway.document.ui.client.component.ace.AceRange;
import cn.mapway.document.ui.client.component.ace.AceSelection;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasText;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AceEditor
extends Composite
implements RequiresResize,
HasText,
TakesValue<String> {
    private static int nextId = 0;
    private final String elementId;
    private JavaScriptObject editor;
    private JsArray<AceAnnotation> annotations = (JsArray)JavaScriptObject.createArray().cast();
    private Element divElement;
    private HashMap<Integer, AceRange> markers = new HashMap();
    private AceSelection selection = null;
    private AceCommandLine commandLine = null;

    public AceEditor() {
        this.elementId = "_aceGWT" + nextId;
        ++nextId;
        FlowPanel div = new FlowPanel();
        div.getElement().setId(this.elementId);
        this.initWidget((Widget)div);
        this.divElement = div.getElement();
    }

    @Deprecated
    public AceEditor(boolean unused) {
        this();
    }

    public native void startEditor();

    public native void redisplay();

    public native void destroy();

    public void setTheme(AceEditorTheme theme) {
        this.setThemeByName(theme.getName());
    }

    public native void setThemeByName(String var1);

    public void setMode(AceEditorMode mode) {
        this.setModeByName(mode.getName());
    }

    public native void setModeByName(String var1);

    public native void setUseWorker(boolean var1);

    public native void addOnChangeHandler(AceEditorCallback var1);

    public native void addOnCursorPositionChangeHandler(AceEditorCallback var1);

    public native int getFontSize();

    public native void setFontSize(String var1);

    public native void setFontSize(int var1);

    public native String getText();

    public native void focus();

    public native int getLineCount();

    public native void setText(String var1);

    public native String getLine(int var1);

    public native void insertAtCursor(String var1);

    public native AceEditorCursorPosition getCursorPosition();

    private AceEditorCursorPosition getCursorPositionImpl(double row, double column) {
        return new AceEditorCursorPosition((int)row, (int)column);
    }

    public int getIndexFromPosition(AceEditorCursorPosition position) {
        return this.getIndexFromPositionImpl(position.toJsObject());
    }

    private native int getIndexFromPositionImpl(JavaScriptObject var1);

    public native AceEditorCursorPosition getPositionFromIndex(int var1);

    public native void setUseSoftTabs(boolean var1);

    public native void setTabSize(int var1);

    public native void gotoLine(int var1);

    public native void setHScrollBarAlwaysVisible(boolean var1);

    public native void setShowGutter(boolean var1);

    public native void setReadOnly(boolean var1);

    public native void setHighlightSelectedWord(boolean var1);

    public native void setShowPrintMargin(boolean var1);

    public void addAnnotation(int row, int column, String text, AceAnnotationType type) {
        this.annotations.push((JavaScriptObject)AceAnnotation.create(row, column, text, type.getName()));
    }

    public native void setAnnotations();

    public native void clearAnnotations();

    private void resetAnnotations() {
        this.annotations = (JsArray)JavaScriptObject.createArray().cast();
    }

    public void removeCommand(AceCommand command) {
        this.removeCommandByName(command.getName());
    }

    public void execCommand(AceCommand command) {
        this.execCommand(command, null);
    }

    public void execCommand(AceCommand command, AceCommandArgs args) {
        this.execCommand(command.getName(), args);
    }

    public native void execCommand(String var1);

    public void execCommand(String command, String arg) {
        this.execCommandHidden(command, arg);
    }

    public void execCommand(String command, AceCommandArgs args) {
        this.execCommandHidden(command, args);
    }

    private native void execCommandHidden(String var1, Object var2);

    public native void removeCommandByName(String var1);

    public native AceCommandDescription getCommandDescription(String var1);

    public native List<String> listCommands();

    public native void addCommand(AceCommandDescription var1);

    public native void setUseWrapMode(boolean var1);

    public void onResize() {
        this.redisplay();
    }

    public void setValue(String value) {
        this.setText(value);
    }

    public String getValue() {
        return this.getText();
    }

    public native void setAutocompleteEnabled(boolean var1);

    public static native void removeAllExistingCompleters();

    public static native void addCompletionProvider(AceCompletionProvider var0);

    public native int addMarker(AceRange var1, String var2, AceMarkerType var3, boolean var4);

    public native int addFloatingMarker(AceRange var1, String var2, AceMarkerType var3);

    public native void removeMarker(int var1);

    public Map<Integer, AceRange> getMarkers() {
        return Collections.unmodifiableMap(this.markers);
    }

    public void removeAllMarkers() {
        Integer[] ids;
        for (Integer id : ids = this.markers.keySet().toArray(new Integer[this.markers.size()])) {
            this.removeMarker(id);
        }
    }

    private void addMarker(int id, AceRange range) {
        this.markers.put(id, range);
    }

    private void removeRegisteredMarker(int id) {
        AceRange range = this.markers.remove(id);
        range.detach();
    }

    public AceSelection getSelection() {
        if (this.selection == null) {
            this.selection = new AceSelection(this.getSelectionJS());
        }
        return this.selection;
    }

    private native JavaScriptObject getSelectionJS();

    public void initializeCommandLine(AceCommandLine cmdLine) {
        this.commandLine = cmdLine;
        this.commandLine.setCommandLineListener(new AceCommandLineListener(){

            @Override
            public void onCommandEntered(String command) {
                AceEditor.this.execCommand(command);
            }
        });
    }

    private static AceCompletionCallback wrapCompletionCallback(JavaScriptObject jsCallback) {
        return new AceCompletionCallbackImpl(jsCallback);
    }
}

