/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.component.Clients;
import cn.mapway.document.ui.client.component.CloseDialogBox;
import cn.mapway.document.ui.client.main.InputParameterPanel;
import cn.mapway.document.ui.client.main.OutputParameter;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.ObjectInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.test.TestPanel;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class EntryPanel
extends Composite {
    private static EntryPanelUiBinder uiBinder = (EntryPanelUiBinder)GWT.create(EntryPanelUiBinder.class);
    Entry mEntry;
    @UiField
    HTML javaSource;
    @UiField
    Label lbTITLE;
    @UiField
    HTML lbSUMMARY;
    @UiField
    Label lbURL;
    @UiField
    Label lbAUTHOR;
    @UiField
    Label lbINVOKE;
    @UiField
    InputParameterPanel paraIn;
    @UiField
    OutputParameter paraOut;
    CloseDialogBox dlg;
    TestPanel testPanel = null;
    @UiField
    Button btnTest;

    public EntryPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.btnTest.setStyleName(SysResource.INSTANCE.getCss().btn());
    }

    public void parse(Entry e) {
        this.mEntry = e;
        this.lbTITLE.setText(e.title());
        this.lbSUMMARY.setHTML(e.summary());
        this.lbURL.setText("\u63a5\u53e3\u7f51\u5740:  " + Clients.getHostPort() + e.url());
        this.lbAUTHOR.setText("\u4f5c\u8005:" + e.author());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < e.invokeMethods().length(); ++i) {
            String invokeMethod = e.invokeMethods().get(i);
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(invokeMethod);
        }
        this.lbINVOKE.setText("\u8c03\u7528\u65b9\u6cd5:" + sb.toString());
        this.paraIn.parseEntry(e);
        this.paraOut.parse(e.output());
        String html = this.toJavaMethod(e);
        this.javaSource.setHTML(html);
    }

    private String toJavaMethod(Entry e) {
        String html = "<p>\u8c03\u7528\u65b9\u6cd5:" + e.methodName() + "</p>";
        html = html + "<p>\u6240\u5c5e\u63a7\u5236\u5668:" + e.parentClassName() + "</p>";
        return html;
    }

    private String toSourceInfo(Entry e) {
        String html = "<p>JAVA\u6e90\u7801\u4fe1\u606f<br/><table cellpadding='5px'>";
        html = html + "<tr><td>\u63a7\u5236\u7c7b</td><td>" + e.parentClassName() + "</td></tr>";
        html = html + "<tr><td>\u63a7\u5236\u65b9\u6cd5</td><td>" + e.methodName() + "</td></tr>";
        if (e.input().length() > 0) {
            html = html + "<tr><td>\u8f93\u5165\u53c2\u6570 </td><td>" + ((ObjectInfo)e.input().get(0)).type() + "</td></tr>";
        }
        if (e.output() != null) {
            html = html + "<tr><td>\u8f93\u51fa\u53c2\u6570</td><td>" + e.output().type() + "</td></tr>";
        }
        html = html + "</table>";
        return html;
    }

    @UiHandler(value={"btnTest"})
    void onTest(ClickEvent e) {
        if (this.dlg == null) {
            this.dlg = new CloseDialogBox();
            this.dlg.setText("\u63a5\u53e3\u6d4b\u8bd5");
            this.testPanel = new TestPanel();
            this.dlg.setWidget((Widget)this.testPanel);
            this.dlg.setGlassEnabled(true);
            this.dlg.setAutoHideEnabled(false);
            this.dlg.setStyleName(SysResource.INSTANCE.getCss().dlg());
        }
        this.dlg.center();
        this.dlg.setText("\u63a5\u53e3\u6d4b\u8bd5-" + this.mEntry.title());
        this.dlg.setSummary(Clients.getHostPort() + this.mEntry.url());
        this.testPanel.invoke(this.mEntry);
    }

    static interface EntryPanelUiBinder
    extends UiBinder<Widget, EntryPanel> {
    }
}

