/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.main;

import cn.mapway.document.ui.client.main.JsonPanel;
import cn.mapway.document.ui.client.main.ObjectInfoPanel;
import cn.mapway.document.ui.client.module.GenInfo;
import cn.mapway.document.ui.client.module.ObjectInfo;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OutputParameter
extends Composite
implements HasSelectionHandlers<ObjectInfo> {
    private static OutputParameterUiBinder uiBinder = (OutputParameterUiBinder)GWT.create(OutputParameterUiBinder.class);
    @UiField
    Label lbType;
    @UiField
    Label lbSummary;
    @UiField
    ObjectInfoPanel tbl;
    @UiField
    JsonPanel jsonPanel;
    @UiField
    HTMLPanel objInfoPanel;
    private SelectionHandler<ObjectInfo> fieldTypeSelectionHandler = new SelectionHandler<ObjectInfo>(){

        public void onSelection(SelectionEvent<ObjectInfo> arg0) {
            ObjectInfo info;
            Anchor a;
            if (OutputParameter.this.mapper != null && (a = OutputParameter.this.mapper.get((info = (ObjectInfo)((Object)arg0.getSelectedItem())).type())) != null) {
                a.getElement().scrollIntoView();
            }
        }
    };
    Map<String, Anchor> mapper;
    List<GenInfo> gens;

    public OutputParameter() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.tbl.addSelectionHandler(this.fieldTypeSelectionHandler);
    }

    public void parse(ObjectInfo output) {
        GWT.log((String)("\u8f93\u51fa\u53c2\u6570" + output.name()));
        this.gens = new ArrayList<GenInfo>();
        this.mapper = new HashMap<String, Anchor>();
        this.lbType.setText(output.type());
        this.lbSummary.setText(output.summary());
        if (this.tbl.isPrimitive(output.type())) {
            this.lbSummary.setVisible(true);
            this.tbl.setVisible(false);
            this.objInfoPanel.setVisible(false);
            this.jsonPanel.setString(output.example());
        } else {
            this.tbl.setVisible(true);
            this.tbl.parse(output, this.gens, this.mapper);
            this.lbSummary.setVisible(false);
            this.objInfoPanel.clear();
            while (this.needContinue(this.gens)) {
                ArrayList<GenInfo> gens2 = new ArrayList<GenInfo>();
                for (GenInfo info : this.gens) {
                    if (info.gen.booleanValue()) continue;
                    ObjectInfoPanel p = new ObjectInfoPanel();
                    p.addSelectionHandler(this.fieldTypeSelectionHandler);
                    p.parse(info.obj, gens2, this.mapper);
                    this.objInfoPanel.add((Widget)p);
                    info.gen = true;
                    Anchor a = new Anchor();
                    a.setName(info.type);
                    this.mapper.put(info.type, a);
                    this.objInfoPanel.add((Widget)a);
                }
                this.merge(this.gens, gens2);
            }
            this.jsonPanel.setJson(output.json());
        }
    }

    private void merge(List<GenInfo> gens, List<GenInfo> gens2) {
        for (GenInfo info : gens2) {
            boolean find = false;
            for (GenInfo gen : gens) {
                if (!gen.type.equals(info.type)) continue;
                find = true;
                break;
            }
            if (find) continue;
            gens.add(info);
        }
    }

    private boolean needContinue(List<GenInfo> gens2) {
        for (GenInfo info : gens2) {
            if (info.gen.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<ObjectInfo> arg0) {
        return this.addHandler((EventHandler)arg0, SelectionEvent.getType());
    }

    static interface OutputParameterUiBinder
    extends UiBinder<Widget, OutputParameter> {
    }
}

