/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.rpc;

import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.rpc.IOnData;
import cn.mapway.document.ui.client.rpc.RpcContext;
import cn.mapway.document.ui.client.test.KeyValueObj;
import cn.mapway.document.ui.client.test.KeyValueObjs;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;

public class ApiDocProxy {
    public static void fetchString(final String url, String jsonData, String contextType, String method, final IOnData<String> handler) throws RequestException {
        RequestBuilder builder = new RequestBuilder(method.equalsIgnoreCase("post") ? RequestBuilder.POST : RequestBuilder.GET, URL.encode((String)url));
        if (contextType == null || contextType.length() == 0) {
            contextType = "application/json;charset=UTF-8";
        }
        builder.setHeader("Content-type", contextType);
        KeyValueObjs headers = KeyValueObjs.parse(LocalStorage.val("gwt_user_token_1"));
        for (int i = 0; i < headers.length(); ++i) {
            KeyValueObj kv = (KeyValueObj)headers.get(i);
            builder.setHeader(kv.getKey(), kv.getValue());
        }
        Request request = builder.sendRequest(jsonData, new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                handler.onError(url, exception.getMessage());
            }

            public void onResponseReceived(Request request, Response response) {
                if (200 == response.getStatusCode()) {
                    String data = response.getText();
                    handler.onSuccess(url, data);
                } else {
                    handler.onError(url, response.getStatusText());
                }
            }
        });
    }

    public static <T extends JavaScriptObject> void fetch(final String url, String jsonData, String method, final IOnData<T> handler) throws RequestException {
        RequestBuilder builder = new RequestBuilder(method.equalsIgnoreCase("post") ? RequestBuilder.POST : RequestBuilder.GET, URL.encode((String)url));
        RpcContext context = RpcContext.get();
        if (context.KEY != null && context.KEY.length() > 0 && context.VALUE != null) {
            builder.setHeader(context.KEY, context.VALUE);
        }
        Request request = builder.sendRequest(jsonData, new RequestCallback(){

            public void onError(Request request, Throwable exception) {
                handler.onError(url, exception.getMessage());
            }

            public void onResponseReceived(Request request, Response response) {
                if (200 == response.getStatusCode()) {
                    String data = response.getText();
                    JavaScriptObject obj = JsonUtils.unsafeEval((String)data);
                    handler.onSuccess(url, obj);
                } else {
                    handler.onError(url, response.getStatusText());
                }
            }
        });
    }

    public static <T extends JavaScriptObject> void fetchData(final String target, final IOnData<T> handler) {
        RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, URL.encode((String)target));
        try {
            Request request = builder.sendRequest(null, new RequestCallback(){

                public void onError(Request request, Throwable exception) {
                    handler.onError(target, exception.getMessage());
                }

                public void onResponseReceived(Request request, Response response) {
                    if (200 == response.getStatusCode()) {
                        String data = response.getText();
                        JavaScriptObject obj = JsonUtils.unsafeEval((String)data);
                        handler.onSuccess(target, obj);
                    } else {
                        handler.onError(target, response.getStatusText());
                    }
                }
            });
        }
        catch (RequestException e) {
            handler.onError(target, e.getMessage());
        }
    }
}

