/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.ui.client.test;

import cn.mapway.document.ui.client.component.ace.AceEditor;
import cn.mapway.document.ui.client.component.ace.AceEditorMode;
import cn.mapway.document.ui.client.main.storage.LocalStorage;
import cn.mapway.document.ui.client.module.Entry;
import cn.mapway.document.ui.client.module.ObjectInfo;
import cn.mapway.document.ui.client.resource.SysResource;
import cn.mapway.document.ui.client.rpc.ApiDocProxy;
import cn.mapway.document.ui.client.rpc.IOnData;
import cn.mapway.document.ui.client.test.HeaderEditor;
import cn.mapway.document.ui.client.test.HeaderItem;
import cn.mapway.document.ui.client.test.HistoryData;
import cn.mapway.document.ui.client.test.InputHistoryPanel;
import cn.mapway.document.ui.client.test.KeyValueObj;
import cn.mapway.document.ui.client.test.KeyValueObjs;
import cn.mapway.document.ui.client.test.TextEditor;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.logical.shared.HasCloseHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.SplitLayoutPanel;
import com.google.gwt.user.client.ui.Widget;

public class TestPanel
extends Composite
implements HasCloseHandlers<Void> {
    public static final String GWT_USER_HEADER = "gwt_user_token_1";
    private static TestPanelUiBinder uiBinder = (TestPanelUiBinder)GWT.create(TestPanelUiBinder.class);
    private final SelectionHandler<HistoryData> historySelectedHandler = new SelectionHandler<HistoryData>(){

        public void onSelection(SelectionEvent<HistoryData> selectionEvent) {
            TestPanel.this.editor.setValue(((HistoryData)selectionEvent.getSelectedItem()).value);
        }
    };
    private final ValueChangeHandler<Integer> historyValueChangedHandler = new ValueChangeHandler<Integer>(){

        public void onValueChange(ValueChangeEvent<Integer> valueChangeEvent) {
            TestPanel.this.changeLayout((Integer)valueChangeEvent.getValue());
        }
    };
    private CloseHandler<String> itemDeleted = new CloseHandler<String>(){

        public void onClose(CloseEvent<String> closeEvent) {
            HeaderItem item = (HeaderItem)((Object)closeEvent.getSource());
            TestPanel.this.htmlHeaders.remove((Widget)item);
            TestPanel.this.headers.remove((String)closeEvent.getTarget());
            TestPanel.this.saveHeader();
        }
    };
    private SelectionHandler<String> historyNameEditorHandler = new SelectionHandler<String>(){

        public void onSelection(SelectionEvent<String> selectionEvent) {
            String name = (String)selectionEvent.getSelectedItem();
            if (name == null || name.length() == 0) {
                return;
            }
            TestPanel.this.saveHistory(name);
            TestPanel.this.sureEditor().hide();
            TestPanel.this.history.render(TestPanel.this.mEntry.relativePath());
        }
    };
    @UiField
    HorizontalPanel htmlHeaders;
    KeyValueObjs headers;
    @UiField
    AceEditor editor;
    @UiField
    AceEditor result;
    Entry mEntry;
    boolean initialize = false;
    @UiField
    Button btnExecute;
    @UiField
    Image imgLoadding;
    @UiField
    Button btnHistory;
    @UiField
    Button btnHeader;
    @UiField
    Button btnFormat;
    @UiField
    Button btnClearCache;
    @UiField
    SplitLayoutPanel hor;
    @UiField
    InputHistoryPanel history;
    TextEditor historyNameEditor;
    HeaderEditor headEditor;
    DialogBox dlg;

    private void saveHistory(String name) {
        String v = LocalStorage.val(this.mEntry.relativePath());
        String key = name;
        if (v == null || v.length() == 0) {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + this.editor.getValue());
        } else {
            LocalStorage.save(this.mEntry.relativePath(), key + "`" + this.editor.getValue() + "|" + v);
        }
    }

    public TestPanel() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        String css = SysResource.INSTANCE.getCss().btn();
        this.btnExecute.setStyleName(css);
        this.btnHistory.setStyleName(css);
        this.btnHeader.setStyleName(css);
        this.btnFormat.setStyleName(css);
        this.btnClearCache.setStyleName(css);
        this.imgLoadding.setUrl(SysResource.INSTANCE.loading().getSafeUri());
        this.history.addSelectionHandler(this.historySelectedHandler);
        this.history.addValueChangeHandler(this.historyValueChangedHandler);
    }

    private void loadHeader() {
        this.htmlHeaders.clear();
        String key = LocalStorage.val(GWT_USER_HEADER);
        this.headers = KeyValueObjs.parse(key);
        for (int i = 0; i < this.headers.length(); ++i) {
            KeyValueObj kv = (KeyValueObj)this.headers.get(i);
            HeaderItem item = new HeaderItem();
            item.setData(kv.getKey(), kv.getValue());
            item.addCloseHandler(this.itemDeleted);
            this.htmlHeaders.add((Widget)item);
        }
    }

    private void saveHeader() {
        LocalStorage.save(GWT_USER_HEADER, this.headers.toJSON());
    }

    protected void onLoad() {
        super.onLoad();
        this.initJsonEditor();
        int width = Window.getClientWidth() - 200;
        int height = Window.getClientHeight() - 200;
        this.setHeight(height + "px");
        this.setWidth(width + "px");
    }

    private void initJsonEditor() {
        if (!this.initialize) {
            this.editor.startEditor();
            this.editor.setMode(AceEditorMode.JSON);
            this.editor.setShowPrintMargin(false);
            this.editor.setFontSize(16);
            this.result.startEditor();
            this.result.setMode(AceEditorMode.JSON);
            this.result.setShowPrintMargin(false);
            this.result.setFontSize(16);
            this.result.setReadOnly(true);
            this.initialize = true;
        }
    }

    public void invoke(Entry entry) {
        this.loadHeader();
        this.mEntry = entry;
        this.history.render(entry.relativePath());
        int historyCount = this.history.getHistoryCount();
        String his = "";
        if (historyCount > 0) {
            his = this.history.get(0);
        }
        if (his == null || his.length() == 0) {
            his = entry.input().length() > 0 ? ((ObjectInfo)entry.input().get(0)).json() : "";
        }
        this.editor.setValue(his);
        this.editor.redisplay();
        this.result.setValue("");
    }

    private void changeLayout(int historyCount) {
        if (historyCount > 0) {
            this.hor.setWidgetHidden((Widget)this.history, false);
            this.hor.setWidgetSize((Widget)this.editor, ((double)this.getOffsetWidth() - this.hor.getWidgetSize((Widget)this.history)) / 2.0);
        } else {
            this.hor.setWidgetHidden((Widget)this.history, true);
            this.hor.setWidgetSize((Widget)this.editor, (double)(this.getOffsetWidth() / 2));
        }
    }

    @UiHandler(value={"btnExecute"})
    void onExecute(ClickEvent ev) {
        this.imgLoadding.setVisible(true);
        this.result.setValue("");
        try {
            ApiDocProxy.fetchString(this.mEntry.url(), this.editor.getValue(), "", this.mEntry.invokeMethods().get(0), new IOnData<String>(){

                @Override
                public void onError(String url, String error) {
                    TestPanel.this.result.setValue(error);
                    TestPanel.this.imgLoadding.setVisible(false);
                }

                @Override
                public void onSuccess(String url, String data) {
                    JavaScriptObject obj = JsonUtils.safeEval((String)data);
                    TestPanel.this.result.setValue(JsonUtils.stringify((JavaScriptObject)obj, (String)"\t"));
                    TestPanel.this.imgLoadding.setVisible(false);
                    TestPanel.this.processToken(url, data);
                }
            });
        }
        catch (RequestException e) {
            this.result.setValue(e.getMessage());
            this.imgLoadding.setVisible(false);
        }
    }

    protected void processToken(String url, String data) {
    }

    public HandlerRegistration addCloseHandler(CloseHandler<Void> handler) {
        return this.addHandler((EventHandler)handler, CloseEvent.getType());
    }

    TextEditor sureEditor() {
        if (this.historyNameEditor == null) {
            this.historyNameEditor = new TextEditor();
            this.historyNameEditor.getElement().getStyle().setZIndex(10001);
            this.historyNameEditor.addSelectionHandler(this.historyNameEditorHandler);
        }
        return this.historyNameEditor;
    }

    @UiHandler(value={"btnHistory"})
    void onHistory(ClickEvent e) {
        this.sureEditor().edit("\u8f93\u5165\u5386\u53f2\u8bb0\u5f55\u540d\u79f0", "\u540d\u79f0", "").center();
    }

    @UiHandler(value={"btnFormat"})
    void onFormatCode(ClickEvent e) {
        String data = this.editor.getValue();
        if (data.length() > 0) {
            JavaScriptObject obj = JsonUtils.safeEval((String)data);
            this.editor.setValue(JsonUtils.stringify((JavaScriptObject)obj, (String)"\t"));
        }
    }

    @UiHandler(value={"btnClearCache"})
    void onClearCache(ClickEvent e) {
        LocalStorage.save(this.mEntry.relativePath(), "");
        this.invoke(this.mEntry);
    }

    @UiHandler(value={"btnHeader"})
    public void btnHeaderClick(ClickEvent event) {
        if (this.dlg == null) {
            this.dlg = new DialogBox();
            this.dlg.getElement().getStyle().setZIndex(10000);
            this.headEditor = new HeaderEditor();
            this.dlg.setText("\u7f16\u8f91HTTP\u5934\u90e8\u4fe1\u606f");
            this.dlg.setWidget((Widget)this.headEditor);
            this.headEditor.addCloseHandler(new CloseHandler<KeyValueObjs>(){

                public void onClose(CloseEvent<KeyValueObjs> closeEvent) {
                    TestPanel.this.dlg.hide();
                    TestPanel.this.loadHeader();
                }
            });
        }
        this.dlg.center();
    }

    static interface TestPanelUiBinder
    extends UiBinder<Widget, TestPanel> {
    }
}

