/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.javaconnector;

import cn.mapway.document.annotation.ApiField;
import cn.mapway.document.gen.GenClassInfo;
import cn.mapway.document.meta.DocAnotationBase;
import cn.mapway.document.meta.module.ApiDocument;
import cn.mapway.document.meta.module.ApiEntry;
import cn.mapway.document.meta.module.FieldInfo;
import cn.mapway.document.meta.module.ParameterInfo;
import cn.mapway.document.util.Template;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class JavaConnectorHelper
extends DocAnotationBase {
    private ArrayList<GenClassInfo> objects = new ArrayList();

    private void addGenClass(ParameterInfo t) {
        boolean find = false;
        for (int i = 0; i < this.objects.size(); ++i) {
            String n2;
            GenClassInfo info = this.objects.get(i);
            String n1 = info.cls.clz.getName();
            if (!n1.equals(n2 = t.clz.getName())) continue;
            find = true;
            break;
        }
        if (!find) {
            GenClassInfo info = new GenClassInfo();
            info.cls = t;
            info.gen = false;
            this.objects.add(info);
        }
    }

    public String toSource(ApiDocument api, String basepath, String srcpath, String packagename) {
        String template;
        try {
            template = Template.readTemplate("/cn/mapway/document/util/resource/connect.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        StringBuilder imports = new StringBuilder();
        StringBuilder apis = new StringBuilder();
        StringBuilder modules = new StringBuilder();
        this.genModules(modules);
        template = template.replaceAll("\\$\\{package\\}", packagename);
        template = template.replaceAll("\\$\\{name\\}", api.clsName + "Connector");
        template = template.replaceAll("\\$\\{basepath\\}", basepath);
        template = template.replaceAll("\\$\\{importModules\\}", imports.toString());
        template = template.replaceAll("\\$\\{apis\\}", apis.toString());
        template = template.replaceAll("\\$\\{modules\\}", modules.toString());
        return template;
    }

    private void genModules(StringBuilder modules) {
        for (GenClassInfo ci : this.objects) {
            this.genModule(modules, ci);
        }
    }

    private void genModule(StringBuilder modules, GenClassInfo ci) {
        ParameterInfo pi = ci.cls;
        modules.append("\tpublic static class " + pi.clz.getSimpleName() + "{\r\n");
        for (FieldInfo fi : pi.flds) {
            String isstatic;
            Field f = fi.fld;
            modules.append("\t/**\r\n");
            modules.append("\t * " + fi.summary + "\r\n");
            modules.append("\t */\r\n");
            ApiField wf = f.getAnnotation(ApiField.class);
            String string = isstatic = Modifier.isStatic(f.getModifiers()) ? "static" : "";
            if (wf == null) continue;
            if (Modifier.isFinal(f.getModifiers())) {
                String dv = "";
                try {
                    dv = f.get(ci).toString();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (f.getType().getSimpleName().equals("String")) {
                    dv = "\"" + dv + "\"";
                }
                modules.append("\tpublic final " + isstatic + " " + f.getType().getSimpleName() + " " + f.getName() + "=" + dv + ";\r\n");
                continue;
            }
            if (JavaConnectorHelper.isPrimitive(f.getType())) {
                modules.append("\tpublic " + isstatic + " " + f.getType().getSimpleName() + " " + f.getName() + ";\r\n");
                continue;
            }
            if (f.getType().isAssignableFrom(List.class)) {
                Type fc = f.getGenericType();
                if (fc == null) {
                    modules.append("\tpublic " + isstatic + " List<?> " + f.getName() + ";\r\n");
                    continue;
                }
                if (fc instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)fc;
                    Class t = (Class)pt.getActualTypeArguments()[0];
                    modules.append("\tpublic " + isstatic + " List<" + t.getSimpleName() + "> " + f.getName() + ";\r\n");
                    continue;
                }
            }
            modules.append("\tpublic " + isstatic + " " + f.getType().getSimpleName() + " " + f.getName() + ";\r\n");
        }
        modules.append("\t}\r\n");
    }

    private void codeEntry(StringBuilder imports, StringBuilder apis, ApiEntry e) {
        StringBuilder method = new StringBuilder();
        String outp = e.output.clz.getSimpleName();
        String inputp = "";
        String webp = "";
        if (e.input.size() > 0) {
            inputp = e.input.get((int)0).clz.getSimpleName() + " req";
            webp = "Json.toJson(req)";
        } else {
            webp = "\"\"";
        }
        method.append("\t/**\r\n");
        method.append("\t * " + e.name + "\r\n");
        method.append("\t *\r\n");
        method.append("\t * @param req \u8bf7\u6c42\u6570\u636e\u5305\r\n");
        method.append("\t * @param \u8fd4\u56de\u6570\u636e\u5305\r\n");
        method.append("\t */\r\n");
        method.append("\tpublic " + outp + " " + e.name + "(" + inputp + ") throws Exception{\r\n");
        method.append("\t\t" + outp + " r=null;\r\n");
        if (e.invokeMethod.contains("POST")) {
            method.append("\t\tr=webpost(\"" + e.relativePath + "\", " + webp + ", " + outp + ".class);\r\n");
        } else {
            method.append("\t\tr=webget(\"" + e.relativePath + "\", " + webp + ", " + outp + ".class);\r\n");
        }
        method.append("\t\treturn r;\r\n");
        method.append("\t}\r\n");
        apis.append(method.toString());
        System.out.print(e.output.name + " " + e.input.size() + "\r\n");
        this.handleModule(e.output);
        if (e.input.size() > 0) {
            this.handleModule(e.input.get(0));
        }
    }

    private void handleModule(ParameterInfo info) {
        if (JavaConnectorHelper.isPrimitive(info.clz)) {
            return;
        }
        this.addGenClass(info);
        for (FieldInfo fi : info.flds) {
            Field f = fi.fld;
            ApiField wf = f.getAnnotation(ApiField.class);
            if (wf == null || JavaConnectorHelper.isPrimitive(f.getType())) continue;
            if (f.getType().isAssignableFrom(List.class)) {
                Type fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)fc;
                Class t = (Class)pt.getActualTypeArguments()[0];
                ParameterInfo pi = JavaConnectorHelper.handleParameter(t);
                this.handleModule(pi);
                continue;
            }
            ParameterInfo pi = JavaConnectorHelper.handleParameter(f.getType());
            if (JavaConnectorHelper.isPrimitive(pi.clz)) continue;
            this.addGenClass(pi);
        }
    }
}

