/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.meta.module;

import cn.mapway.document.meta.module.ApiEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ApiGroup {
    public String name;
    public String summary;
    private List<ApiGroup> subGroup = new ArrayList<ApiGroup>();
    private ApiGroup parent;
    public List<ApiEntry> entries = new ArrayList<ApiEntry>();

    public void addChildGroup(ApiGroup g) {
        g.setParent(this);
        this.subGroup.add(g);
    }

    public void clearChildGroup() {
        this.subGroup.clear();
    }

    public void removeChildGroup(ApiGroup g) {
        this.subGroup.remove(g);
    }

    public List<ApiGroup> getChildGroups() {
        return this.subGroup;
    }

    public String getPath() {
        ArrayList<String> strArray = new ArrayList<String>();
        for (ApiGroup g = this.getParent(); g != null; g = g.getParent()) {
            strArray.add(g.name);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = strArray.size() - 1; i >= 0; --i) {
            if (((String)strArray.get(i)).equals("/")) continue;
            sb.append("/" + (String)strArray.get(i));
        }
        return sb.toString();
    }

    public ApiGroup() {
        this.setParent(null);
    }

    public void sort() {
        Collections.sort(this.subGroup, new Comparator<ApiGroup>(){

            @Override
            public int compare(ApiGroup o1, ApiGroup o2) {
                return o1.name.compareTo(o2.name);
            }
        });
        Collections.sort(this.entries, new Comparator<ApiEntry>(){

            @Override
            public int compare(ApiEntry o1, ApiEntry o2) {
                return o1.relativePath.compareTo(o2.relativePath);
            }
        });
        for (ApiGroup g : this.subGroup) {
            g.sort();
        }
    }

    public ApiGroup getParent() {
        return this.parent;
    }

    public void setParent(ApiGroup parent) {
        this.parent = parent;
    }
}

