/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.gwtprc;

import cn.mapway.document.annotation.ApiField;
import cn.mapway.document.gen.GenClassInfo;
import cn.mapway.document.meta.DocAnotationBase;
import cn.mapway.document.meta.module.ApiDocument;
import cn.mapway.document.meta.module.ApiEntry;
import cn.mapway.document.meta.module.FieldInfo;
import cn.mapway.document.meta.module.ParameterInfo;
import cn.mapway.document.util.Template;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class GwtRpcHelper
extends DocAnotationBase {
    private ArrayList<GenClassInfo> objects = new ArrayList();

    private void addGenClass(ParameterInfo t) {
        boolean find = false;
        for (int i = 0; i < this.objects.size(); ++i) {
            String n2;
            GenClassInfo info = this.objects.get(i);
            String n1 = info.cls.clz.getName();
            if (!n1.equals(n2 = t.clz.getName())) continue;
            find = true;
            break;
        }
        if (!find) {
            GenClassInfo info = new GenClassInfo();
            info.cls = t;
            info.gen = false;
            this.objects.add(info);
        }
    }

    public String toSource(ApiDocument api, String basepath, String srcpath, String packagename) {
        String template;
        try {
            template = Template.readTemplate("/cn/mapway/document/util/resource/gwtconnect.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        StringBuilder imports = new StringBuilder();
        StringBuilder apis = new StringBuilder();
        StringBuilder modules = new StringBuilder();
        this.genModules(modules);
        template = template.replaceAll("\\$\\{package\\}", packagename);
        template = template.replaceAll("\\$\\{name\\}", api.clsName + "Connector");
        template = template.replaceAll("\\$\\{basepath\\}", basepath);
        template = template.replaceAll("\\$\\{importModules\\}", imports.toString());
        template = template.replaceAll("\\$\\{apis\\}", apis.toString());
        template = template.replaceAll("\\$\\{modules\\}", modules.toString());
        return template;
    }

    private void genModules(StringBuilder modules) {
        for (GenClassInfo ci : this.objects) {
            this.genModule(modules, ci);
        }
    }

    private void genModule(StringBuilder modules, GenClassInfo ci) {
        ParameterInfo pi = ci.cls;
        String clzname = pi.clz.getSimpleName();
        modules.append("\tpublic static class " + clzname + " extends JavaScriptObject{\r\n");
        modules.append("protected " + clzname + "(){}");
        modules.append("public native final boolean isDefine(String name)/*-{return !( this[name]===undefined || this[name]==null );}-*/;\r\n");
        modules.append("\tpublic final  native static " + clzname + " create()/*-{return new Object();}-*/;\r\n");
        modules.append("\tpublic final  native static " + clzname + " create(JavaScriptObject obj)/*-{return obj}-*/;\r\n");
        for (FieldInfo fi : pi.flds) {
            String isstatic;
            Field f = fi.fld;
            modules.append("\t/**\r\n");
            modules.append("\t * " + fi.summary + "\r\n");
            modules.append("\t */\r\n");
            ApiField wf = f.getAnnotation(ApiField.class);
            String string = isstatic = Modifier.isStatic(f.getModifiers()) ? "static" : "";
            if (wf == null) continue;
            if (Modifier.isFinal(f.getModifiers())) {
                String dv = "";
                try {
                    dv = f.get(ci).toString();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (f.getType().getSimpleName().equals("String")) {
                    dv = "\"" + dv + "\"";
                }
                modules.append("\tpublic final " + isstatic + " " + f.getType().getSimpleName() + " " + f.getName() + "=" + dv + ";\r\n");
                continue;
            }
            if (GwtRpcHelper.isPrimitive(f.getType())) {
                String type = this.getScriptType(f.getType());
                modules.append("\tpublic final  native" + isstatic + " " + type + " get" + f.getName() + "()/*-{return this." + f.getName() + ";}-*/;" + ";\r\n");
                modules.append("\tpublic final  native" + isstatic + " void " + " set" + f.getName() + "(" + type + " v)/*-{this." + f.getName() + "=v;}-*/;" + ";\r\n");
                continue;
            }
            if (f.getType().isAssignableFrom(List.class)) {
                Type fc = f.getGenericType();
                if (fc == null) {
                    modules.append("\tpublic final  native " + isstatic + " JsArray<?> " + " get" + f.getName() + "()/*-{return this." + f.getName() + ";}-*/;" + ";\r\n");
                    modules.append("\tpublic final  native" + isstatic + " void " + " set" + f.getName() + "(JsArray<?> v)/*-{this." + f.getName() + "=v;}-*/;" + ";\r\n");
                    continue;
                }
                if (fc instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)fc;
                    Class t = (Class)pt.getActualTypeArguments()[0];
                    String type = this.getScriptListType(t);
                    modules.append("\tpublic final native " + isstatic + type + " get" + f.getName() + "()/*-{return this." + f.getName() + ";}-*/;" + ";\r\n");
                    modules.append("\tpublic final  native" + isstatic + " void " + " set" + f.getName() + "(" + type + " v)/*-{this." + f.getName() + "=v;}-*/;" + ";\r\n");
                    continue;
                }
            }
            modules.append("\tpublic final  native" + isstatic + " " + f.getType().getSimpleName() + " get" + f.getName() + "()/*-{return this." + f.getName() + ";}-*/;" + ";\r\n");
            modules.append("\tpublic final  native" + isstatic + " void " + " set" + f.getName() + "(" + f.getType().getSimpleName() + " v)/*-{this." + f.getName() + "=v;}-*/;" + ";\r\n");
        }
        modules.append("\t}\r\n");
    }

    private String getScriptType(Class<?> t) {
        String type = t.getSimpleName();
        if (type.equals("String") || type.equals("String")) {
            return "String";
        }
        if (type.equals("Integer") || type.equals("int")) {
            return "int";
        }
        if (type.equals("Double") || type.equals("double")) {
            return "double";
        }
        if (type.equals("Long") || type.equals("long")) {
            return "double";
        }
        if (type.equals("Float") || type.equals("float")) {
            return "double";
        }
        if (type.equals("Boolean") || type.equals("boolean")) {
            return "boolean";
        }
        return type;
    }

    private String getScriptListType(Class<?> t) {
        String type = t.getSimpleName();
        if (type.equals("String") || type.equals("String")) {
            return "JsArrayString";
        }
        if (type.equals("Integer") || type.equals("int")) {
            return "JsArrayInteger";
        }
        if (type.equals("Double") || type.equals("double")) {
            return "JsArrayNumber";
        }
        if (type.equals("Long") || type.equals("long")) {
            return "JsArrayNumber";
        }
        if (type.equals("Float") || type.equals("float")) {
            return "JsArrayInteger";
        }
        if (type.equals("Boolean") || type.equals("boolean")) {
            return "JsArrayBoolean";
        }
        return "JsArray<" + type + ">";
    }

    private void codeEntry(StringBuilder imports, StringBuilder apis, ApiEntry e) {
        String m;
        StringBuilder method = new StringBuilder();
        String outp = e.output.clz.getSimpleName();
        if (GwtRpcHelper.isPrimitive(e.output.clz)) {
            outp = "String";
        }
        String inputp = "";
        String webp = "";
        if (e.input.size() > 0) {
            inputp = e.input.get((int)0).clz.getSimpleName() + " req,";
            webp = "Jsons.toJson(req,\"\",\"\")";
        } else {
            webp = "\"\"";
        }
        method.append("\t/**\r\n");
        method.append("\t * " + e.name + "\r\n");
        method.append("\t *\r\n");
        method.append("\t * @param req \u8bf7\u6c42\u6570\u636e\u5305\r\n");
        method.append("\t * @param \u8fd4\u56de\u6570\u636e\u5305\r\n");
        method.append("\t */\r\n");
        method.append("\tpublic  static void " + e.name + "(" + inputp + " final IServerCallback<" + outp + "> handler){\r\n");
        method.append("\t\t String data=" + webp + ";\r\n");
        String string = m = outp.equals("String") ? "String" : "";
        if (e.invokeMethod.contains("POST")) {
            method.append("\t\tdoPost" + m + "(\"" + e.relativePath + "\", data,handler);\r\n");
        } else {
            method.append("\t\tdoGet" + m + "(\"" + e.relativePath + "\",data, handler);\r\n");
        }
        method.append("\t\treturn ;\r\n");
        method.append("\t}\r\n");
        apis.append(method.toString());
        System.out.print(e.output.name + " " + e.input.size() + "\r\n");
        this.handleModule(e.output);
        if (e.input.size() > 0) {
            this.handleModule(e.input.get(0));
        }
    }

    private void handleModule(ParameterInfo info) {
        if (GwtRpcHelper.isPrimitive(info.clz)) {
            return;
        }
        this.addGenClass(info);
        for (FieldInfo fi : info.flds) {
            Field f = fi.fld;
            ApiField wf = f.getAnnotation(ApiField.class);
            if (wf == null || GwtRpcHelper.isPrimitive(f.getType())) continue;
            if (f.getType().isAssignableFrom(List.class)) {
                Type fc = f.getGenericType();
                if (fc == null || !(fc instanceof ParameterizedType)) continue;
                ParameterizedType pt = (ParameterizedType)fc;
                Class t = (Class)pt.getActualTypeArguments()[0];
                ParameterInfo pi = GwtRpcHelper.handleParameter(t);
                this.handleModule(pi);
                continue;
            }
            ParameterInfo pi = GwtRpcHelper.handleParameter(f.getType());
            this.handleModule(pi);
        }
    }
}

