/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.meta;

import cn.mapway.document.annotation.Doc;
import cn.mapway.document.gen.module.GenContext;
import cn.mapway.document.meta.DocAnotationBase;
import cn.mapway.document.meta.module.ApiDocument;
import cn.mapway.document.meta.module.ApiEntry;
import cn.mapway.document.meta.module.ApiGroup;
import cn.mapway.document.meta.module.ParameterInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.nutz.mvc.annotation.At;
import org.nutz.mvc.annotation.POST;
import org.nutz.resource.Scans;

public class NutzParser
extends DocAnotationBase {
    public ApiDocument parsePackage(String packageName, GenContext context) {
        List clzs = Scans.me().scanPackage(packageName);
        ApiDocument doc = new ApiDocument();
        doc.author = context.getAuthor();
        doc.basePath = context.getBasepath();
        doc.title = context.getDocTitle();
        for (Class clz : clzs) {
            if (clz.getAnnotation(Doc.class) == null) continue;
            this.parseClass(doc, clz);
        }
        return doc;
    }

    private void parseClass(ApiDocument apiDoc, Class<?> clz) {
        Doc doc = clz.getAnnotation(Doc.class);
        String path = doc.group();
        ApiGroup apigroup = apiDoc.findGroup(path);
        this.populateGroup(apigroup, clz);
    }

    private void populateGroup(ApiGroup apiGroup, Class<?> c) {
        Method m;
        int i;
        String[] paths;
        String basepath = "";
        At rm = c.getAnnotation(At.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            basepath = paths[0];
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            At rm1 = m.getAnnotation(At.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        Collections.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (i = 0; i < list.size(); ++i) {
            m = (Method)list.get(i);
            ApiEntry entry = this.handleMethod(m);
            if (entry == null) continue;
            entry.relativePath = basepath + entry.relativePath;
            apiGroup.entries.add(entry);
        }
    }

    public ApiDocument toApiDocument(Class<?> c) {
        Method m;
        int i;
        Doc summary;
        String[] paths;
        ApiDocument api = new ApiDocument();
        api.clsName = c.getSimpleName();
        At rm = c.getAnnotation(At.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            api.basePath = paths[0];
        }
        if ((summary = c.getAnnotation(Doc.class)) != null) {
            api.title = summary.value();
            api.author = summary.author();
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            At rm1 = m.getAnnotation(At.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        Collections.sort(list, new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (i = 0; i < list.size(); ++i) {
            ApiEntry entry;
            m = (Method)list.get(i);
            if (!m.getName().equals("index") && (entry = this.handleMethod(m)) == null) continue;
        }
        return api;
    }

    private ApiEntry handleMethod(Method m) {
        POST post;
        String[] paths;
        ApiEntry e = new ApiEntry();
        At rm = m.getAnnotation(At.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            e.relativePath = paths[0];
        }
        if (e.relativePath.length() == 0) {
            return null;
        }
        Doc summary = m.getAnnotation(Doc.class);
        if (summary != null) {
            e.name = summary.value();
            e.summary = summary.desc();
        }
        e.invokeMethod = (post = m.getAnnotation(POST.class)) == null ? "GET" : "POST";
        Class<?>[] ps = m.getParameterTypes();
        Class<?> out = m.getReturnType();
        for (Class<?> clz : ps) {
            ParameterInfo p;
            String name = clz.getSimpleName();
            if (name.startsWith("Http") || (p = NutzParser.handleParameter(clz)) == null) continue;
            e.input.add(p);
        }
        e.output = NutzParser.handleParameter(out);
        return e;
    }

    public static void main(String[] args) {
        NutzParser p = new NutzParser();
        p.parsePackage("", new GenContext());
    }
}

