/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.doc;

import cn.mapway.document.annotation.ApiField;
import cn.mapway.document.gen.GenClassInfo;
import cn.mapway.document.gen.module.GenContext;
import cn.mapway.document.javascript.JavascriptHelper;
import cn.mapway.document.meta.DocAnotationBase;
import cn.mapway.document.meta.module.ApiDocument;
import cn.mapway.document.meta.module.ApiEntry;
import cn.mapway.document.meta.module.ApiGroup;
import cn.mapway.document.meta.module.FieldInfo;
import cn.mapway.document.meta.module.ParameterInfo;
import cn.mapway.document.util.Template;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.Times;

public class ApiDocumentHelper
extends DocAnotationBase {
    public Map<String, Integer> depth;
    private ArrayList<GenClassInfo> objects = new ArrayList();

    private void addGenClass(ParameterInfo t) {
        boolean find = false;
        for (int i = 0; i < this.objects.size(); ++i) {
            String n2;
            GenClassInfo info = this.objects.get(i);
            String n1 = info.cls.clz.getName();
            if (!n1.equals(n2 = t.clz.getName())) continue;
            find = true;
            break;
        }
        if (!find) {
            GenClassInfo info = new GenClassInfo();
            info.cls = t;
            info.gen = false;
            this.objects.add(info);
        }
    }

    public String genJavascript(ApiDocument api, GenContext context) {
        JavascriptHelper helper = new JavascriptHelper();
        api.clsName = context.getNameSpace();
        String body = helper.toJavascript(api, context.getBasepath());
        return body;
    }

    public String gendoc(ApiDocument api, GenContext context) {
        String template;
        if (context.getDocTitle() != null && context.getDocTitle().length() > 0) {
            api.title = context.getDocTitle();
        }
        if (context.getAuthor() != null && context.getAuthor().length() > 0) {
            api.author = context.getAuthor();
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder catalog = new StringBuilder();
        StringBuilder apiIndex = new StringBuilder();
        catalog.append("<div>");
        sb.append("");
        String author = api.author;
        int indent = 1;
        for (ApiGroup g : api.root.getChildGroups()) {
            this.handlerGroup(indent, g, catalog, sb, apiIndex);
        }
        catalog.append("</div>");
        StringBuilder sb1 = new StringBuilder();
        ArrayList<GenClassInfo> objs = new ArrayList<GenClassInfo>();
        for (GenClassInfo info : this.objects) {
            if (info.gen) continue;
            objs.add(info);
        }
        while (objs.size() > 0) {
            for (int i = 0; i < objs.size(); ++i) {
                GenClassInfo info;
                info = (GenClassInfo)objs.get(i);
                sb1.append("<div class='m_block'>");
                sb1.append("<a class='bookmark' style='height:60px;display:block;' id='cls_" + info.cls.clz.getSimpleName() + "'></a>");
                sb1.append("<div class='m_title'>" + info.cls.clz.getSimpleName() + "</div>");
                sb1.append(this.descriptObject(info.cls));
                sb1.append("</div>");
                info.gen = true;
            }
            objs = new ArrayList();
            for (GenClassInfo info : this.objects) {
                if (info.gen) continue;
                objs.add(info);
            }
        }
        sb.append(sb1.toString());
        sb.append(apiIndex.toString());
        try {
            template = Template.readTemplate("/cn/mapway/document/util/resource/doctemplate.html");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
        template = template.replaceAll("\\$\\{basePath\\}", context.getBasepath());
        template = template.replaceAll("\\$\\{page_title\\}", api.title);
        template = template.replaceAll("\\$\\{page_catalog\\}", catalog.toString());
        template = template.replaceAll("\\$\\{page_content\\}", sb.toString());
        template = template.replaceAll("\\$\\{page_footer\\}", "&copy;" + (Times.now().getYear() + 1900) + "&nbsp; " + context.getDomain() + " &nbsp;&nbsp;&nbsp;\u8054\u7cfb:" + author);
        return template;
    }

    private void handlerEntry(int indent, ApiEntry e, StringBuilder catalog, StringBuilder sb) {
        String id = e.relativePath.replace("/", "");
        String cls = "entry";
        catalog.append("<li class='" + cls + "'>");
        catalog.append("<a  href='#" + id + "'>");
        catalog.append(e.name);
        catalog.append("</a></li>");
        sb.append("<a class='bookmark' style='height:60px;display:block;' id='" + id + "'></a>");
        sb.append("<div class='m_block'><table width='100%' cellpadding='5px'>");
        sb.append("<tr><td colspan='2' class='m_title' >" + e.name + "<div class='m_subtitle'>" + e.summary + "</div>" + "</td></tr>");
        sb.append("<tr><td class='m_path' ><a href='${basePath}" + e.relativePath + "' target='_blank'>${basePath}" + e.relativePath + "</a></td><td align='right'>\u5f00\u53d1\u4eba\u5458:" + e.author + "</td></tr>");
        sb.append("<tr><td colspan='2' >\u8c03\u7528\u65b9\u6cd5:" + e.invokeMethod + "</td></tr>");
        sb.append("</table>");
        StringBuilder inputstbl = new StringBuilder();
        for (ParameterInfo i : e.input) {
            inputstbl.append("<div class='objdesc'>\u4f20\u5165\u53c2\u6570\uff1a" + i.title + "</div>");
            inputstbl.append(this.descriptObject(i));
        }
        sb.append(inputstbl.toString());
        sb.append("<div class='objdesc'>\u4f20\u51fa\u53c2\u6570\uff1a" + e.output.title + "</div>");
        sb.append(this.descriptObject(e.output));
        StringBuilder codeexample = new StringBuilder();
        for (ParameterInfo i : e.input) {
            codeexample.append("<div class='code'>\u4f20\u5165\u53c2\u6570" + i.title + "\u793a\u4f8b");
            this.depth = new HashMap<String, Integer>();
            codeexample.append("<pre>" + Json.toJson((Object)this.parameterExample(i, this.depth), (JsonFormat)JsonFormat.full()) + "</pre>");
            codeexample.append("</div>");
        }
        this.depth = new HashMap<String, Integer>();
        codeexample.append("<div class='code'>\u4f20\u51fa\u53c2\u6570\u793a\u4f8b");
        codeexample.append("<pre>" + Json.toJson((Object)this.parameterExample(e.output, this.depth), (JsonFormat)JsonFormat.full()) + "</pre>");
        codeexample.append("</div>");
        sb.append(codeexample.toString());
        sb.append("</div>");
    }

    private Object parameterExample(ParameterInfo i, Map<String, Integer> depth2) {
        Object p = null;
        try {
            p = i.clz.newInstance();
            for (FieldInfo fi : i.flds) {
                Field f = fi.fld;
                String type = f.getType().getSimpleName();
                if (type.compareTo("List") == 0) {
                    Object sub;
                    ArrayList<Object> list = new ArrayList<Object>();
                    f.set(p, list);
                    Type fc = f.getGenericType();
                    if (!(fc instanceof ParameterizedType)) continue;
                    ParameterizedType pt = (ParameterizedType)fc;
                    Class t = (Class)pt.getActualTypeArguments()[0];
                    if (ApiDocumentHelper.isPrimitive(t)) {
                        String tt = t.getSimpleName();
                        if (tt.contains("String")) {
                            list.add("XXXXXX");
                            continue;
                        }
                        if (tt.contains("int") || tt.contains("Integer")) {
                            list.add(0);
                            continue;
                        }
                        if (type.contains("float") || type.contains("FLoat")) {
                            list.add(0.0);
                            continue;
                        }
                        if (type.contains("Double") || type.contains("double")) {
                            list.add(0.0);
                            continue;
                        }
                        if (type.contains("Long") || type.contains("long")) {
                            list.add(0);
                            continue;
                        }
                        if (!type.contains("bool") && !type.contains("Boolean")) continue;
                        list.add(true);
                        continue;
                    }
                    ParameterInfo subInfo = ApiDocumentHelper.handleParameter(t);
                    Integer count1 = depth2.get(subInfo.name);
                    if (count1 == null) {
                        depth2.put(subInfo.name, 1);
                        sub = this.parameterExample(subInfo, depth2);
                        list.add(sub);
                        continue;
                    }
                    if (count1 > 2) continue;
                    depth2.put(subInfo.name, count1 + 1);
                    sub = this.parameterExample(subInfo, depth2);
                    list.add(sub);
                    continue;
                }
                if (!ApiDocumentHelper.isPrimitive(f.getType())) {
                    Object sub;
                    ParameterInfo subInfo = ApiDocumentHelper.handleParameter(f.getType());
                    Integer count1 = depth2.get(subInfo.name);
                    if (count1 == null) {
                        depth2.put(subInfo.name, 1);
                        sub = this.parameterExample(subInfo, depth2);
                        f.set(p, sub);
                        continue;
                    }
                    if (count1 > 2) continue;
                    depth2.put(subInfo.name, count1 + 1);
                    sub = this.parameterExample(subInfo, depth2);
                    f.set(p, sub);
                    continue;
                }
                if (fi.example == null) continue;
                if (type.contains("String")) {
                    f.set(p, fi.example);
                    continue;
                }
                if (type.contains("int") || type.contains("Integer")) {
                    if (fi.example.length() > 0) {
                        f.set(p, (int)Integer.valueOf(fi.example));
                        continue;
                    }
                    f.set(p, 0);
                    continue;
                }
                if (type.contains("float") || type.contains("FLoat")) {
                    if (fi.example.length() > 0) {
                        f.set(p, Float.valueOf(Float.valueOf(fi.example).floatValue()));
                        continue;
                    }
                    f.set(p, 0.0);
                    continue;
                }
                if (type.contains("Double") || type.contains("double")) {
                    if (fi.example.length() > 0) {
                        f.set(p, (double)Double.valueOf(fi.example));
                        continue;
                    }
                    f.set(p, 0.0);
                    continue;
                }
                if (type.contains("Long") || type.contains("long")) {
                    if (fi.example.length() > 0) {
                        f.set(p, (long)Long.valueOf(fi.example));
                        continue;
                    }
                    f.set(p, 0L);
                    continue;
                }
                if (!type.contains("bool") && !type.contains("Boolean")) continue;
                if (fi.example.length() > 0) {
                    if (fi.example.compareToIgnoreCase("false") == 0 || fi.example.compareToIgnoreCase("0") == 0) {
                        f.set(p, false);
                        continue;
                    }
                    f.set(p, true);
                    continue;
                }
                f.set(p, false);
            }
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        return p;
    }

    private void handlerGroup(int indent, ApiGroup g, StringBuilder catalog, StringBuilder detail, StringBuilder apiIndex) {
        String cls = "tree" + indent++;
        catalog.append("<div subgroup='" + g.getChildGroups().size() + "'  class='" + cls + "'>");
        String path = g.getPath();
        path = path.replace("/", "_");
        String groupName = "group" + path;
        catalog.append("<div><a href='#" + groupName + "'>");
        catalog.append(g.name);
        catalog.append("</a></div>");
        apiIndex.append("<a name='" + groupName + "'></a>");
        apiIndex.append("<div class='indexGroup'>" + g.getPath() + "/" + g.name + "</div>");
        if (g.entries.size() > 0) {
            apiIndex.append("<table width='100%' class='indexTable'>");
            int index = 1;
            for (ApiEntry e : g.entries) {
                apiIndex.append("<tr>");
                apiIndex.append("<td width='50px' align='right'>" + index++ + "</td>");
                apiIndex.append("<td width='250px'>" + e.name + "</td>");
                apiIndex.append("<td>" + e.relativePath + "</td>");
                apiIndex.append("<td align='right'>" + e.author + "</td>");
                apiIndex.append("</tr>");
            }
            apiIndex.append("</table>");
        }
        for (ApiGroup subg : g.getChildGroups()) {
            this.handlerGroup(indent, subg, catalog, detail, apiIndex);
        }
        if (g.entries.size() > 0) {
            catalog.append("<ol>");
            for (ApiEntry e : g.entries) {
                this.handlerEntry(indent, e, catalog, detail);
            }
            catalog.append("</ol>");
        }
        catalog.append("</div>");
    }

    private String descriptObject(ParameterInfo info) {
        StringBuilder sb = new StringBuilder();
        sb.append("<table width='100%' border='1' class='tbl_param' cellpadding='5px'>");
        sb.append("<tr><td class='m_subtitle' colspan=\"5\">" + info.title + "<br/>" + info.summary + "</td></tr>");
        sb.append("<tr class='tbheader'><th>\u540d\u79f0</th><th>\u7c7b\u578b</th><th>\u957f\u5ea6</th><th>\u9009\u9879</th><th>\u89e3\u91ca</th></tr>");
        for (FieldInfo fi : info.flds) {
            Field f = fi.fld;
            ApiField wf = f.getAnnotation(ApiField.class);
            if (wf == null) continue;
            sb.append("<tr>");
            if (Modifier.isFinal(f.getModifiers())) {
                try {
                    sb.append("<td class='m_const' width='300px'>" + f.getName() + "(" + f.get(info.clz).toString() + ")</td>");
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                sb.append("<td class='key' width='300px'>" + f.getName() + "</td>");
            }
            if (ApiDocumentHelper.isPrimitive(f.getType())) {
                sb.append("<td width='150px'>" + f.getType().getSimpleName() + "</td>");
            } else if (f.getType().isAssignableFrom(List.class)) {
                Type fc = f.getGenericType();
                if (fc == null) {
                    sb.append("<td width='150px'>" + f.getType().getSimpleName() + "</td>");
                    continue;
                }
                if (fc instanceof ParameterizedType) {
                    ParameterizedType pt = (ParameterizedType)fc;
                    Class t = (Class)pt.getActualTypeArguments()[0];
                    ParameterInfo pi = ApiDocumentHelper.handleParameter(t);
                    if (!ApiDocumentHelper.isPrimitive(pi.clz)) {
                        this.addGenClass(pi);
                    }
                    sb.append("<td width='150px'><a href='#cls_" + t.getSimpleName() + "'>" + "List&lt;" + t.getSimpleName() + "&gt;</a></td>");
                }
            } else {
                ParameterInfo pi = ApiDocumentHelper.handleParameter(f.getType());
                if (!ApiDocumentHelper.isPrimitive(pi.clz)) {
                    this.addGenClass(pi);
                }
                sb.append("<td width='150px'><a href='#cls_" + f.getType().getSimpleName() + "'>" + f.getType().getSimpleName() + "</a></td>");
            }
            sb.append("<td width='50px'>" + (wf.length() == 0 ? "" : Integer.valueOf(wf.length())) + "</td>");
            sb.append("<td width='60px'>" + (wf.mandidate() ? "\u5fc5\u586b" : "\u53ef\u9009") + "</td>");
            sb.append("<td class='doc'>" + wf.value() + "</td>");
            sb.append("</tr>");
        }
        sb.append("</table>");
        return sb.toString();
    }
}

