/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.document.meta;

import cn.mapway.document.annotation.Doc;
import cn.mapway.document.gen.module.GenContext;
import cn.mapway.document.meta.DocAnotationBase;
import cn.mapway.document.meta.module.ApiDocument;
import cn.mapway.document.meta.module.ApiEntry;
import cn.mapway.document.meta.module.ApiGroup;
import cn.mapway.document.meta.module.ParameterInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.At;
import org.nutz.resource.Scans;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

public class SpringParser
extends DocAnotationBase {
    private static final Log log = Logs.getLog(SpringParser.class);

    public ApiDocument parsePackage(String packageName, GenContext context) {
        String[] pks = packageName.split(",");
        ArrayList clzs = new ArrayList();
        for (String pk : pks) {
            List clz = Scans.me().scanPackage(pk);
            clzs.addAll(clz);
        }
        log.info((Object)("find resource " + clzs.size()));
        ApiDocument doc = new ApiDocument();
        doc.author = context.getAuthor();
        doc.basePath = context.getBasepath();
        doc.title = context.getDocTitle();
        for (Class clz : clzs) {
            if (clz.getAnnotation(Controller.class) == null && clz.getAnnotation(RestController.class) == null) continue;
            this.parseClass(doc, clz);
        }
        return doc;
    }

    private void parseClass(ApiDocument apiDoc, Class<?> clz) {
        Doc doc = clz.getAnnotation(Doc.class);
        if (doc == null) {
            log.debug((Object)("Document " + clz.getName() + " is not annotated with Doc"));
            return;
        }
        String path = doc.group();
        ApiGroup apigroup = apiDoc.findGroup(path);
        this.populateGroup(apigroup, clz);
    }

    private void populateGroup(ApiGroup apiGroup, Class<?> c) {
        Method m;
        int i;
        String[] paths;
        String basepath = "";
        RequestMapping rm = c.getAnnotation(RequestMapping.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            basepath = paths[0];
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            RequestMapping rm1 = m.getAnnotation(RequestMapping.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        for (i = 0; i < list.size(); ++i) {
            m = (Method)list.get(i);
            ApiEntry entry = this.handleMethod(m);
            entry.parent = c;
            if (entry == null) continue;
            entry.relativePath = basepath + entry.relativePath;
            apiGroup.entries.add(entry);
        }
    }

    public ApiDocument toApiDocument(Class<?> c) {
        Method m;
        int i;
        Doc summary;
        String[] paths;
        ApiDocument api = new ApiDocument();
        api.clsName = c.getSimpleName();
        At rm = c.getAnnotation(At.class);
        if (rm != null && (paths = rm.value()) != null && paths.length != 0) {
            api.basePath = paths[0];
        }
        if ((summary = c.getAnnotation(Doc.class)) != null) {
            api.title = summary.value();
            api.author = summary.author();
        }
        Method[] methods = c.getDeclaredMethods();
        ArrayList<Method> list = new ArrayList<Method>();
        for (i = 0; i < methods.length; ++i) {
            m = methods[i];
            At rm1 = m.getAnnotation(At.class);
            if (rm1 == null) continue;
            list.add(m);
        }
        for (i = 0; i < list.size(); ++i) {
            ApiEntry entry;
            m = (Method)list.get(i);
            if (!m.getName().equals("index") && (entry = this.handleMethod(m)) == null) continue;
        }
        return api;
    }

    private ApiEntry handleMethod(Method m) {
        ApiEntry e = new ApiEntry();
        RequestMapping rm = m.getAnnotation(RequestMapping.class);
        if (rm != null) {
            String[] paths = rm.value();
            if (paths != null && paths.length != 0) {
                e.relativePath = paths[0];
            }
            e.invokeMethod = "GET";
            RequestMethod[] ms = rm.method();
            if (ms != null) {
                for (int i = 0; i < ms.length; ++i) {
                    RequestMethod rm0 = ms[i];
                    if (!rm0.equals((Object)RequestMethod.POST)) continue;
                    e.invokeMethod = "POST";
                    break;
                }
            }
        }
        if (e.relativePath.length() == 0) {
            return null;
        }
        e.methodName = m.getName();
        Doc summary = m.getAnnotation(Doc.class);
        if (summary != null) {
            e.name = summary.value();
            e.summary = summary.desc();
            e.order = summary.order();
            e.author = summary.author();
        }
        Class<?>[] ps = m.getParameterTypes();
        Class<?> out = m.getReturnType();
        for (Class<?> clz : ps) {
            ParameterInfo p;
            String name = clz.getSimpleName();
            if (name.startsWith("Http") || (p = SpringParser.handleParameter(clz)) == null) continue;
            e.input.add(p);
        }
        e.output = SpringParser.handleParameter(out);
        return e;
    }
}

