/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.common;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Anchor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.ksyzt.gwt.client.event.HasMessageHandlers;
import com.ksyzt.gwt.client.event.MessageEvent;
import com.ksyzt.gwt.client.event.MessageHandler;
import java.io.Serializable;

public class PageNaviBar
extends HorizontalPanel
implements HasMessageHandlers {
    Anchor first;
    Anchor prev;
    Anchor next;
    Anchor last;
    TextBox txtPage;
    Button btnGo;
    Label lbInfo;
    private ClickHandler m_go_click = new ClickHandler(){

        public void onClick(ClickEvent event) {
            Integer num = Integer.valueOf(PageNaviBar.this.txtPage.getValue());
            if (num >= 1 && num <= PageNaviBar.this.m_pages + 1) {
                PageNaviBar.this.firePage(num - 1);
            }
        }
    };
    private ClickHandler m_first_click = new ClickHandler(){

        public void onClick(ClickEvent event) {
            PageNaviBar.this.firePage(0);
        }
    };
    private ClickHandler m_prev_click = new ClickHandler(){

        public void onClick(ClickEvent event) {
            --PageNaviBar.this.m_currentpage;
            PageNaviBar.this.firePage(PageNaviBar.this.m_currentpage);
        }
    };
    private ClickHandler m_next_click = new ClickHandler(){

        public void onClick(ClickEvent event) {
            ++PageNaviBar.this.m_currentpage;
            PageNaviBar.this.firePage(PageNaviBar.this.m_currentpage);
        }
    };
    private ClickHandler m_last_click = new ClickHandler(){

        public void onClick(ClickEvent event) {
            PageNaviBar.this.m_currentpage = PageNaviBar.this.m_pages - 1;
            PageNaviBar.this.firePage(PageNaviBar.this.m_currentpage);
        }
    };
    int m_currentpage;
    int m_pages;
    int m_pagesize;

    private void firePage(int page) {
        NaviData data = new NaviData(page, this.m_pagesize);
        MessageEvent ev = new MessageEvent(MessageEvent.PAGE, data);
        this.fireEvent(ev);
        this.renderState(page, this.m_pages);
    }

    @UiConstructor
    public PageNaviBar() {
        this.setSpacing(3);
        this.init();
    }

    private void init() {
        this.first = new Anchor("\u9996\u9875");
        this.first.addClickHandler(this.m_first_click);
        this.add((Widget)this.first);
        this.prev = new Anchor("\u4e0a\u4e00\u9875");
        this.prev.addClickHandler(this.m_prev_click);
        this.add((Widget)this.prev);
        this.lbInfo = new Label("/");
        this.lbInfo.setWidth("80px");
        this.add((Widget)this.lbInfo);
        this.setCellHorizontalAlignment((Widget)this.lbInfo, HasHorizontalAlignment.ALIGN_CENTER);
        this.next = new Anchor("\u4e0b\u4e00\u9875");
        this.next.addClickHandler(this.m_next_click);
        this.add((Widget)this.next);
        this.last = new Anchor("\u5c3e\u9875");
        this.last.addClickHandler(this.m_last_click);
        this.add((Widget)this.last);
        this.txtPage = new TextBox();
        this.txtPage.setWidth("40px");
        this.add((Widget)this.txtPage);
        this.btnGo = new Button("Go");
        this.btnGo.addClickHandler(this.m_go_click);
        this.add((Widget)this.btnGo);
        this.first.setEnabled(false);
        this.next.setEnabled(false);
        this.prev.setEnabled(false);
        this.last.setEnabled(false);
        this.btnGo.setEnabled(false);
    }

    @Override
    public HandlerRegistration addMessageHandler(MessageHandler handler) {
        return this.addHandler(handler, MessageEvent.TYPE);
    }

    public void setData(int currentPage, int total, int pagesize) {
        this.m_pagesize = pagesize;
        this.m_currentpage = currentPage;
        int pages = 0;
        this.m_pages = pages = total / pagesize;
        this.renderState(currentPage, pages);
    }

    private void renderState(int currentPage, int pages) {
        if (currentPage >= 0 && currentPage <= pages) {
            this.txtPage.setText(currentPage + 1 + "");
            this.lbInfo.setText(currentPage + 1 + "/" + (pages + 1));
            this.btnGo.setEnabled(true);
            if (currentPage == 0) {
                this.first.setEnabled(false);
            } else {
                this.first.setEnabled(true);
            }
            if (currentPage == pages) {
                this.last.setEnabled(false);
            } else {
                this.last.setEnabled(true);
            }
            if (currentPage < pages) {
                this.next.setEnabled(true);
            } else {
                this.next.setEnabled(false);
            }
            if (currentPage > 0) {
                this.prev.setEnabled(true);
            } else {
                this.prev.setEnabled(false);
            }
        } else {
            this.first.setEnabled(false);
            this.next.setEnabled(false);
            this.prev.setEnabled(false);
            this.last.setEnabled(false);
            this.btnGo.setEnabled(false);
        }
    }

    public class NaviData
    implements Serializable {
        public int page;
        public int size;

        public NaviData(int page, int size) {
            this.page = page;
            this.size = size;
        }
    }
}

