/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.fileupload;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONParser;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FileUpload;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;
import com.ksyzt.gwt.client.common.MessageComposite;
import java.util.Timer;
import java.util.TimerTask;

public class SingleFileUpload
extends MessageComposite {
    private static SingleFileUploadUiBinder uiBinder = (SingleFileUploadUiBinder)GWT.create(SingleFileUploadUiBinder.class);
    @UiField
    FileUpload file;
    @UiField
    FormPanel frmUpload;
    @UiField
    Label lbMessage;
    @UiField
    Label lbTitle;
    @UiField
    Button btnSubmit;
    private ChangeHandler mFileChange = new ChangeHandler(){

        public void onChange(ChangeEvent event) {
            String fn = SingleFileUpload.this.file.getFilename();
            if (fn.equals("")) {
                SingleFileUpload.this.btnSubmit.setEnabled(false);
            } else {
                SingleFileUpload.this.btnSubmit.setEnabled(true);
            }
        }
    };
    private FormPanel.SubmitHandler mSubmitHandler = new FormPanel.SubmitHandler(){

        public void onSubmit(FormPanel.SubmitEvent event) {
        }
    };
    private FormPanel.SubmitCompleteHandler mComplete = new FormPanel.SubmitCompleteHandler(){

        public void onSubmitComplete(FormPanel.SubmitCompleteEvent event) {
        }
    };
    Timer mTimer;

    public SingleFileUpload() {
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.init();
    }

    public void setTitle(String caption) {
        this.lbTitle.setText(caption);
    }

    @Override
    public void message(String msg) {
        this.lbMessage.setText(msg);
    }

    private void enableWatch(boolean b) {
        final String url = GWT.getModuleBaseURL() + "../fileuploader?uploadStatus=true";
        if (b) {
            if (this.mTimer == null) {
                this.mTimer = new Timer();
                this.mTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        RequestBuilder rb = new RequestBuilder(RequestBuilder.POST, url);
                        try {
                            rb.sendRequest("", new RequestCallback(){

                                public void onResponseReceived(Request request, Response response) {
                                    if (response.getStatusCode() == 200) {
                                        String jsonstr = response.getText();
                                        JSONValue rvalue = JSONParser.parse((String)jsonstr);
                                        JSONObject robj = rvalue.isObject();
                                        String error = robj.get("error").isString().stringValue();
                                        String statusMsg = robj.get("statusMsg").isString().stringValue();
                                        String readedBytes = robj.get("readedBytes").isString().stringValue();
                                        String totalBytes = robj.get("totalBytes").isString().stringValue();
                                        String currentItem = robj.get("currentItem").isString().stringValue();
                                        String filePath = robj.get("filePath").isString().stringValue();
                                        SingleFileUpload.this.message("\u4e0a\u4f20\u8fdb\u5ea6\uff1a" + 100.0f * Float.parseFloat(readedBytes) / Float.parseFloat(totalBytes) + "%");
                                    }
                                }

                                public void onError(Request request, Throwable exception) {
                                }
                            });
                        }
                        catch (RequestException e) {
                            e.printStackTrace();
                        }
                    }
                }, 0L, 700L);
            }
        } else if (this.mTimer != null) {
            this.mTimer.cancel();
            this.mTimer = null;
        }
    }

    private void init() {
        this.btnSubmit.setEnabled(false);
        this.file.setName("filename");
        this.file.addChangeHandler(this.mFileChange);
        this.frmUpload.setEncoding("multipart/form-data");
        this.frmUpload.setMethod("post");
        this.frmUpload.setAction(GWT.getModuleBaseURL() + "../fileuploader");
        this.frmUpload.addSubmitHandler(this.mSubmitHandler);
        this.frmUpload.addSubmitCompleteHandler(this.mComplete);
    }

    static interface SingleFileUploadUiBinder
    extends UiBinder<Widget, SingleFileUpload> {
    }
}

