/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.richeditor;

public class Color {
    public static final Color WHITE = new Color(255, 255, 255);
    public static final Color LIGHT_GRAY = new Color(192, 192, 192);
    public static final Color GRAY = new Color(128, 128, 128);
    public static final Color DARK_GRAY = new Color(64, 64, 64);
    public static final Color BLACK = new Color(0, 0, 0);
    public static final Color RED = new Color(255, 0, 0);
    public static final Color PINK = new Color(255, 175, 175);
    public static final Color ORANGE = new Color(255, 200, 0);
    public static final Color YELLOW = new Color(255, 255, 0);
    public static final Color GREEN = new Color(0, 255, 0);
    public static final Color MAGENTA = new Color(255, 0, 255);
    public static final Color CYAN = new Color(0, 255, 255);
    public static final Color BLUE = new Color(0, 0, 255);
    private int r;
    private int g;
    private int b;

    public Color(String hex) {
        int rgb = Integer.decode(hex);
        this.r = (rgb & 0xFF0000) >> 16;
        this.g = (rgb & 0xFF00) >> 8;
        this.b = rgb & 0xFF;
    }

    public Color(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public Color(float h, float s, float l) {
        float q = 0.0f;
        q = l < 0.5f ? l * (s + 1.0f) : l + s - l * s;
        float p = 2.0f * l - q;
        float hk = h / 360.0f;
        float tr = hk + 0.33333334f;
        float tg = hk;
        float tb = hk - 0.33333334f;
        this.r = (int)(this.getComponent(tr, q, p) * 255.0f);
        this.g = (int)(this.getComponent(tg, q, p) * 255.0f);
        this.b = (int)(this.getComponent(tb, q, p) * 255.0f);
    }

    private float getComponent(float tc, float q, float p) {
        if (tc < 0.0f) {
            tc += 1.0f;
        } else if (tc > 1.0f) {
            tc -= 1.0f;
        }
        tc = tc < 0.16666667f ? p + (q - p) * 6.0f * tc : (0.16666667f <= tc && tc < 0.5f ? q : (0.5f <= tc && tc < 0.6666667f ? p + (q - p) * 6.0f * (0.6666667f - tc) : p));
        return tc;
    }

    public int getRed() {
        return this.r;
    }

    public int getGreen() {
        return this.g;
    }

    public int getBlue() {
        return this.b;
    }

    public float getHue() {
        float min;
        float r = (float)this.r / 255.0f;
        float g = (float)this.g / 255.0f;
        float b = (float)this.b / 255.0f;
        float max = this.getMax(r, g, b);
        if (max == (min = this.getMin(r, g, b))) {
            return 0.0f;
        }
        if (max == r) {
            return (60.0f * ((g - b) / max - min) + 360.0f) % 360.0f;
        }
        if (max == g) {
            return 60.0f * ((b - r) / max - min) + 120.0f;
        }
        if (max == b) {
            return 60.0f * ((r - g) / max - min) + 240.0f;
        }
        return 0.0f;
    }

    public float getSaturation() {
        float min;
        float r = (float)this.r / 255.0f;
        float g = (float)this.g / 255.0f;
        float b = (float)this.b / 255.0f;
        float l = this.getLightness();
        float max = this.getMax(r, g, b);
        if (max == (min = this.getMin(r, g, b))) {
            return 0.0f;
        }
        if ((double)l <= 0.5) {
            return (max - min) / (2.0f * l);
        }
        if ((double)l > 0.5) {
            return (max - min) / (2.0f - 2.0f * l);
        }
        return 0.0f;
    }

    public float getLightness() {
        float r = (float)this.r / 255.0f;
        float g = (float)this.g / 255.0f;
        float b = (float)this.b / 255.0f;
        return (this.getMax(r, g, b) + this.getMin(r, g, b)) / 2.0f;
    }

    private float getMax(float r, float g, float b) {
        return r > g ? (r > b ? r : b) : (g > b ? g : b);
    }

    private float getMin(float r, float g, float b) {
        return r < g ? (r < b ? r : b) : (g < b ? g : b);
    }

    private String pad(String in) {
        if (in.length() == 0) {
            return "00";
        }
        if (in.length() == 1) {
            return "0" + in;
        }
        return in;
    }

    public String toString() {
        return "#" + this.pad(Integer.toHexString(this.r)) + this.pad(Integer.toHexString(this.g)) + this.pad(Integer.toHexString(this.b));
    }
}

