/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.richeditor;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.FocusEvent;
import com.google.gwt.event.dom.client.FocusHandler;
import com.google.gwt.event.dom.client.KeyDownEvent;
import com.google.gwt.event.dom.client.KeyDownHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.UIObject;
import com.ksyzt.gwt.client.event.HasMessageHandlers;
import com.ksyzt.gwt.client.event.MessageEvent;
import com.ksyzt.gwt.client.event.MessageHandler;
import com.ksyzt.gwt.client.ui.richeditor.Color;
import com.ksyzt.gwt.client.ui.richeditor.ColorPopup;

public class ColorLabel
extends TextBox
implements HasMessageHandlers {
    private ColorPopup popup;
    private MessageHandler m_color_event = new MessageHandler(){

        @Override
        public void onMessage(Object sender, Integer message, Object value) {
            if (message == MessageEvent.COLORS) {
                String[] colors = (String[])value;
                ColorLabel.this.setValue(colors[0]);
                MessageEvent ev = new MessageEvent(MessageEvent.COLOR, colors[0]);
                ColorLabel.this.fireEvent(ev);
            }
        }
    };

    public ColorLabel() {
        this.popup = new ColorPopup();
        this.setValue("#ffffff");
        this.popup.addMessageHandler(this.m_color_event);
        this.addFocusHandler(new FocusHandler(){

            public void onFocus(FocusEvent event) {
                ColorLabel.this.popup.setHex(ColorLabel.this.getText());
                ColorLabel.this.popup.setAutoHideEnabled(true);
                ColorLabel.this.popup.setPopupPosition(ColorLabel.this.getAbsoluteLeft() + 10, ColorLabel.this.getAbsoluteTop() + 10);
                ColorLabel.this.popup.showRelativeTo((UIObject)ColorLabel.this);
            }
        });
        this.addKeyDownHandler(new KeyDownHandler(){

            public void onKeyDown(KeyDownEvent event) {
                String color = ColorLabel.this.getValue();
                if (color.length() > 1) {
                    MessageEvent ev = new MessageEvent(MessageEvent.COLOR, color);
                    ColorLabel.this.fireEvent(ev);
                }
            }
        });
    }

    @Override
    public HandlerRegistration addMessageHandler(MessageHandler handler) {
        return this.addHandler(handler, MessageEvent.TYPE);
    }

    public void setValue(String value) {
        Style style = this.getElement().getStyle();
        style.setBackgroundColor(value);
        Color color = new Color(value);
        style.setColor((double)color.getLightness() < 0.5 ? "#ffffff" : "#000000");
        super.setValue((Object)value);
    }
}

