/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.richeditor;

import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.event.dom.client.MouseDownEvent;
import com.google.gwt.event.dom.client.MouseDownHandler;
import com.google.gwt.event.dom.client.MouseMoveEvent;
import com.google.gwt.event.dom.client.MouseMoveHandler;
import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.event.dom.client.MouseUpEvent;
import com.google.gwt.event.dom.client.MouseUpHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import com.ksyzt.gwt.client.common.SysResource;
import com.ksyzt.gwt.client.event.HasMessageHandlers;
import com.ksyzt.gwt.client.event.MessageEvent;
import com.ksyzt.gwt.client.event.MessageHandler;
import com.ksyzt.gwt.client.ui.richeditor.Color;

public class ColorPopup
extends PopupPanel
implements HasMessageHandlers {
    private FlowPanel panel = new FlowPanel();
    private Image hueSaturation = new Image(SysResource.INSTANCE.hueSaturation());
    private Image lightness = new Image(SysResource.INSTANCE.lightness());
    private Label preview = new Label();
    private boolean down = false;
    float h = 200.0f;
    float s = 0.6666667f;
    float l = 0.33333334f;

    ColorPopup() {
        super(true);
        this.panel.setSize("220px", "100px");
        this.preview.setSize("20px", "100px");
        this.panel.add((Widget)this.hueSaturation);
        this.panel.add((Widget)this.lightness);
        this.panel.add((Widget)this.preview);
        this.setWidget((Widget)this.panel);
        this.addStyleName("fp-cp");
        DOM.setStyleAttribute((Element)this.hueSaturation.getElement(), (String)"cursor", (String)"crosshair");
        DOM.setStyleAttribute((Element)this.lightness.getElement(), (String)"cursor", (String)"ns-resize");
        DOM.setStyleAttribute((Element)this.preview.getElement(), (String)"float", (String)"right");
        DOM.setStyleAttribute((Element)this.preview.getElement(), (String)"cssFloat", (String)"right");
        DOM.setStyleAttribute((Element)this.preview.getElement(), (String)"styleFloat", (String)"right");
        this.setColor();
        this.hueSaturation.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.preventDefault();
                ColorPopup.this.setHueSaturation(event.getNativeEvent());
                ColorPopup.this.down = true;
            }
        });
        this.hueSaturation.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ColorPopup.this.setHueSaturation(event.getNativeEvent());
                ColorPopup.this.down = false;
            }
        });
        this.hueSaturation.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (ColorPopup.this.down) {
                    ColorPopup.this.setHueSaturation(event.getNativeEvent());
                }
            }
        });
        this.hueSaturation.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                ColorPopup.this.down = false;
            }
        });
        this.lightness.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                event.preventDefault();
                ColorPopup.this.setLightness(event.getNativeEvent());
                ColorPopup.this.down = true;
            }
        });
        this.lightness.addMouseUpHandler(new MouseUpHandler(){

            public void onMouseUp(MouseUpEvent event) {
                ColorPopup.this.setLightness(event.getNativeEvent());
                ColorPopup.this.down = false;
            }
        });
        this.lightness.addMouseMoveHandler(new MouseMoveHandler(){

            public void onMouseMove(MouseMoveEvent event) {
                if (ColorPopup.this.down) {
                    ColorPopup.this.setLightness(event.getNativeEvent());
                }
            }
        });
        this.lightness.addMouseOutHandler(new MouseOutHandler(){

            public void onMouseOut(MouseOutEvent event) {
                ColorPopup.this.down = false;
            }
        });
        this.preview.addMouseDownHandler(new MouseDownHandler(){

            public void onMouseDown(MouseDownEvent event) {
                String c = ColorPopup.this.getHex();
                String[] colors = new String[]{c, ColorPopup.this.getTextColor()};
                MessageEvent ev = new MessageEvent(MessageEvent.COLORS, colors);
                ColorPopup.this.fireEvent(ev);
                ColorPopup.this.hide();
            }
        });
    }

    public String getHex() {
        return new Color(this.h, this.s, this.l).toString();
    }

    public void setHex(String colorString) {
        if (colorString.startsWith("#") && colorString.length() == 7) {
            Color rgb = new Color(colorString);
            this.h = rgb.getHue();
            this.s = rgb.getSaturation();
            this.l = rgb.getLightness();
            this.setColor();
        }
    }

    public String getTextColor() {
        if ((double)this.l < 0.5) {
            return "#ffffff";
        }
        return "#000000";
    }

    private void setColor() {
        Color p = new Color(this.h, this.s, this.l);
        DOM.setStyleAttribute((Element)this.preview.getElement(), (String)"backgroundColor", (String)p.toString());
        Color l = new Color(this.h, this.s, 0.5f);
        DOM.setStyleAttribute((Element)this.lightness.getElement(), (String)"backgroundColor", (String)l.toString());
    }

    private void setHueSaturation(NativeEvent event) {
        int x = event.getClientX() - this.hueSaturation.getAbsoluteLeft();
        int y = event.getClientY() - this.hueSaturation.getAbsoluteTop();
        if (x > -1 && x < 181 && y > -1 && y < 101) {
            this.h = x * 2;
            this.s = (float)(100 - y) / 100.0f;
            this.setColor();
        } else {
            this.down = false;
        }
    }

    private void setLightness(NativeEvent event) {
        int y = event.getClientY() - this.lightness.getAbsoluteTop();
        if (y > -1 && y < 101) {
            this.l = (float)(100 - y) / 100.0f;
            this.setColor();
        } else {
            this.down = false;
        }
    }

    @Override
    public HandlerRegistration addMessageHandler(MessageHandler handler) {
        return this.addHandler(handler, MessageEvent.TYPE);
    }
}

