/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.richeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JsArrayString;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ToggleButton;
import com.google.gwt.user.client.ui.UIObject;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.ksyzt.gwt.client.event.MessageEvent;
import com.ksyzt.gwt.client.event.MessageHandler;
import com.ksyzt.gwt.client.ui.richeditor.ColorLabel;
import com.ksyzt.gwt.client.ui.richeditor.ImageUploadPanel;
import java.util.HashMap;

public class RichTextToolbar
extends Composite {
    ImageUploadPanel m_dlg_image;
    HTMLPanel m_ap_shadow;
    HTMLPanel m_ap_content;
    HTMLPanel m_ap_line;
    boolean m_b_show_popup = false;
    Widget back_widget;
    String back_css;
    PopupPanel m_popup;
    public static final String HTTP_STATIC_ICONS_GIF = GWT.getModuleBaseURL() + "../images/toolbars.gif";
    private static final String CSS_ROOT_NAME = "RichTextToolbar";
    public static final HashMap<String, String> GUI_COLORLIST = new HashMap();
    public static final HashMap<String, String> GUI_FONTLIST;
    private static final String HTML_STYLE_CLOSE_SPAN = "</span>";
    private static final String HTML_STYLE_CLOSE_DIV = "</div>";
    private static final String HTML_STYLE_OPEN_BOLD = "<span style=\"font-weight: bold;\">";
    private static final String HTML_STYLE_OPEN_ITALIC = "<span style=\"font-weight: italic;\">";
    private static final String HTML_STYLE_OPEN_UNDERLINE = "<span style=\"font-weight: underline;\">";
    private static final String HTML_STYLE_OPEN_LINETHROUGH = "<span style=\"font-weight: line-through;\">";
    private static final String HTML_STYLE_OPEN_ALIGNLEFT = "<div style=\"text-align: left;\">";
    private static final String HTML_STYLE_OPEN_ALIGNCENTER = "<div style=\"text-align: center;\">";
    private static final String HTML_STYLE_OPEN_ALIGNRIGHT = "<div style=\"text-align: right;\">";
    private static final String HTML_STYLE_OPEN_INDENTRIGHT = "<div style=\"margin-left: 40px;\">";
    private static final String HTML_STYLE_OPEN_SUBSCRIPT = "<sub>";
    private static final String HTML_STYLE_CLOSE_SUBSCRIPT = "</sub>";
    private static final String HTML_STYLE_OPEN_SUPERSCRIPT = "<sup>";
    private static final String HTML_STYLE_CLOSE_SUPERSCRIPT = "</sup>";
    private static final String HTML_STYLE_OPEN_ORDERLIST = "<ol><li>";
    private static final String HTML_STYLE_CLOSE_ORDERLIST = "</ol></li>";
    private static final String HTML_STYLE_OPEN_UNORDERLIST = "<ul><li>";
    private static final String HTML_STYLE_CLOSE_UNORDERLIST = "</ul></li>";
    private static final String HTML_STYLE_HLINE = "<hr style=\"width: 100%; height: 2px;\">";
    private static final String GUI_DIALOG_INSERTURL = "Enter a link URL:";
    private static final String GUI_DIALOG_IMAGEURL = "Enter an image URL:";
    private static final String GUI_LISTNAME_COLORS = "Colors";
    private static final String GUI_LISTNAME_FONTS = "Fonts";
    private static final String GUI_HOVERTEXT_SWITCHVIEW = "Switch View HTML/Source";
    private static final String GUI_HOVERTEXT_REMOVEFORMAT = "Remove Formatting";
    private static final String GUI_HOVERTEXT_IMAGE = "Insert Image";
    private static final String GUI_HOVERTEXT_HLINE = "Insert Horizontal Line";
    private static final String GUI_HOVERTEXT_BREAKLINK = "Break Link";
    private static final String GUI_HOVERTEXT_LINK = "Generate Link";
    private static final String GUI_HOVERTEXT_IDENTLEFT = "Ident Left";
    private static final String GUI_HOVERTEXT_IDENTRIGHT = "Ident Right";
    private static final String GUI_HOVERTEXT_UNORDERLIST = "Unordered List";
    private static final String GUI_HOVERTEXT_ORDERLIST = "Ordered List";
    private static final String GUI_HOVERTEXT_ALIGNRIGHT = "Align Right";
    private static final String GUI_HOVERTEXT_ALIGNCENTER = "Align Center";
    private static final String GUI_HOVERTEXT_ALIGNLEFT = "Align Left";
    private static final String GUI_HOVERTEXT_SUPERSCRIPT = "Superscript";
    private static final String GUI_HOVERTEXT_SUBSCRIPT = "Subscript";
    private static final String GUI_HOVERTEXT_STROKE = "Stroke";
    private static final String GUI_HOVERTEXT_UNDERLINE = "Underline";
    private static final String GUI_HOVERTEXT_ITALIC = "Italic";
    private static final String GUI_HOVERTEXT_BOLD = "Bold";
    private VerticalPanel outer;
    private HorizontalPanel topPanel;
    private HorizontalPanel bottomPanel;
    private RichTextArea styleText;
    private RichTextArea.Formatter styleTextFormatter;
    private EventHandler evHandler;
    private ToggleButton bold;
    private ToggleButton italic;
    private ToggleButton underline;
    private ToggleButton stroke;
    private ToggleButton subscript;
    private ToggleButton superscript;
    private PushButton alignleft;
    private PushButton alignmiddle;
    private PushButton alignright;
    private PushButton orderlist;
    private PushButton unorderlist;
    private PushButton indentleft;
    private PushButton indentright;
    private PushButton generatelink;
    private PushButton breaklink;
    private PushButton insertline;
    private PushButton insertimage;
    private PushButton removeformatting;
    private ToggleButton texthtml;
    private ListBox fontlist;
    private ColorLabel colorlist;
    private MessageHandler m_image_dlg_handler = new MessageHandler(){

        @Override
        public void onMessage(Object sender, Integer message, Object value) {
            if (MessageEvent.CANCEL.equals(message)) {
                RichTextToolbar.this.m_popup.hide(true);
            } else if (MessageEvent.OK.equals(message)) {
                String url = (String)value;
                if (!url.equals("")) {
                    if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                        RichTextToolbar.this.changeHtmlStyle(url, "");
                    } else {
                        RichTextToolbar.this.styleTextFormatter.insertHTML(url);
                    }
                }
                RichTextToolbar.this.m_popup.hide(true);
            }
        }
    };
    private MessageHandler m_color_handler = new MessageHandler(){

        @Override
        public void onMessage(Object sender, Integer message, Object value) {
            if (message == MessageEvent.COLOR) {
                String c = (String)value;
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle("<span style=\"color: " + c + ";\">", RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setForeColor(c);
                }
            }
        }
    };

    private void showPopup(Widget attacheElement, Widget w) {
        this.back_widget = attacheElement;
        if (w == null) {
            w = new HTMLPanel("");
            w.setSize("100px", "100px");
            this.m_ap_content.clear();
            this.m_ap_content.add(w);
        } else {
            this.m_ap_content.clear();
            this.m_ap_content.add(w);
        }
        this.m_ap_content.setVisible(true);
        this.m_ap_shadow.setVisible(true);
        this.m_ap_line.setVisible(true);
        int aleft = attacheElement.getAbsoluteLeft();
        int atop = attacheElement.getAbsoluteTop();
        int aw = attacheElement.getOffsetWidth();
        int ah = attacheElement.getOffsetHeight();
        int width = this.m_ap_content.getOffsetWidth();
        int height = this.m_ap_content.getOffsetHeight();
        int lbx = aleft;
        int lby = atop + ah;
        int rbx = lbx + aw;
        int rby = lby;
        Style style = this.m_ap_content.getElement().getStyle();
        style.setLeft((double)(rbx - width), Style.Unit.PX);
        style.setTop((double)(lby - 1), Style.Unit.PX);
        style = this.m_ap_shadow.getElement().getStyle();
        style.setLeft((double)(rbx - width + 3), Style.Unit.PX);
        style.setTop((double)(lby + 2), Style.Unit.PX);
        style.setWidth((double)width, Style.Unit.PX);
        style.setHeight((double)height, Style.Unit.PX);
        style = this.m_ap_line.getElement().getStyle();
        style.setLeft((double)(lbx + 1), Style.Unit.PX);
        style.setTop((double)(lby - 1), Style.Unit.PX);
        style.setWidth((double)(aw - 2), Style.Unit.PX);
        this.back_css = attacheElement.getStyleName();
        attacheElement.setStyleName("toolbar_over");
        this.m_ap_content.getElement().focus();
        this.m_b_show_popup = true;
    }

    public void hidePopup() {
        this.m_ap_content.setVisible(false);
        this.m_ap_shadow.setVisible(false);
        this.m_ap_line.setVisible(false);
        if (this.back_widget != null) {
            this.m_b_show_popup = false;
            this.back_widget.setStyleName(this.back_css);
        }
    }

    private void initPopupPanel() {
        this.m_ap_shadow = new HTMLPanel("div", "");
        this.m_ap_content = new HTMLPanel("div", "");
        this.m_ap_line = new HTMLPanel("div", "");
        Style style = this.m_ap_content.getElement().getStyle();
        style.setProperty("border", "solid 1px skyblue");
        style.setBackgroundColor("white");
        style.setPadding(5.0, Style.Unit.PX);
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(1000000);
        style = this.m_ap_shadow.getElement().getStyle();
        style.setBackgroundColor("#f0f0f0");
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(999999);
        this.m_ap_line.setHeight("1px");
        style = this.m_ap_line.getElement().getStyle();
        style.setBackgroundColor("white");
        style.setPosition(Style.Position.ABSOLUTE);
        style.setZIndex(1000001);
        RootPanel.get().add((Widget)this.m_ap_shadow);
        RootPanel.get().add((Widget)this.m_ap_content);
        RootPanel.get().add((Widget)this.m_ap_line);
        this.m_ap_content.setVisible(false);
        this.m_ap_shadow.setVisible(false);
        this.m_ap_line.setVisible(false);
    }

    @UiConstructor
    public RichTextToolbar() {
        this.outer = new VerticalPanel();
        this.topPanel = new HorizontalPanel();
        this.bottomPanel = new HorizontalPanel();
        this.topPanel.setStyleName(CSS_ROOT_NAME);
        this.bottomPanel.setStyleName(CSS_ROOT_NAME);
        this.topPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.bottomPanel.setHorizontalAlignment(HorizontalPanel.ALIGN_LEFT);
        this.outer.add((Widget)this.topPanel);
        this.outer.add((Widget)this.bottomPanel);
        this.outer.setWidth("100%");
        this.outer.setStyleName(CSS_ROOT_NAME);
        this.initWidget((Widget)this.outer);
        this.evHandler = new EventHandler();
        this.buildTools();
        this.initPopupPanel();
    }

    public void setRichTextArea(RichTextArea area) {
        this.styleText = area;
        this.styleTextFormatter = this.styleText.getFormatter();
        this.styleText.addKeyUpHandler((KeyUpHandler)this.evHandler);
        this.styleText.addClickHandler((ClickHandler)this.evHandler);
    }

    public static native JsArrayString getSelection(Element var0);

    private void changeHtmlStyle(String startTag, String stopTag) {
        JsArrayString tx = RichTextToolbar.getSelection((Element)this.styleText.getElement());
        String txbuffer = this.styleText.getText();
        Integer startpos = Integer.parseInt(tx.get(1));
        String selectedText = tx.get(0);
        this.styleText.setText(txbuffer.substring(0, startpos) + startTag + selectedText + stopTag + txbuffer.substring(startpos + selectedText.length()));
    }

    private Boolean isHTMLMode() {
        return this.texthtml.isDown();
    }

    private void updateStatus() {
        if (this.styleTextFormatter != null) {
            this.bold.setDown(this.styleTextFormatter.isBold());
            this.italic.setDown(this.styleTextFormatter.isItalic());
            this.underline.setDown(this.styleTextFormatter.isUnderlined());
            this.subscript.setDown(this.styleTextFormatter.isSubscript());
            this.superscript.setDown(this.styleTextFormatter.isSuperscript());
            this.stroke.setDown(this.styleTextFormatter.isStrikethrough());
        }
        if (this.isHTMLMode().booleanValue()) {
            this.removeformatting.setEnabled(false);
            this.indentleft.setEnabled(false);
            this.breaklink.setEnabled(false);
        } else {
            this.removeformatting.setEnabled(true);
            this.indentleft.setEnabled(true);
            this.breaklink.setEnabled(true);
        }
    }

    private void buildTools() {
        this.bold = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 0, 20, 20, GUI_HOVERTEXT_BOLD);
        this.topPanel.add((Widget)this.bold);
        this.italic = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 60, 20, 20, GUI_HOVERTEXT_ITALIC);
        this.topPanel.add((Widget)this.italic);
        this.underline = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 140, 20, 20, GUI_HOVERTEXT_UNDERLINE);
        this.topPanel.add((Widget)this.underline);
        this.stroke = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 120, 20, 20, GUI_HOVERTEXT_STROKE);
        this.topPanel.add((Widget)this.stroke);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.subscript = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 600, 20, 20, GUI_HOVERTEXT_SUBSCRIPT);
        this.topPanel.add((Widget)this.subscript);
        this.superscript = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 620, 20, 20, GUI_HOVERTEXT_SUPERSCRIPT);
        this.topPanel.add((Widget)this.superscript);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.alignleft = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 460, 20, 20, GUI_HOVERTEXT_ALIGNLEFT);
        this.topPanel.add((Widget)this.alignleft);
        this.alignmiddle = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 420, 20, 20, GUI_HOVERTEXT_ALIGNCENTER);
        this.topPanel.add((Widget)this.alignmiddle);
        this.alignright = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 480, 20, 20, GUI_HOVERTEXT_ALIGNRIGHT);
        this.topPanel.add((Widget)this.alignright);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.orderlist = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 80, 20, 20, GUI_HOVERTEXT_ORDERLIST);
        this.topPanel.add((Widget)this.orderlist);
        this.unorderlist = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 20, 20, 20, GUI_HOVERTEXT_UNORDERLIST);
        this.topPanel.add((Widget)this.unorderlist);
        this.indentright = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 400, 20, 20, GUI_HOVERTEXT_IDENTRIGHT);
        this.topPanel.add((Widget)this.indentright);
        this.indentleft = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 540, 20, 20, GUI_HOVERTEXT_IDENTLEFT);
        this.topPanel.add((Widget)this.indentleft);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.generatelink = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 500, 20, 20, GUI_HOVERTEXT_LINK);
        this.topPanel.add((Widget)this.generatelink);
        this.breaklink = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 640, 20, 20, GUI_HOVERTEXT_BREAKLINK);
        this.topPanel.add((Widget)this.breaklink);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.insertline = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 360, 20, 20, GUI_HOVERTEXT_HLINE);
        this.topPanel.add((Widget)this.insertline);
        this.insertimage = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 380, 20, 20, GUI_HOVERTEXT_IMAGE);
        this.topPanel.add((Widget)this.insertimage);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.removeformatting = this.createPushButton(HTTP_STATIC_ICONS_GIF, 0, 580, 20, 20, GUI_HOVERTEXT_REMOVEFORMAT);
        this.topPanel.add((Widget)this.removeformatting);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.texthtml = this.createToggleButton(HTTP_STATIC_ICONS_GIF, 0, 260, 20, 20, GUI_HOVERTEXT_SWITCHVIEW);
        this.topPanel.add((Widget)this.texthtml);
        this.fontlist = this.createFontList();
        this.topPanel.add((Widget)this.fontlist);
        this.topPanel.add((Widget)new HTML("&nbsp;"));
        this.colorlist = this.createColorList();
        this.topPanel.add((Widget)this.colorlist);
    }

    private ToggleButton createToggleButton(String url, Integer top, Integer left, Integer width, Integer height, String tip) {
        Image extract = new Image(url, left.intValue(), top.intValue(), width.intValue(), height.intValue());
        ToggleButton tb = new ToggleButton(extract);
        tb.setStyleName("ksyzt-ToogleButton");
        tb.setHeight(height + "px");
        tb.setWidth(width + "px");
        tb.addClickHandler((ClickHandler)this.evHandler);
        if (tip != null) {
            tb.setTitle(tip);
        }
        return tb;
    }

    private PushButton createPushButton(String url, Integer top, Integer left, Integer width, Integer height, String tip) {
        Image extract = new Image(url, left.intValue(), top.intValue(), width.intValue(), height.intValue());
        PushButton tb = new PushButton(extract);
        tb.setStyleName("ksyzt-PushButton");
        tb.setHeight(height + "px");
        tb.setWidth(width + "px");
        tb.addClickHandler((ClickHandler)this.evHandler);
        if (tip != null) {
            tb.setTitle(tip);
        }
        return tb;
    }

    private ListBox createFontList() {
        ListBox mylistBox = new ListBox();
        mylistBox.addChangeHandler((ChangeHandler)this.evHandler);
        mylistBox.setVisibleItemCount(1);
        mylistBox.addItem(GUI_LISTNAME_FONTS);
        for (String name : GUI_FONTLIST.keySet()) {
            mylistBox.addItem(name, GUI_FONTLIST.get(name));
        }
        return mylistBox;
    }

    private ColorLabel createColorList() {
        this.colorlist = new ColorLabel();
        Style style = this.colorlist.getElement().getStyle();
        style.setDisplay(Style.Display.BLOCK);
        style.setPropertyPx("lineHeight", 14);
        style.setCursor(Style.Cursor.POINTER);
        this.colorlist.setWidth("60px");
        this.colorlist.addMessageHandler(this.m_color_handler);
        return this.colorlist;
    }

    static {
        GUI_COLORLIST.put("White", "#FFFFFF");
        GUI_COLORLIST.put("Black", "#000000");
        GUI_COLORLIST.put("Red", "red");
        GUI_COLORLIST.put("Green", "green");
        GUI_COLORLIST.put("Yellow", "yellow");
        GUI_COLORLIST.put("Blue", "blue");
        GUI_FONTLIST = new HashMap();
        GUI_FONTLIST.put("Times New Roman", "Times New Roman");
        GUI_FONTLIST.put("Arial", "Arial");
        GUI_FONTLIST.put("Courier New", "Courier New");
        GUI_FONTLIST.put("Georgia", "Georgia");
        GUI_FONTLIST.put("Trebuchet", "Trebuchet");
        GUI_FONTLIST.put("Verdana", "Verdana");
    }

    private class EventHandler
    implements ClickHandler,
    KeyUpHandler,
    ChangeHandler {
        private EventHandler() {
        }

        public void onClick(ClickEvent event) {
            if (event.getSource().equals(RichTextToolbar.this.bold)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_BOLD, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleBold();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.italic)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ITALIC, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleItalic();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.underline)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_UNDERLINE, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleUnderline();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.stroke)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_LINETHROUGH, RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleStrikethrough();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.subscript)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_SUBSCRIPT, RichTextToolbar.HTML_STYLE_CLOSE_SUBSCRIPT);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleSubscript();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.superscript)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_SUPERSCRIPT, RichTextToolbar.HTML_STYLE_CLOSE_SUPERSCRIPT);
                } else {
                    RichTextToolbar.this.styleTextFormatter.toggleSuperscript();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignleft)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNLEFT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.LEFT);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignmiddle)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNCENTER, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.CENTER);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.alignright)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ALIGNRIGHT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setJustification(RichTextArea.Justification.RIGHT);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.orderlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_ORDERLIST, RichTextToolbar.HTML_STYLE_CLOSE_ORDERLIST);
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertOrderedList();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.unorderlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_UNORDERLIST, RichTextToolbar.HTML_STYLE_CLOSE_UNORDERLIST);
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertUnorderedList();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.indentright)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_OPEN_INDENTRIGHT, RichTextToolbar.HTML_STYLE_CLOSE_DIV);
                } else {
                    RichTextToolbar.this.styleTextFormatter.rightIndent();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.indentleft)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.leftIndent();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.generatelink)) {
                String url = Window.prompt((String)RichTextToolbar.GUI_DIALOG_INSERTURL, (String)"http://");
                if (url != null) {
                    if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                        RichTextToolbar.this.changeHtmlStyle("<a href=\"" + url + "\">", "</a>");
                    } else {
                        RichTextToolbar.this.styleTextFormatter.createLink(url);
                    }
                }
            } else if (event.getSource().equals(RichTextToolbar.this.breaklink)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.removeLink();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.insertimage)) {
                Widget w = (Widget)event.getSource();
                RichTextToolbar.this.m_popup = new PopupPanel(true);
                if (!RichTextToolbar.this.m_b_show_popup) {
                    if (RichTextToolbar.this.m_dlg_image == null) {
                        RichTextToolbar.this.m_dlg_image = new ImageUploadPanel();
                        RichTextToolbar.this.m_dlg_image.addMessageHandler(RichTextToolbar.this.m_image_dlg_handler);
                    }
                    RichTextToolbar.this.m_popup.add((Widget)RichTextToolbar.this.m_dlg_image);
                    RichTextToolbar.this.m_popup.showRelativeTo((UIObject)w);
                } else {
                    RichTextToolbar.this.m_popup.hide(true);
                }
            } else if (event.getSource().equals(RichTextToolbar.this.insertline)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle(RichTextToolbar.HTML_STYLE_HLINE, "");
                } else {
                    RichTextToolbar.this.styleTextFormatter.insertHorizontalRule();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.removeformatting)) {
                if (!RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.styleTextFormatter.removeFormat();
                }
            } else if (event.getSource().equals(RichTextToolbar.this.texthtml)) {
                if (RichTextToolbar.this.texthtml.isDown()) {
                    RichTextToolbar.this.styleText.setText(RichTextToolbar.this.styleText.getHTML());
                } else {
                    RichTextToolbar.this.styleText.setHTML(RichTextToolbar.this.styleText.getText());
                }
            } else if (event.getSource().equals(RichTextToolbar.this.styleText)) {
                // empty if block
            }
            RichTextToolbar.this.updateStatus();
        }

        public void onKeyUp(KeyUpEvent event) {
            RichTextToolbar.this.updateStatus();
        }

        public void onChange(ChangeEvent event) {
            if (event.getSource().equals(RichTextToolbar.this.fontlist)) {
                if (RichTextToolbar.this.isHTMLMode().booleanValue()) {
                    RichTextToolbar.this.changeHtmlStyle("<span style=\"font-family: " + RichTextToolbar.this.fontlist.getValue(RichTextToolbar.this.fontlist.getSelectedIndex()) + ";\">", RichTextToolbar.HTML_STYLE_CLOSE_SPAN);
                } else {
                    RichTextToolbar.this.styleTextFormatter.setFontName(RichTextToolbar.this.fontlist.getValue(RichTextToolbar.this.fontlist.getSelectedIndex()));
                }
            }
        }
    }
}

