/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.client.ui.richeditor;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.uibinder.client.UiConstructor;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.Widget;
import com.ksyzt.gwt.client.event.HasMessageHandlers;
import com.ksyzt.gwt.client.event.MessageEvent;
import com.ksyzt.gwt.client.event.MessageHandler;
import com.ksyzt.gwt.client.ui.richeditor.RichEditor;

public class SimpleClickEditor
extends FlowPanel
implements HasMessageHandlers {
    private static SimpleClickEditor currentEditor;
    HTML htmlPanel;
    private static TextArea txtBox;
    private static RichEditor txtRich;
    private Button btnToggle;
    private Button btnConfirm;
    private HorizontalPanel tools;
    private int mMinWidth;
    private int mMinHeight;
    private ClickHandler btnConfirmHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            event.stopPropagation();
            SimpleClickEditor.this.hideTxtBox();
            SimpleClickEditor.this.hideTxtRich();
            SimpleClickEditor.this.tools.setVisible(false);
        }
    };
    private Object m_userObject = null;
    HandlerRegistration comfirmReg = null;
    HandlerRegistration toggleReg = null;
    private ClickHandler mHtmlPanelClick = new ClickHandler(){

        public void onClick(ClickEvent event) {
            SimpleClickEditor.this.mWidth = SimpleClickEditor.this.htmlPanel.getOffsetWidth();
            SimpleClickEditor.this.mHeight = SimpleClickEditor.this.htmlPanel.getOffsetHeight();
            if (currentEditor != null) {
                currentEditor.canvasMode();
            }
            if (SimpleClickEditor.this.m_enabledEdit) {
                currentEditor = SimpleClickEditor.this;
                SimpleClickEditor.this.textEditMode();
            } else {
                currentEditor = null;
            }
        }
    };
    private ClickHandler btnToggleHandler = new ClickHandler(){

        public void onClick(ClickEvent event) {
            event.stopPropagation();
            if (SimpleClickEditor.this.btnToggle.getText().equals(SimpleClickEditor.EDIT_HTML)) {
                SimpleClickEditor.this.hideTxtBox();
                SimpleClickEditor.this.htmlEditMode();
            } else {
                SimpleClickEditor.log("text mode");
                SimpleClickEditor.this.hideTxtRich();
                SimpleClickEditor.this.textEditMode();
                txtBox.setFocus(true);
            }
        }
    };
    boolean m_bToggleClick = false;
    private static final String EDIT_HTML = "\u7f16\u8f91HTML";
    private static final String EDIT_TEXT = "\u7f16\u8f91\u6587\u672c";
    private static final String EDIT_CONFITM = "\u786e\u5b9a";
    int mWidth;
    int mHeight;
    private String tip = "\u70b9\u51fb\u7f16\u8f91...";
    String m_style = "";
    private boolean m_enabledEdit = true;
    boolean mbEnableHtml = true;
    private String mToogleStyleName = "toogleButton";

    @Override
    public HandlerRegistration addMessageHandler(MessageHandler handler) {
        return this.addHandler(handler, MessageEvent.TYPE);
    }

    public void setMinWidth(int w) {
        this.mMinWidth = w;
    }

    public void setMinHeight(int h) {
        this.mMinHeight = h;
    }

    @UiConstructor
    public SimpleClickEditor() {
        this.htmlPanel = new HTML();
        this.getElement().getStyle().setPosition(Style.Position.RELATIVE);
        this.add((Widget)this.htmlPanel);
        this.htmlPanel.addClickHandler(this.mHtmlPanelClick);
        this.tools = new HorizontalPanel();
        this.btnToggle = new Button(EDIT_HTML);
        this.btnConfirm = new Button(EDIT_CONFITM);
        this.tools.add((Widget)this.btnToggle);
        this.tools.add((Widget)this.btnConfirm);
        this.btnConfirm.setStyleName(this.mToogleStyleName);
        this.btnToggle.setStyleName(this.mToogleStyleName);
        this.comfirmReg = this.btnConfirm.addClickHandler(this.btnConfirmHandler);
        this.toggleReg = this.btnToggle.addClickHandler(this.btnToggleHandler);
        this.btnToggle.setVisible(this.mbEnableHtml);
        Style style = this.tools.getElement().getStyle();
        style.setPosition(Style.Position.ABSOLUTE);
        style.setLeft(0.0, Style.Unit.PX);
        style.setTop(-24.0, Style.Unit.PX);
        this.btnToggle.getElement().getStyle().setLineHeight(18.0, Style.Unit.PX);
        this.btnConfirm.getElement().getStyle().setLineHeight(18.0, Style.Unit.PX);
        this.add((Widget)this.tools);
        this.tools.setVisible(false);
    }

    public void setUserObject(Object obj) {
        this.m_userObject = obj;
    }

    public Object getUserObject() {
        return this.m_userObject;
    }

    private void htmlEditMode() {
        this.sureRichBox();
        this.tools.setVisible(true);
        this.btnToggle.setText(EDIT_TEXT);
        String str = this.getValue();
        if (str.equals(this.tip)) {
            str = "";
        }
        txtRich.setHTML(this.toHtmlValue(str));
        this.htmlPanel.setVisible(false);
        txtRich.setVisible(true);
    }

    private String toTextValue(String str) {
        str = str.replaceAll("<[bB]{1,1}[rR]{1,1}\\s*>", "\n");
        str = str.replaceAll(">", "&gt;");
        str = str.replaceAll("<", "&lt;");
        return str;
    }

    private void textEditMode() {
        this.tools.setVisible(true);
        this.hideTxtRich();
        this.sureTextBox();
        String str = this.getValue();
        if (str.equals(this.tip)) {
            str = "";
        }
        str = this.toTextValue(str);
        txtBox.setValue((Object)str);
        this.htmlPanel.setVisible(false);
        txtBox.setVisible(true);
        if (this.mbEnableHtml) {
            this.btnToggle.setVisible(true);
            this.btnToggle.setText(EDIT_HTML);
        } else {
            this.btnToggle.setVisible(false);
        }
        txtBox.setFocus(true);
    }

    public void canvasMode() {
        this.hideTxtBox();
        this.hideTxtRich();
        this.tools.setVisible(false);
        MessageEvent ev = new MessageEvent(MessageEvent.VALUECHANGE, this.getValue());
        this.fireEvent(ev);
    }

    private void hideTxtRich() {
        if (txtRich != null && txtRich.isAttached() && txtRich.isVisible() && currentEditor != null) {
            String html = txtRich.getHTML();
            SimpleClickEditor.currentEditor.htmlPanel.setVisible(true);
            txtRich.setVisible(false);
            currentEditor.setValue(html);
        }
    }

    private void hideTxtBox() {
        if (txtBox != null && txtBox.isAttached() && txtBox.isVisible() && currentEditor != null) {
            String text = txtBox.getValue();
            String html = this.toHtmlValue(text);
            SimpleClickEditor.currentEditor.htmlPanel.setVisible(true);
            txtBox.setVisible(false);
            currentEditor.setValue(html);
        }
    }

    private String toHtmlValue(String text) {
        text = text.replaceAll("&lt;", "<");
        text = text.replaceAll("&gt;", ">");
        text = text.replaceAll("\n", "<br/>");
        return text;
    }

    private static final native void log(String var0);

    private void sureTextBox() {
        if (txtBox == null) {
            txtBox = new TextArea();
            if (!this.m_style.equals("")) {
                txtBox.setStyleName(this.m_style);
            }
        }
        if (txtBox.isAttached()) {
            txtBox.removeFromParent();
        }
        if (this.mMinWidth >= 0) {
            this.mWidth = Math.max(this.mWidth, this.mMinWidth);
        }
        txtBox.setWidth(this.mWidth + "px");
        if (this.mMinHeight >= 0) {
            this.mHeight = Math.max(this.mHeight, this.mMinHeight);
        }
        txtBox.setHeight(this.mHeight + "px");
        this.add((Widget)txtBox);
    }

    private void sureRichBox() {
        if (txtRich == null) {
            txtRich = new RichEditor();
        }
        if (txtRich.isAttached()) {
            txtRich.removeFromParent();
        }
        if (this.mMinWidth >= 0) {
            this.mWidth = Math.max(this.mWidth, this.mMinWidth);
        }
        txtRich.setWidth(this.mWidth + "px");
        if (this.mMinHeight >= 0) {
            this.mHeight = Math.max(this.mHeight, this.mMinHeight);
        }
        txtRich.setHeight(this.mHeight + "px");
        this.add((Widget)txtRich);
    }

    public String getValue() {
        String html = this.htmlPanel.getHTML();
        if (html.equals(this.tip)) {
            return "";
        }
        return this.toTextValue(html);
    }

    public String getHtml() {
        String html = this.htmlPanel.getHTML();
        if (html.equals(this.tip)) {
            return "";
        }
        return html;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    public void setValue(String text) {
        SimpleClickEditor.log(text);
        if (text == null || text.equals("")) {
            text = this.tip;
        }
        String html = this.toHtmlValue(text);
        this.htmlPanel.setHTML(html);
    }

    public void setHtml(String html) {
        if (html == null || html.equals("")) {
            html = this.tip;
        }
        this.htmlPanel.setHTML(html);
    }

    public void setTextBoxStyle(String editstyle) {
        this.m_style = editstyle;
    }

    public void setEnableEdit(boolean v) {
        this.m_enabledEdit = v;
    }

    public void setEnableHTML(boolean b) {
        this.mbEnableHtml = b;
    }

    public void setToggleStyle(String styleName) {
        this.mToogleStyleName = styleName;
        if (this.tools != null) {
            this.btnToggle.setStyleName(this.mToogleStyleName);
            this.btnConfirm.setStyleName(this.mToogleStyleName);
        }
    }
}

