/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import com.ksyzt.gwt.client.site.urlrewrite.RewriteData;
import com.ksyzt.gwt.server.common.Util;
import com.ksyzt.gwt.server.listener.KsyztServer;
import com.ksyzt.gwt.shared.exception.AdminLoginException;
import com.ksyzt.gwt.shared.module.AdminUser;
import com.ksyzt.gwt.shared.module.SiteInformation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.nutz.json.Json;
import org.nutz.lang.Streams;

public class SiteUtil {
    private static String tag = "SiteUtil";
    public HttpServletRequest request;
    public HttpServletResponse response;

    public static void main(String[] args) throws Exception {
    }

    public SiteUtil(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public static String getSiteInfoFile(ServletContext context) {
        return SiteUtil.getWebInfoPath(context) + "site.json";
    }

    public static SiteInformation getFromMemory(ServletContext context, boolean reload) {
        SiteInformation info = KsyztServer.SITEINFO;
        if (info != null) {
            return info;
        }
        File f = new File(SiteUtil.getSiteInfoFile(context));
        KsyztServer.SITEINFO = f.exists() ? (info = (SiteInformation)Json.fromJson(SiteInformation.class, (Reader)Streams.fileInr((File)f))) : (info = new SiteInformation());
        return info;
    }

    public void writeXmlFile(Document doc, String file) throws IOException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        FileOutputStream fos = new FileOutputStream(new File(file));
        XMLWriter xmlwriter = new XMLWriter((OutputStream)fos, format);
        xmlwriter.write(doc);
        xmlwriter.close();
        fos.close();
    }

    public static String getWebInfoPath(ServletContext context) {
        String path = context.getRealPath("/");
        path = path + "WEB-INF" + File.separator;
        return path;
    }

    public static void writeSiteInfo(ServletContext context, SiteInformation info) {
        info.setWhen(new Date());
        String json = Json.toJson((Object)info);
        Util.WriteStringToFile(SiteUtil.getSiteInfoFile(context), json);
        KsyztServer.SITEINFO = info;
    }

    public static String getUrlRewtireConfigureFile(ServletContext context) {
        return SiteUtil.getWebInfoPath(context) + "urlrewrite.xml";
    }

    public static String getAdminUserFile(ServletContext context) {
        return SiteUtil.getWebInfoPath(context) + "admin.json";
    }

    public static AdminUser confirmAdminUser(ServletContext context) throws AdminLoginException {
        AdminUser u = null;
        File f = new File(SiteUtil.getAdminUserFile(context));
        if (!f.exists()) {
            throw new AdminLoginException(1, "\u7b2c\u4e00\u6b21\u4f7f\u7528\u672c\u7cfb\u7edf\uff0c\u8bf7\u8bbe\u7f6e\u7528\u6237\u540d\u548c\u5bc6\u7801");
        }
        u = (AdminUser)Json.fromJson(AdminUser.class, (Reader)Streams.fileInr((File)f));
        return u;
    }

    public static AdminUser writeAdminUser(ServletContext context, AdminUser user) throws AdminLoginException {
        String json = Json.toJson((Object)user);
        Util.WriteStringToFile(SiteUtil.getAdminUserFile(context), json);
        return user;
    }

    public static List<RewriteData> getRewriteDataFromMemory(ServletContext context) {
        List<RewriteData> info = KsyztServer.REWRITEDATA;
        if (info != null) {
            return info;
        }
        info = new ArrayList<RewriteData>();
        File f = new File(SiteUtil.getUrlRewtireConfigureFile(context));
        if (f.exists()) {
            String text = "";
            try {
                text = Util.readTextFile(f);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Document doc = DocumentHelper.parseText((String)text);
                Element root = doc.getRootElement();
                List rules = root.elements("rule");
                for (Element e : rules) {
                    String note = e.elementTextTrim("note");
                    String from = e.elementText("from");
                    String to = e.elementText("to");
                    RewriteData d = new RewriteData();
                    d.desc = note;
                    d.from = from;
                    d.to = to;
                    info.add(d);
                }
            }
            catch (Exception e) {
                System.out.println("SystemConsole urlrewrite>" + e.getMessage());
            }
        }
        return info;
    }

    public static void writeRewriteData(ServletContext context, List<RewriteData> list) {
        File f = new File(SiteUtil.getUrlRewtireConfigureFile(context));
        try {
            Document doc = DocumentHelper.createDocument();
            doc.setXMLEncoding("UTF-8");
            doc.addDocType("urlrewrite", "-//tuckey.org//DTD UrlRewrite 4.0//EN", "http://www.tuckey.org/res/dtds/urlrewrite4.0.dtd");
            Element root = DocumentHelper.createElement((String)"urlrewrite");
            doc.setRootElement(root);
            for (RewriteData d : list) {
                Element e = root.addElement("rule");
                Element n = e.addElement("note");
                n.setText(d.desc);
                n = e.addElement("from");
                n.setText(d.from);
                n = e.addElement("to");
                n.setText(d.to);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            FileOutputStream fos = new FileOutputStream(f);
            XMLWriter xmlwriter = new XMLWriter((OutputStream)fos, format);
            xmlwriter.write(doc);
            xmlwriter.close();
            fos.close();
        }
        catch (Exception e) {
            System.out.println("SystemConsole urlrewrite>" + e.getMessage());
        }
    }
}

