/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class Thumbnail {
    private String srcFile;
    private String destFile;
    private int width;
    private int height;
    private Image img;

    public static void main(String[] args) throws Exception {
    }

    public Thumbnail(String fileName, String dest) throws IOException {
        File _file = new File(fileName);
        this.srcFile = _file.getName();
        this.destFile = dest;
        this.img = ImageIO.read(_file);
        this.width = this.img.getWidth(null);
        this.height = this.img.getHeight(null);
    }

    public void resize(int w, int h) throws IOException {
        BufferedImage _image = new BufferedImage(w, h, 1);
        _image.getGraphics().drawImage(this.img.getScaledInstance(w, h, 4), 0, 0, w, h, null);
        Thumbnail.saveImage(_image, this.destFile);
    }

    static void saveImage(BufferedImage dstImage, String dstName) throws IOException {
        String formatName = dstName.substring(dstName.lastIndexOf(".") + 1);
        ImageIO.write((RenderedImage)dstImage, formatName, new File(dstName));
    }

    public void resize(double t) throws IOException {
        int w = (int)((double)this.width * t);
        int h = (int)((double)this.height * t);
        this.resize(w, h);
    }

    public void resizeByWidth(int w) throws IOException {
        int h = this.height * w / this.width;
        this.resize(w, h);
    }

    public void resizeByHeight(int h) throws IOException {
        int w = this.width * h / this.height;
        this.resize(w, h);
    }

    public void resizeFix(int w, int h) throws IOException {
        if (this.width / this.height > w / h) {
            this.resizeByWidth(w);
        } else {
            this.resizeByHeight(h);
        }
    }

    public void setDestFile(String fileName) throws Exception {
        if (!fileName.endsWith(".jpg")) {
            throw new Exception("Dest File Must end with \".jpg\".");
        }
        this.destFile = fileName;
    }

    public String getDestFile() {
        return this.destFile;
    }

    public int getSrcWidth() {
        return this.width;
    }

    public int getSrcHeight() {
        return this.height;
    }
}

