/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimestampTypeAdapter
implements JsonSerializer<Timestamp>,
JsonDeserializer<Timestamp> {
    private static final DateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public Timestamp deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        try {
            if (jsonElement == null || jsonElement.isJsonNull()) {
                return null;
            }
            Date date = format.parse(jsonElement.getAsString());
            return new Timestamp(date.getTime());
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public JsonElement serialize(Timestamp timestamp, Type type, JsonSerializationContext jsonSerializationContext) {
        if (timestamp == null) {
            return new JsonPrimitive("");
        }
        String string = format.format(new Date(timestamp.getTime()));
        return new JsonPrimitive(string);
    }
}

