/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Random;
import org.dom4j.Attribute;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class Util {
    private static DateFormat df = DateFormat.getDateInstance(2, Locale.SIMPLIFIED_CHINESE);
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static void WriteToFile(String filename, byte[] content) {
        try {
            FileOutputStream fo = new FileOutputStream(filename);
            fo.write(content);
            fo.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String readUTF8TextFile(String fileName) {
        byte[] bytes = Util.ReadFromFile(fileName);
        String str = "";
        try {
            str = new String(bytes, "UTF-8");
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static String readTextFile(String fileName, String encoding) {
        byte[] bytes = Util.ReadFromFile(fileName);
        String str = "";
        try {
            str = new String(bytes, encoding);
            return str;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return str;
        }
    }

    public static byte[] ReadFromFile(String fileName) {
        File ff = new File(fileName);
        long filelength = ff.length();
        byte[] code = new byte[(int)filelength];
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            ((InputStream)inStream).read(code);
            ((InputStream)inStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return code;
    }

    private String getLocalIP() {
        try {
            Enumeration<NetworkInterface> netinterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (netinterfaces.hasMoreElements()) {
                NetworkInterface ni = netinterfaces.nextElement();
                if (!ni.getInetAddresses().hasMoreElements()) continue;
                ip = ni.getInetAddresses().nextElement();
                if (!ip.isSiteLocalAddress() && !ip.isLoopbackAddress() && ip.getHostAddress().indexOf(":") == -1) {
                    return ip.toString();
                }
                ip = null;
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        return Util.randomDigital(15);
    }

    public static void text(Element e, String v) {
        e.add(DocumentHelper.createText((String)v));
    }

    public static final String int2path(int v) {
        String id = v + "";
        String str = "";
        for (int i = 0; i < id.length(); ++i) {
            str = str + id.charAt(i) + "/";
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fileFromPath, String fileToPath) throws IOException {
        FileInputStream in = null;
        OutputStream out = null;
        try {
            in = new FileInputStream(fileFromPath);
            out = new FileOutputStream(fileToPath);
            byte[] b = new byte[1024];
            int count = ((InputStream)in).read(b);
            while (count > 0) {
                out.write(b, 0, count);
                count = ((InputStream)in).read(b);
            }
        }
        finally {
            if (in != null) {
                ((InputStream)in).close();
            }
            if (out != null) {
                out.close();
            }
        }
    }

    public static void attr(Element e, String name, String v) {
        Attribute at;
        if (name == null || name.equals("")) {
            return;
        }
        if (v == null) {
            v = "";
        }
        if ((at = e.attribute(name)) == null) {
            at = DocumentHelper.createAttribute((Element)e, (String)name, (String)v);
            e.add(at);
        } else {
            at.setValue(v);
        }
    }

    public static void WriteStringToFile(String fn, String dest) {
        FileOutputStream fo = null;
        try {
            fo = new FileOutputStream(fn);
            fo.write(dest.getBytes("UTF-8"));
            fo.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeToFile(File source, String dest) {
        String r = "true";
        FileOutputStream fo = null;
        FileInputStream fi = null;
        try {
            fo = new FileOutputStream(dest);
            fi = new FileInputStream(source);
            byte[] buffer = new byte[8192];
            int l = 0;
            l = fi.read(buffer);
            while (l > -1) {
                fo.write(buffer, 0, l);
                l = fi.read(buffer);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            r = e.getMessage();
        }
        catch (IOException e) {
            e.printStackTrace();
            r = e.getMessage();
        }
        finally {
            try {
                fo.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return r;
    }

    public static String readTextFile(File source) throws IOException {
        String text = "";
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(source), "UTF-8");
        BufferedReader br = new BufferedReader(isr);
        String data = br.readLine();
        while (data != null) {
            text = text + data;
            text = text + "\r\n";
            data = br.readLine();
        }
        br.close();
        return text;
    }

    public static StringBuilder readFromFile(File source) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(source));
        String data = br.readLine();
        while (data != null) {
            sb.append(data);
            sb.append("\r\n");
            data = br.readLine();
        }
        br.close();
        return sb;
    }

    public static String getLocalAddress() {
        Enumeration<NetworkInterface> allNetInterfaces;
        try {
            allNetInterfaces = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            e.printStackTrace();
            return "NO";
        }
        InetAddress ip = null;
        String ips = "";
        while (allNetInterfaces.hasMoreElements()) {
            NetworkInterface netInterface = allNetInterfaces.nextElement();
            Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ip = addresses.nextElement();
                if (ip == null || !(ip instanceof Inet4Address)) continue;
                ips = ips + ip.getHostAddress() + " ";
            }
        }
        return ips;
    }

    public static String getHeadIconPathById(int id) {
        String si = String.valueOf(id);
        StringBuilder sb = new StringBuilder(32);
        for (int i = 0; i < si.length(); ++i) {
            sb.append(si.charAt(i));
            sb.append("/");
        }
        return sb.toString();
    }

    public static int getDiffYear(Timestamp start, Timestamp end) {
        return end.getYear() - start.getYear();
    }

    public static Timestamp addTime(Timestamp start, int year, int month, int day) {
        return new Timestamp(start.getTime() + (long)(year * 365 * 24 * 60 * 60 * 1000) + (long)(month * 30 * 24 * 60 * 60 * 1000) + (long)(day * 24 * 60 * 60 * 1000));
    }

    public static final Timestamp getCurrentSQLTimestamp() {
        Calendar c = Calendar.getInstance();
        Timestamp t = new Timestamp(c.getTimeInMillis());
        return t;
    }

    public static final Timestamp toSQLTimestamp(String time) {
        return Timestamp.valueOf(time);
    }

    public static final Timestamp toSQLTimestamp2(String time) {
        java.util.Date d = Util.getStrDate(time);
        return Util.dateToSQLTimestamp(d);
    }

    public static Timestamp dateToSQLTimestamp(java.util.Date date) {
        if (date == null) {
            return Timestamp.valueOf("2070-06-06 12:00:00");
        }
        String s = df.format(date);
        return Timestamp.valueOf(s + " 12:00:00");
    }

    public static String getNowTime() {
        GregorianCalendar gcNow = new GregorianCalendar();
        java.util.Date dNow = gcNow.getTime();
        DateFormat df = DateFormat.getTimeInstance(2, Locale.SIMPLIFIED_CHINESE);
        return df.format(dNow);
    }

    public static String getNowDate() {
        GregorianCalendar gcNow = new GregorianCalendar();
        java.util.Date dNow = gcNow.getTime();
        DateFormat df = DateFormat.getDateInstance(2, Locale.SIMPLIFIED_CHINESE);
        return df.format(dNow);
    }

    public static java.util.Date getNow() {
        GregorianCalendar gcNow = new GregorianCalendar();
        java.util.Date dNow = gcNow.getTime();
        return dNow;
    }

    public static Date getNowDate2() {
        return Date.valueOf(Util.getCurrentSQLTimestamp().toString().substring(0, 10));
    }

    public static String getNowDateTime() {
        GregorianCalendar gcNow = new GregorianCalendar();
        java.util.Date dNow = gcNow.getTime();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, Locale.SIMPLIFIED_CHINESE);
        return df.format(dNow);
    }

    public static int getThisYear() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(1);
    }

    public static int getThisMonth() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(2) + 1;
    }

    public static int getToDayOfMonth() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(5);
    }

    public static int getHour() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(10);
    }

    public static int getMinute() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(12);
    }

    public static int getSecond() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(13);
    }

    public static int getToWeekOfYear() {
        GregorianCalendar gcNow = new GregorianCalendar();
        return gcNow.get(3);
    }

    public static String formatDate(java.util.Date date) {
        if (date == null) {
            return "";
        }
        return df.format(date);
    }

    public static String formatSDate(java.util.Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("yyyy-M-d HH:mm:ss");
        return bartDateFormat.format(date);
    }

    public static String dateAdd(String interval, int number, java.util.Date date) {
        int currDay;
        String strTmp = "";
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        if (interval.equals("y")) {
            int currYear = gc.get(1);
            gc.set(1, currYear + number);
        } else if (interval.equals("m")) {
            int currMonth = gc.get(2);
            gc.set(2, currMonth + number);
        } else if (interval.equals("d")) {
            currDay = gc.get(5);
            gc.set(5, currDay + number);
        } else if (interval.equals("h")) {
            currDay = gc.get(10);
            gc.set(10, currDay + number);
        }
        SimpleDateFormat bartDateFormat = new SimpleDateFormat("yyyy-M-d HH:mm:ss");
        strTmp = bartDateFormat.format(gc.getTime());
        return strTmp;
    }

    public static int dateDiff(java.util.Date a, java.util.Date b) {
        int tempDifference = 0;
        int difference = 0;
        Calendar earlier = Calendar.getInstance();
        Calendar later = Calendar.getInstance();
        if (a.compareTo(b) < 0) {
            earlier.setTime(a);
            later.setTime(b);
        } else {
            earlier.setTime(b);
            later.setTime(a);
        }
        while (earlier.get(1) != later.get(1)) {
            tempDifference = 365 * (later.get(1) - earlier.get(1));
            difference += tempDifference;
            earlier.add(6, tempDifference);
        }
        if (earlier.get(6) != later.get(6)) {
            tempDifference = later.get(6) - earlier.get(6);
            difference += tempDifference;
            earlier.add(6, tempDifference);
        }
        return difference;
    }

    public static int getDate(int curYear, int curMonth, int curDate) {
        int day1 = 0;
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(curYear, curMonth - 1, curDate);
        int dayOfWeek = cal.get(7);
        System.out.println("curDate=" + curDate + " dayOfWeek " + dayOfWeek);
        switch (dayOfWeek) {
            case 1: {
                day1 = 0;
                break;
            }
            case 2: {
                day1 = 1;
                break;
            }
            case 3: {
                day1 = 2;
                break;
            }
            case 4: {
                day1 = 3;
                break;
            }
            case 5: {
                day1 = 4;
                break;
            }
            case 6: {
                day1 = 5;
                break;
            }
            case 7: {
                day1 = 6;
            }
        }
        return day1;
    }

    public static String checkTime(int id) {
        String bol = "";
        Calendar tt = Calendar.getInstance();
        String currDate = Util.getNowDate();
        System.out.println("currDate=" + currDate);
        int result = tt.get(7);
        int shour = tt.get(11);
        if (id == 3) {
            switch (result) {
                case 1: {
                    break;
                }
                case 7: {
                    if (shour >= 8 && shour < 12) {
                        bol = "disabled";
                        break;
                    }
                }
                default: {
                    if (shour >= 8 && shour < 12) {
                        bol = "disabled";
                        break;
                    }
                    if (shour < 14 || shour >= 17) break;
                    bol = "disabled";
                }
            }
        }
        return bol;
    }

    public static java.util.Date getStrDate(String strX) {
        java.util.Date date1 = new java.util.Date();
        if (!strX.equals("")) {
            try {
                date1 = DateFormat.getDateInstance().parse(strX);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
        } else {
            GregorianCalendar gcNow = new GregorianCalendar();
            date1 = gcNow.getTime();
        }
        return date1;
    }

    public static int compareDate(String d1, String d2) {
        int vl = 1;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(Util.getStrDate(d1));
        int year = gc.get(1);
        int month = gc.get(2);
        int day = gc.get(5);
        gc.setTime(Util.getStrDate(d2));
        int tempYear = gc.get(1);
        int tempMonth = gc.get(2);
        int tempDay = gc.get(5);
        if (year != tempYear) {
            vl = year > tempYear ? 2 : 0;
        } else if (month != tempMonth) {
            vl = month > tempMonth ? 2 : 0;
        } else if (day != tempDay) {
            vl = day > tempDay ? 2 : 0;
        }
        return vl;
    }

    public static String getDateString(long l, String format) {
        String v = new SimpleDateFormat(format).format(new java.util.Date(l));
        return v;
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static final String randomDigital(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(10)];
        }
        return new String(randBuffer);
    }

    public static final int randomNumber(int max) {
        return randGen.nextInt(max);
    }

    public static String getString(Object o) {
        if (o == null) {
            return "NULL";
        }
        return o.toString();
    }

    public static String formatInteger(int i, int j) {
        String frm = "%0" + j + "d";
        String s = String.format(frm, i);
        return s;
    }

    public static Timestamp valueoftime(String b) {
        return Timestamp.valueOf(b + " 00:00:00.000000000");
    }

    public static Timestamp valueoftime2(String b) {
        return Timestamp.valueOf(b + " 24:00:00.000000000");
    }

    public static void main(String[] args) {
        GregorianCalendar gcNow = new GregorianCalendar();
        java.util.Date dNow = gcNow.getTime();
        String t = Util.getLocalAddress();
        System.out.println(t);
    }

    public static String escape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length() * 6);
        for (int i = 0; i < src.length(); ++i) {
            char j = src.charAt(i);
            if (Character.isDigit(j) || Character.isLowerCase(j) || Character.isUpperCase(j)) {
                tmp.append(j);
                continue;
            }
            if (j < '\u0100') {
                tmp.append("%");
                if (j < '\u0010') {
                    tmp.append("0");
                }
                tmp.append(Integer.toString(j, 16));
                continue;
            }
            tmp.append("%u");
            tmp.append(Integer.toString(j, 16));
        }
        return tmp.toString();
    }

    public static String unescape(String src) {
        StringBuffer tmp = new StringBuffer();
        tmp.ensureCapacity(src.length());
        int lastPos = 0;
        int pos = 0;
        while (lastPos < src.length()) {
            pos = src.indexOf("%", lastPos);
            if (pos == lastPos) {
                char ch;
                if (src.charAt(pos + 1) == 'u') {
                    ch = (char)Integer.parseInt(src.substring(pos + 2, pos + 6), 16);
                    tmp.append(ch);
                    lastPos = pos + 6;
                    continue;
                }
                ch = (char)Integer.parseInt(src.substring(pos + 1, pos + 3), 16);
                tmp.append(ch);
                lastPos = pos + 3;
                continue;
            }
            if (pos == -1) {
                tmp.append(src.substring(lastPos));
                lastPos = src.length();
                continue;
            }
            tmp.append(src.substring(lastPos, pos));
            lastPos = pos;
        }
        return tmp.toString();
    }
}

