/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.BreakIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;

public class Utility {
    private static final char[] QUOTE_ENCODE = "&quot;".toCharArray();
    private static final char[] AMP_ENCODE = "&amp;".toCharArray();
    private static final char[] LT_ENCODE = "&lt;".toCharArray();
    private static final char[] GT_ENCODE = "&gt;".toCharArray();
    private static MessageDigest digest = null;
    private static final int fillchar = 61;
    private static final String cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private static Random randGen = new Random();
    private static char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] zeroArray = "0000000000000000".toCharArray();

    public static final Timestamp string2Time(String dateString) throws ParseException {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
        dateFormat.setLenient(false);
        java.util.Date timeDate = dateFormat.parse(dateString);
        Timestamp dateTime = new Timestamp(timeDate.getTime());
        return dateTime;
    }

    public static boolean checkEmail(String email) {
        String ps = "^([\\w-\\.]+)@[\\w-.]+(\\.?[a-zA-Z]{2,4}$)";
        Pattern p = Pattern.compile(ps);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static final String replace(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            return buf.toString();
        }
        return line;
    }

    public static final String replaceIgnoreCase(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        String lcLine = line.toLowerCase();
        String lcOldString = oldString.toLowerCase();
        int i = 0;
        if ((i = lcLine.indexOf(lcOldString, i)) >= 0) {
            int counter = 0;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = lcLine.indexOf(lcOldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String replace(String line, String oldString, String newString, int[] count) {
        if (line == null) {
            return null;
        }
        int i = 0;
        if ((i = line.indexOf(oldString, i)) >= 0) {
            int counter = 0;
            ++counter;
            char[] line2 = line.toCharArray();
            char[] newString2 = newString.toCharArray();
            int oLength = oldString.length();
            StringBuffer buf = new StringBuffer(line2.length);
            buf.append(line2, 0, i).append(newString2);
            int j = i += oLength;
            while ((i = line.indexOf(oldString, i)) > 0) {
                ++counter;
                buf.append(line2, j, i - j).append(newString2);
                j = i += oLength;
            }
            buf.append(line2, j, line2.length - j);
            count[0] = counter;
            return buf.toString();
        }
        return line;
    }

    public static final String escapeHTMLTags(String in) {
        int i;
        if (in == null) {
            return null;
        }
        int last = 0;
        char[] input = in.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch != '>') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(GT_ENCODE);
        }
        if (last == 0) {
            return in;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final synchronized String hash(String data) {
        if (digest == null) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException nsae) {
                System.err.println("Failed to load the MD5 MessageDigest. Jive will be unable to function normally.");
                nsae.printStackTrace();
            }
        }
        digest.update(data.getBytes());
        return Utility.encodeHex(digest.digest());
    }

    public static final String encodeHex(byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            if ((bytes[i] & 0xFF) < 16) {
                buf.append("0");
            }
            buf.append(Long.toString(bytes[i] & 0xFF, 16));
        }
        return buf.toString();
    }

    public static final byte[] decodeHex(String hex) {
        char[] chars = hex.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int byteCount = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | Utility.hexCharToByte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[byteCount] = newByte = (byte)(newByte | Utility.hexCharToByte(chars[i + 1]));
            ++byteCount;
        }
        return bytes;
    }

    private static final byte hexCharToByte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'a': {
                return 10;
            }
            case 'b': {
                return 11;
            }
            case 'c': {
                return 12;
            }
            case 'd': {
                return 13;
            }
            case 'e': {
                return 14;
            }
            case 'f': {
                return 15;
            }
        }
        return 0;
    }

    public static String encodeBase64(String data) {
        return Utility.encodeBase64(data.getBytes());
    }

    public static String encodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer((len / 3 + 1) * 4);
        for (int i = 0; i < len; ++i) {
            int c = data[i] >> 2 & 0x3F;
            ret.append(cvt.charAt(c));
            c = data[i] << 4 & 0x3F;
            if (++i < len) {
                c |= data[i] >> 4 & 0xF;
            }
            ret.append(cvt.charAt(c));
            if (i < len) {
                c = data[i] << 2 & 0x3F;
                if (++i < len) {
                    c |= data[i] >> 6 & 3;
                }
                ret.append(cvt.charAt(c));
            } else {
                ++i;
                ret.append('=');
            }
            if (i < len) {
                c = data[i] & 0x3F;
                ret.append(cvt.charAt(c));
                continue;
            }
            ret.append('=');
        }
        return ret.toString();
    }

    public static String decodeBase64(String data) {
        return Utility.decodeBase64(data.getBytes());
    }

    public static String decodeBase64(byte[] data) {
        int len = data.length;
        StringBuffer ret = new StringBuffer(len * 3 / 4);
        for (int i = 0; i < len; ++i) {
            int c = cvt.indexOf(data[i]);
            int c1 = cvt.indexOf(data[++i]);
            c = c << 2 | c1 >> 4 & 3;
            ret.append((char)c);
            if (++i < len) {
                c = data[i];
                if (61 == c) break;
                c = cvt.indexOf((char)c);
                c1 = c1 << 4 & 0xF0 | c >> 2 & 0xF;
                ret.append((char)c1);
            }
            if (++i >= len) continue;
            c1 = data[i];
            if (61 == c1) break;
            c1 = cvt.indexOf((char)c1);
            c = c << 6 & 0xC0 | c1;
            ret.append((char)c);
        }
        return ret.toString();
    }

    public static void decodeBase64(String base64, String fname) throws IOException {
        byte[] out = Base64.decodeBase64((byte[])base64.getBytes());
        Utility.WriteToFile(fname, out);
    }

    public static String encodeBase64File(String fname) throws IOException, IOException {
        byte[] in = Utility.ReadFromFile(fname);
        byte[] out = Base64.encodeBase64((byte[])in);
        return new String(out, "GB2312");
    }

    public static final String[] toLowerCaseWordArray(String text) {
        if (text == null || text.length() == 0) {
            return new String[0];
        }
        ArrayList<String> wordList = new ArrayList<String>();
        BreakIterator boundary = BreakIterator.getWordInstance();
        boundary.setText(text);
        int start = 0;
        int end = boundary.next();
        while (end != -1) {
            String tmp = text.substring(start, end).trim();
            tmp = Utility.replace(tmp, "+", "");
            tmp = Utility.replace(tmp, "/", "");
            tmp = Utility.replace(tmp, "\\", "");
            tmp = Utility.replace(tmp, "#", "");
            tmp = Utility.replace(tmp, "*", "");
            tmp = Utility.replace(tmp, ")", "");
            tmp = Utility.replace(tmp, "(", "");
            if ((tmp = Utility.replace(tmp, "&", "")).length() > 0) {
                wordList.add(tmp);
            }
            start = end;
            end = boundary.next();
        }
        return wordList.toArray(new String[wordList.size()]);
    }

    public static final String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static final String randomDigital(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(10)];
        }
        return new String(randBuffer);
    }

    public static String replaceCRLF(String p) {
        p = Utility.escapeForXML(p);
        p = p.replace("\n", "<br>");
        return p;
    }

    public static String replaceAMP(String p) {
        p = p.replace("&amp;", "&");
        return p;
    }

    public static String replaceCRLF2(String p) {
        p = Utility.escapeForXML(p);
        p = p.replace("\\r\\n", "<br>");
        return p;
    }

    public static final String chopAtWord(String string, int length) {
        int i;
        if (string == null) {
            return string;
        }
        char[] charArray = string.toCharArray();
        int sLength = string.length();
        if (length < sLength) {
            sLength = length;
        }
        for (i = 0; i < sLength - 1; ++i) {
            if (charArray[i] == '\r' && charArray[i + 1] == '\n') {
                return string.substring(0, i + 1);
            }
            if (charArray[i] != '\n') continue;
            return string.substring(0, i);
        }
        if (charArray[sLength - 1] == '\n') {
            return string.substring(0, sLength - 1);
        }
        if (string.length() < length) {
            return string;
        }
        for (i = length - 1; i > 0; --i) {
            if (charArray[i] != ' ') continue;
            return string.substring(0, i).trim();
        }
        return string.substring(0, length);
    }

    public static final String escapeForXML(String string) {
        int i;
        if (string == null) {
            return null;
        }
        int last = 0;
        char[] input = string.toCharArray();
        int len = input.length;
        StringBuffer out = new StringBuffer((int)((double)len * 1.3));
        for (i = 0; i < len; ++i) {
            char ch = input[i];
            if (ch > '>') continue;
            if (ch == '<') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(LT_ENCODE);
                continue;
            }
            if (ch == '&') {
                if (i > last) {
                    out.append(input, last, i - last);
                }
                last = i + 1;
                out.append(AMP_ENCODE);
                continue;
            }
            if (ch != '\"') continue;
            if (i > last) {
                out.append(input, last, i - last);
            }
            last = i + 1;
            out.append(QUOTE_ENCODE);
        }
        if (last == 0) {
            return string;
        }
        if (i > last) {
            out.append(input, last, i - last);
        }
        return out.toString();
    }

    public static final String unescapeFromXML(String string) {
        string = Utility.replace(string, "&lt;", "<");
        string = Utility.replace(string, "&gt;", ">");
        string = Utility.replace(string, "&quot;", "\"");
        return Utility.replace(string, "&amp;", "&");
    }

    public static final String zeroPadString(String string, int length) {
        if (string == null || string.length() > length) {
            return string;
        }
        StringBuffer buf = new StringBuffer(length);
        buf.append(zeroArray, 0, length - string.length()).append(string);
        return buf.toString();
    }

    public static final String dateToMillis(java.util.Date date) {
        return Utility.zeroPadString(Long.toString(date.getTime()), 15);
    }

    public static String encrypt(String originalStr) {
        return Utility.hash(originalStr);
    }

    public static String ChineseStringToUTF(String s) {
        try {
            return new String(s.getBytes(), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return s;
        }
    }

    public static long getNowLong() {
        long nCurrentTime = System.currentTimeMillis();
        return nCurrentTime;
    }

    public static java.util.Date getNowDate() {
        java.util.Date utilDate = new java.util.Date(Utility.getNowLong());
        return utilDate;
    }

    public static Date getNowSQLDate() {
        Date sqlDate = new Date(Utility.getNowLong());
        return sqlDate;
    }

    public static Time getNowSQLTime() {
        Time sqlTime = new Time(Utility.getNowLong());
        return sqlTime;
    }

    public static Timestamp getNowSQLTimestamp() {
        Timestamp sqlTimestamp = new Timestamp(Utility.getNowLong());
        return sqlTimestamp;
    }

    public static String TranslateTags(String tags) {
        String[] tagss = tags.split(" ");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tagss.length; ++i) {
            sb.append("&nbsp;<a href=\"post_tagSearch.jsp?tag=" + tagss[i] + "\">" + tagss[i] + "</a>");
        }
        return sb.toString();
    }

    public static String getUserLink(BigDecimal id, String name) {
        return "<a href='person.jsp?uid=" + id.toString() + "'>" + name + "</a>";
    }

    public static boolean isDigital(String s) {
        boolean b = true;
        if (s == null || s.equals("")) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') continue;
            b = false;
            break;
        }
        return b;
    }

    public static String getDateString(long l) {
        String v = new SimpleDateFormat("yyyy-MM-dd HH:mm").format(new java.util.Date(l));
        return v;
    }

    public static String getString(Object o) {
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static void WriteToFile(String filename, byte[] content) {
        try {
            FileOutputStream fo = new FileOutputStream(filename);
            fo.write(content);
            fo.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static byte[] ReadFromFile(String fileName) {
        File ff = new File(fileName);
        long filelength = ff.length();
        byte[] code = new byte[(int)filelength];
        try {
            FileInputStream inStream = new FileInputStream(fileName);
            ((InputStream)inStream).read(code);
            ((InputStream)inStream).close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return code;
    }

    public static String toUtf8String(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            byte[] b;
            char c = s.charAt(i);
            if (c >= '\u0000' && c <= '\u00ff') {
                sb.append(c);
                continue;
            }
            try {
                b = Character.toString(c).getBytes("utf-8");
            }
            catch (Exception ex) {
                b = new byte[]{};
            }
            for (int j = 0; j < b.length; ++j) {
                int k = b[j];
                if (k < 0) {
                    k += 256;
                }
                sb.append("%" + Integer.toHexString(k).toUpperCase());
            }
        }
        return sb.toString();
    }

    public static String longRstr(long lon, String str) {
        String rstr = "";
        if (lon < 1L) {
            return rstr;
        }
        SimpleDateFormat df = new SimpleDateFormat(str);
        try {
            rstr = df.format(new java.util.Date(lon));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rstr;
    }
}

