/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipUtility {
    public static final String EXT = ".zip";
    private static final String BASE_DIR = "";
    private static final String PATH = File.separator;
    private static final int BUFFER = 1024;

    public static String getClassFile(Class clazz) {
        try {
            String url = ZipUtility.getClassPath(clazz);
            if (url != null) {
                int pos = url.lastIndexOf("!");
                if (pos > 0) {
                    return url.substring(0, pos);
                }
                return null;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getClassPath(Class clazz) throws Exception {
        try {
            String strClassName = clazz.getName();
            String strPackageName = BASE_DIR;
            if (clazz.getPackage() != null) {
                strPackageName = clazz.getPackage().getName();
            }
            String strClassFileName = BASE_DIR;
            strClassFileName = !BASE_DIR.equals(strPackageName) ? strClassName.substring(strPackageName.length() + 1, strClassName.length()) : strClassName;
            URL url = null;
            url = clazz.getResource(strClassFileName + ".class");
            String strURL = url.toString();
            strURL = strURL.substring(strURL.indexOf(47), strURL.lastIndexOf(47));
            return strURL;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static void decompress(String srcPath, String sourcepath, String replacepath) throws Exception {
        File srcFile = new File(srcPath);
        ZipUtility.decompress(srcFile, sourcepath, replacepath);
    }

    public static void decompress(File srcFile, String sourcepath, String replacepath) throws Exception {
        String basePath = srcFile.getParent();
        ZipUtility.decompress(srcFile, basePath, sourcepath, replacepath);
    }

    public static void decompress(File srcFile, File destFile, String sourcepath, String replacepath) throws Exception {
        CheckedInputStream cis = new CheckedInputStream(new FileInputStream(srcFile), new CRC32());
        ZipInputStream zis = new ZipInputStream(cis);
        ZipUtility.decompress(destFile, zis, sourcepath, replacepath);
        zis.close();
    }

    public static void decompress(File srcFile, String destPath, String sourcepath, String replacepath) throws Exception {
        ZipUtility.decompress(srcFile, new File(destPath), sourcepath, replacepath);
    }

    public static void decompress(String srcPath, String destPath, String sourcePath, String replacepath) throws Exception {
        File srcFile = new File(srcPath);
        ZipUtility.decompress(srcFile, destPath, sourcePath, replacepath);
    }

    private static void decompress(File destFile, ZipInputStream zis, String sourcepath, String replacepath) throws Exception {
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            File dirFile;
            String dir;
            if (sourcepath != null && sourcepath.length() > 0) {
                if (entry.getName().startsWith(sourcepath)) {
                    dir = destFile.getPath() + File.separator + entry.getName();
                    if (replacepath != null) {
                        dir = destFile.getPath() + File.separator + replacepath + File.separator + entry.getName().substring(sourcepath.length());
                    }
                    System.out.println("****Extacte " + entry.getName() + "  to " + dir);
                    dirFile = new File(dir);
                    ZipUtility.fileProber(dirFile);
                    if (entry.isDirectory()) {
                        dirFile.mkdirs();
                    } else {
                        ZipUtility.decompressFile(dirFile, zis);
                    }
                }
            } else {
                dir = destFile.getPath() + File.separator + entry.getName();
                dirFile = new File(dir);
                ZipUtility.fileProber(dirFile);
                if (entry.isDirectory()) {
                    dirFile.mkdirs();
                } else {
                    ZipUtility.decompressFile(dirFile, zis);
                }
            }
            zis.closeEntry();
        }
    }

    private static void fileProber(File dirFile) {
        File parentFile = dirFile.getParentFile();
        if (!parentFile.exists()) {
            ZipUtility.fileProber(parentFile);
            parentFile.mkdir();
        }
    }

    private static void decompressFile(File destFile, ZipInputStream zis) throws Exception {
        int count;
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(destFile));
        byte[] data = new byte[1024];
        while ((count = zis.read(data, 0, 1024)) != -1) {
            bos.write(data, 0, count);
        }
        bos.close();
    }
}

