/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.fileupload;

import com.ksyzt.gwt.server.common.Util;
import com.ksyzt.gwt.server.fileupload.FileUploadListener;
import com.ksyzt.gwt.server.fileupload.FileUploadStatus;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

public class FileUploaderBase
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, String> extMap = new HashMap();
    protected long maxSize = 524288000L;
    protected String configPath = "upload";
    protected String dirTemp = "attached/temp";
    protected String dirName = "file";

    public void init() throws ServletException {
        this.extMap.put("file", "doc,docx,xls,xlsx,ppt,htm,html,txt,zip,rar,apk");
    }

    protected String getExtension(FileItem item) {
        String fileName = item.getName();
        String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1).toLowerCase();
        return fileExt;
    }

    protected String getFileName(FileItem item) {
        String fileName = item.getName();
        int index = (fileName = fileName.replace('\\', '/')).lastIndexOf(47);
        if (index >= 0) {
            fileName = fileName.substring(index + 1);
        }
        return fileName;
    }

    protected String getSaveFileName(FileItem item) {
        return Util.randomString(8) + "." + this.getFileName(item);
    }

    public void processFileUpload(HttpServletRequest request, PrintWriter out) throws ServletException, IOException {
        File dirTempFile;
        Date now = new Date();
        String dayPath = "/day_" + Util.getDateString(now.getTime(), "yyMMdd") + "/";
        String rootpath = this.getServletContext().getRealPath("/");
        String savePath = rootpath + "/" + this.configPath + dayPath;
        String tempPath = rootpath + this.dirTemp;
        File dirFile = new File(savePath);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        if (!(dirTempFile = new File(tempPath)).exists()) {
            dirTempFile.mkdirs();
        }
        DiskFileItemFactory factory = new DiskFileItemFactory();
        factory.setSizeThreshold(0x1400000);
        factory.setRepository(new File(tempPath));
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
        upload.setHeaderEncoding("UTF-8");
        FileUploadListener progressListener = new FileUploadListener(request);
        upload.setProgressListener((ProgressListener)progressListener);
        try {
            List items = upload.parseRequest(request);
            for (FileItem item : items) {
                long fileSize = item.getSize();
                if (item.isFormField()) continue;
                String newFileName = this.getSaveFileName(item);
                String pathName = this.configPath + "/" + dayPath + "/" + newFileName;
                if (item.getSize() > this.maxSize) {
                    this.setStatusMsg(request, "1", "\u4e0a\u4f20\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u9650\u5236\u3002", newFileName);
                    return;
                }
                String fileExt = this.getExtension(item);
                if (!Arrays.asList(this.extMap.get(this.dirName).split(",")).contains(fileExt)) {
                    this.setStatusMsg(request, "1", "\u4e0a\u4f20\u6587\u4ef6\u6269\u5c55\u540d\u662f\u4e0d\u5141\u8bb8\u7684\u6269\u5c55\u540d\u3002\u53ea\u5141\u8bb8" + this.extMap.get(this.dirName) + "\u683c\u5f0f\u3002", pathName);
                    return;
                }
                try {
                    File uploadedFile = new File(savePath, newFileName);
                    FileOutputStream os = new FileOutputStream(uploadedFile);
                    InputStream is = item.getInputStream();
                    byte[] buf = new byte[4096];
                    int length = 0;
                    while ((length = is.read(buf)) > 0) {
                        ((OutputStream)os).write(buf, 0, length);
                    }
                    os.flush();
                    ((OutputStream)os).close();
                    is.close();
                }
                catch (Exception e) {
                    this.setStatusMsg(request, "1", "\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\u3002", pathName);
                    return;
                }
                this.setStatusMsg(request, "2", "\u6587\u4ef6\u4e0a\u4f20\u6210\u529f\uff01", pathName);
            }
        }
        catch (FileUploadException e) {
            e.printStackTrace();
        }
    }

    private void setStatusMsg(HttpServletRequest request, String error, String message, String filepathname) {
        HttpSession session = request.getSession();
        FileUploadStatus status = (FileUploadStatus)session.getAttribute("upladeStatus");
        status.setError(error);
        status.setStatusMsg(message);
    }

    private void getStatusMsg(HttpServletRequest request, PrintWriter out) {
        HttpSession session = request.getSession();
        FileUploadStatus status = (FileUploadStatus)session.getAttribute("upladeStatus");
        System.out.println("\u8f93\u51fa\u4fe1\u606f\u5bf9\u8c61\uff1a" + status);
        out.println(status.toJSon());
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        request.setCharacterEncoding("UTF-8");
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        boolean isMultipart = FileUpload.isMultipartContent((HttpServletRequest)request);
        if (isMultipart) {
            this.processFileUpload(request, out);
        } else if (request.getParameter("uploadStatus") != null) {
            System.out.println("ajax \u8bfb\u53d6\u72b6\u6001\u00b7\u00b7\u00b7\u00b7");
            this.getStatusMsg(request, out);
        }
        out.flush();
        out.close();
    }
}

