/*
 * Decompiled with CFR 0.152.
 */
package com.ksyzt.gwt.server.servlet;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.ksyzt.gwt.client.service.ISiteManager;
import com.ksyzt.gwt.client.site.urlrewrite.RewriteData;
import com.ksyzt.gwt.server.common.SiteUtil;
import com.ksyzt.gwt.server.common.Utility;
import com.ksyzt.gwt.shared.exception.AdminLoginException;
import com.ksyzt.gwt.shared.module.AdminUser;
import com.ksyzt.gwt.shared.module.SiteInformation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SiteManagerServlet
extends RemoteServiceServlet
implements ISiteManager {
    private static final long serialVersionUID = 1L;

    @Override
    public SiteInformation updateSiteInformation(SiteInformation info) throws Exception {
        SiteUtil.writeSiteInfo(this.getServletContext(), info);
        return info;
    }

    @Override
    public SiteInformation getSiteInformation() throws Exception {
        return SiteUtil.getFromMemory(this.getServletContext(), false);
    }

    @Override
    public List<RewriteData> getRewriteData() throws Exception {
        return SiteUtil.getRewriteDataFromMemory(this.getServletContext());
    }

    @Override
    public List<RewriteData> updateRewriteData(RewriteData data) throws Exception {
        List<RewriteData> list = SiteUtil.getRewriteDataFromMemory(this.getServletContext());
        boolean handler = false;
        for (RewriteData d : list) {
            if (!d.from.equals(data.from)) continue;
            d.from = data.from;
            d.to = data.to;
            d.desc = data.desc;
            handler = true;
            break;
        }
        if (!handler) {
            list.add(data);
        }
        SiteUtil.writeRewriteData(this.getServletContext(), list);
        return list;
    }

    @Override
    public List<RewriteData> deleteRewriteData(RewriteData data) throws Exception {
        List<RewriteData> list = SiteUtil.getRewriteDataFromMemory(this.getServletContext());
        for (RewriteData d : list) {
            if (!d.from.equals(data.from)) continue;
            list.remove(d);
            break;
        }
        SiteUtil.writeRewriteData(this.getServletContext(), list);
        return list;
    }

    @Override
    public AdminUser adminLogin(String username, String pwd) throws AdminLoginException {
        if (username == null || username.length() == 0) {
            throw new AdminLoginException(2, "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pwd == null || pwd.length() == 0) {
            throw new AdminLoginException(2, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdminUser u = SiteUtil.confirmAdminUser(this.getServletContext());
        if (u != null) {
            if (!username.equals(u.getUserName())) {
                throw new AdminLoginException(2, "\u6ca1\u6709\u6b64\u7528\u6237");
            }
            if (!Utility.encrypt(pwd).equals(u.getPassword())) {
                throw new AdminLoginException(2, "\u5bc6\u7801\u9519\u8bef");
            }
            HttpSession session = ((HttpServletRequest)this.perThreadRequest.get()).getSession();
            session.setAttribute("sesison_admin_user", (Object)u);
        }
        return u;
    }

    @Override
    public AdminUser adminUpdate(String username, String pwd) throws AdminLoginException {
        if (username == null || username.length() == 0) {
            throw new AdminLoginException(2, "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (pwd == null || pwd.length() == 0) {
            throw new AdminLoginException(2, "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AdminUser u = new AdminUser();
        u.setPassword(Utility.encrypt(pwd));
        u.setUserName(username);
        SiteUtil.writeAdminUser(this.getServletContext(), u);
        HttpSession session = ((HttpServletRequest)this.perThreadRequest.get()).getSession();
        session.setAttribute("sesison_admin_user", (Object)u);
        return u;
    }

    @Override
    public AdminUser checkAdminLogin() throws AdminLoginException {
        HttpSession session = ((HttpServletRequest)this.perThreadRequest.get()).getSession();
        AdminUser u = (AdminUser)session.getAttribute("sesison_admin_user");
        if (u == null) {
            u = SiteUtil.confirmAdminUser(this.getServletContext());
            return null;
        }
        return u;
    }

    @Override
    public void quit() {
        HttpSession session = ((HttpServletRequest)this.perThreadRequest.get()).getSession();
        session.setAttribute("sesison_admin_user", null);
    }
}

