/*
 * Decompiled with CFR 0.152.
 */
package cn.mapway.spring.processor;

import cn.mapway.spring.processor.ModuleTypeHolder;
import com.squareup.javapoet.ClassName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.type.TypeMirror;

public class ModuleTypeHolders {
    List<ModuleTypeHolder> modules = new ArrayList<ModuleTypeHolder>();

    public void put(ClassName className) {
        String name = className.canonicalName();
        if (name.startsWith("java.lang.String")) {
            return;
        }
        boolean found = this.find(name);
        if (!found) {
            Class<?> forName = null;
            try {
                forName = Class.forName(className.canonicalName());
            }
            catch (ClassNotFoundException e) {
                System.out.println("\u627e\u4e0d\u5230\u7c7b " + className.canonicalName() + "\u7684\u5b9a\u4e49");
            }
            ModuleTypeHolder holder = new ModuleTypeHolder();
            holder.setTypeName(className);
            holder.setName(name);
            holder.setForName(forName);
            this.modules.add(holder);
        }
    }

    private boolean find(String name) {
        for (ModuleTypeHolder holder : this.modules) {
            if (!holder.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ModuleTypeHolder holder : this.modules) {
            sb.append(holder.toString()).append('\n');
        }
        return sb.toString();
    }

    public static void parseTypeMirror(TypeMirror mirror, List<TypeMirror> components) {
    }
}

